/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;

public class GWNetAddress {
    public static final int ENCODING_TYPE_GW = 1;
    public static final int ENCODING_TYPE_IP_V6 = 2;
    private static final String PORT_DELIMETER = ":";
    private static final String IPV6_ADDR_START_DELIMETER = "[";
    private static final String IPV6_ADDR_END_DELIMETER = "]";
    private int type = 1;
    private int port = -1;
    private String address;

    public GWNetAddress() {
        this.initGWNetAddress("0.0.0.0", -1, 1);
    }

    public GWNetAddress(String string) {
        this.initGWNetAddress(string, this.getPort(string), 1);
    }

    public GWNetAddress(byte[] byArray) {
        String string = new String(byArray);
        string = string.trim();
        this.initGWNetAddress(string, this.getPort(string), 1);
    }

    public GWNetAddress(byte[] byArray, int n) {
        String string = new String(byArray);
        string = string.trim();
        this.initGWNetAddress(string, n, 1);
    }

    public GWNetAddress(byte[] byArray, int n, int n2) {
        String string = new String(byArray);
        string = string.trim();
        this.initGWNetAddress(string, n, n2);
    }

    public GWNetAddress(String string, int n) {
        this.initGWNetAddress(string, n, 1);
    }

    public GWNetAddress(String string, int n, int n2) {
        this.initGWNetAddress(string, n, n2);
    }

    private void initGWNetAddress(String string, int n, int n2) {
        if (this.type != n2) {
            this.type = n2;
        }
        if (string.length() > 0) {
            this.setAddress(string);
        } else {
            this.address = new String("");
        }
        this.port = n;
    }

    private int getPort(String string) {
        int n = -1;
        int n2 = -1;
        if (string.length() > 0) {
            String string2;
            if (this.type == 2) {
                int n3 = string.indexOf(IPV6_ADDR_END_DELIMETER);
                if (n3 != -1) {
                    n2 = string.indexOf(PORT_DELIMETER, n3 + 1);
                }
            } else {
                n2 = string.indexOf(PORT_DELIMETER);
            }
            if (n2 != -1 && (string2 = string.substring(n2 + 1).trim()).length() > 0) {
                Integer n4 = new Integer(string2);
                n = n4;
            }
        }
        return n;
    }

    public byte[] getEncoding() {
        byte[] byArray = this.address.getBytes();
        String string = null;
        if (this.type == 2) {
            string = new String(IPV6_ADDR_START_DELIMETER);
            string = string.concat(this.address + IPV6_ADDR_END_DELIMETER);
        } else {
            string = new String(this.address);
        }
        if (string != null) {
            if ((this.type == 2 && string.length() > 2 || this.type == 1 && string.length() > 0) && this.port > -1) {
                string = string.concat(PORT_DELIMETER + this.port);
            }
            byArray = string.getBytes();
        }
        return byArray;
    }

    public String getAddress() {
        String string = new String(this.address);
        return string;
    }

    public byte[] getAddressBytes() {
        return this.address.getBytes();
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(String string) {
        String string2 = string;
        int n = -1;
        if (string.length() > 0) {
            String string3;
            if (this.type == 2) {
                int n2 = string.indexOf(IPV6_ADDR_START_DELIMETER);
                int n3 = string.indexOf(IPV6_ADDR_END_DELIMETER);
                if (n2 != -1 && n3 != -1) {
                    string2 = string.substring(n2 + 1, n3);
                    n = string.indexOf(PORT_DELIMETER, n3 + 1);
                }
                Debug.trace("Setting IPv6 Address: " + string2);
            } else {
                n = string.indexOf(PORT_DELIMETER);
                if (n != -1) {
                    string2 = string.substring(0, n);
                }
            }
            this.address = string2;
            if (n != -1 && (string3 = string.substring(n + 1).trim()).length() > 0) {
                Integer n4 = new Integer(string3);
                this.port = n4;
            }
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setEncoding(int n) {
        this.type = n;
    }

    public String toString() {
        String string = null;
        if (this.type == 2) {
            string = new String(IPV6_ADDR_START_DELIMETER);
            string = string.concat(this.address + IPV6_ADDR_END_DELIMETER);
        } else {
            string = new String(this.address);
        }
        if (this.port > -1) {
            string = string.concat(PORT_DELIMETER + this.port);
        }
        return string;
    }
}

