/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import java.util.Vector;

public class OperationResults {
    private Object generalError;
    private String[] infoDescriptions;
    private Vector errorVector;

    public OperationResults(String[] stringArray) {
        this.infoDescriptions = stringArray;
        this.errorVector = new Vector();
    }

    public void addError(Object[] objectArray, Exception exception) {
        if (objectArray == null || objectArray.length != this.infoDescriptions.length || exception == null) {
            throw new IllegalArgumentException();
        }
        ErrorInfo errorInfo = new ErrorInfo(objectArray, exception);
        this.errorVector.addElement(errorInfo);
    }

    public boolean containsGeneralError() {
        return this.generalError != null;
    }

    public Object getGeneralError() {
        return this.generalError;
    }

    public String getGeneralErrorMessage() {
        if (this.generalError == null) {
            return null;
        }
        if (this.generalError instanceof Exception) {
            return ((Exception)this.generalError).getLocalizedMessage();
        }
        return this.generalError.toString();
    }

    public void setGeneralError(Object object) {
        this.generalError = object;
    }

    public Vector getErrors() {
        return this.errorVector;
    }

    public String[] getInfoDescriptions() {
        return this.infoDescriptions;
    }

    public boolean containsErrors() {
        return this.generalError != null || this.errorVector.size() > 0;
    }

    public void mergeResults(OperationResults operationResults) {
        if (this.infoDescriptions.length != operationResults.infoDescriptions.length) {
            throw new IllegalArgumentException();
        }
        this.errorVector.addAll(operationResults.errorVector);
    }

    public class ErrorInfo {
        public final Object[] info;
        public final Exception exception;

        public ErrorInfo(Object[] objectArray, Exception exception) {
            this.info = objectArray;
            this.exception = exception;
        }
    }
}

