/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import com.novell.gw.util.MethodInvocation;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class StatusMonitor
implements ActionListener {
    public static final int DEF_POPUP_DELAY = 250;
    public static final int DEF_DLG_WIDTH = 350;
    public static final int GROUP_TYPE_LABEL = 1;
    public static final int GROUP_TYPE_PROGRESS = 2;
    public static final int GROUP_TYPE_LABEL_AND_PROGRESS = 3;
    private int popupDelay;
    private int dlgWidth = 350;
    private int[] groupTypes;
    private StatusGroup[] groups;
    private Component parentComp;
    private MethodInvocation mi;
    private JPanel statusGroupPanel;
    private StatusDialog dialog;
    private JLabel titleLabel = new JLabel();
    private JButton cancelButton;
    private boolean didCancel = false;
    private boolean cancelEnabled = true;
    private volatile boolean isShowLocked = false;
    private volatile boolean wasDisposed = false;
    private Object returnVal;

    public StatusMonitor(Component component, String string, int[] nArray) {
        this(component, string, nArray, 250);
    }

    public StatusMonitor(Component component, String string, int[] nArray, int n) {
        this.parentComp = component;
        this.groupTypes = nArray;
        this.popupDelay = n;
        this.setTitleText(string);
        int n2 = nArray.length;
        this.groups = new StatusGroup[n2];
        for (int i = 0; i < n2; ++i) {
            this.groups[i] = new StatusGroup(nArray[i]);
        }
    }

    public void setTitleText(String string) {
        this.titleLabel.setText(string);
        this.titleLabel.getAccessibleContext().setAccessibleName(string);
    }

    public void setMethodInvocation(MethodInvocation methodInvocation) {
        this.mi = methodInvocation;
    }

    public boolean didCancel() {
        return this.didCancel;
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelEnabled = bl;
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(this.cancelEnabled);
        }
    }

    public void setDialogWidth(int n) {
        this.dlgWidth = n;
    }

    public int getStatusGroupCount() {
        return this.groups.length;
    }

    public void setProgressRange(int n, int n2, int n3) {
        this.setProgressRange(n, n2, n3, true);
    }

    public void setProgressRange(int n, int n2, int n3, boolean bl) {
        JProgressBar jProgressBar;
        if (n >= 0 && n < this.groups.length && (jProgressBar = this.groups[n].progressBar) != null) {
            jProgressBar.setMinimum(n2);
            jProgressBar.setMaximum(n3);
            if (bl) {
                jProgressBar.setValue(n2);
            }
        }
    }

    public boolean setProgressValue(int n, int n2) {
        JProgressBar jProgressBar;
        if (n >= 0 && n < this.groups.length && (jProgressBar = this.groups[n].progressBar) != null) {
            jProgressBar.setValue(n2);
        }
        return this.didCancel;
    }

    public boolean incProgressValue(int n) {
        JProgressBar jProgressBar;
        if (n >= 0 && n < this.groups.length && (jProgressBar = this.groups[n].progressBar) != null) {
            jProgressBar.setValue(jProgressBar.getValue() + 1);
        }
        return this.didCancel;
    }

    public boolean setStatusText(int n, String string) {
        JLabel jLabel;
        if (n >= 0 && n < this.groups.length && (jLabel = this.groups[n].label) != null) {
            jLabel.setText(string);
            jLabel.getAccessibleContext().setAccessibleName(string);
        }
        return this.didCancel;
    }

    public boolean setTextAndIncrement(int n, String string) {
        boolean bl = this.setStatusText(n, string);
        if (!bl) {
            bl = this.incProgressValue(n);
        }
        return bl;
    }

    public synchronized JDialog getStatusDialog() {
        if (!this.wasDisposed) {
            while (true) {
                try {
                    while (true) {
                        if (this.dialog != null && this.dialog.isShowing()) {
                            return this.dialog;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Debug.traceException(interruptedException);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    public Object getReturnVal() throws Exception {
        OpThread opThread = new OpThread();
        opThread.setPriority(10);
        opThread.start();
        try {
            Thread.sleep(this.popupDelay);
        }
        catch (InterruptedException interruptedException) {
            Debug.traceException(interruptedException);
        }
        this.showDialog();
        if (this.returnVal instanceof Exception) {
            throw (Exception)this.returnVal;
        }
        return this.returnVal;
    }

    private void createDialog() {
        Window window = this.getParentWindow();
        this.dialog = window instanceof JDialog ? new StatusDialog((JDialog)window) : new StatusDialog((JFrame)window);
        Container container = this.dialog.getContentPane();
        container.setLayout(new GridBagLayout());
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)this.titleLabel, gridBagConstraints);
        this.statusGroupPanel = new JPanel();
        this.statusGroupPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        int n = this.groups.length;
        for (int i = 0; i < n; ++i) {
            StatusGroup statusGroup = this.groups[i];
            if (statusGroup.label != null) {
                this.statusGroupPanel.add((Component)statusGroup.label, gridBagConstraints);
            }
            if (statusGroup.progressBar == null) continue;
            this.statusGroupPanel.add(Box.createVerticalStrut(2), gridBagConstraints);
            this.statusGroupPanel.add((Component)statusGroup.progressBar, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)this.statusGroupPanel, gridBagConstraints);
        this.cancelButton = new JButton();
        this.cancelButton.setEnabled(this.cancelEnabled);
        String string = EngineResource.getR2String("CancelKey");
        Loc.setText((AbstractButton)this.cancelButton, (String)string);
        this.cancelButton.getAccessibleContext().setAccessibleName(Loc.removeHotChar((String)string));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        container.add((Component)this.cancelButton, gridBagConstraints);
        this.cancelButton.addActionListener(this);
    }

    private Window getParentWindow() {
        for (Component component = this.parentComp; component != null; component = component.getParent()) {
            if (!(component instanceof JDialog) && !(component instanceof JFrame)) continue;
            return (Window)component;
        }
        return null;
    }

    private void showDialog() {
        if (!this.wasDisposed) {
            this.createDialog();
            this.dialog.pack();
            this.dialog.setSize(this.dlgWidth, this.dialog.getHeight());
            this.dialog.setLocationRelativeTo(this.parentComp);
        }
        if (this.startShowLock()) {
            this.dialog.show();
        }
    }

    private synchronized boolean startShowLock() {
        if (!this.wasDisposed) {
            this.isShowLocked = true;
        }
        return this.isShowLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        StatusMonitor statusMonitor = this;
        synchronized (statusMonitor) {
            if (this.isShowLocked) {
                block5: while (true) {
                    try {
                        while (true) {
                            if (this.dialog.isShowing()) {
                                this.isShowLocked = false;
                                break block5;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.traceException(interruptedException);
                        continue;
                    }
                    break;
                }
            }
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.dispose();
            }
            this.wasDisposed = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.didCancel = true;
    }

    private class OpThread
    extends Thread {
        private OpThread() {
        }

        public void run() {
            try {
                StatusMonitor.this.returnVal = StatusMonitor.this.mi.invoke();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    StatusMonitor.this.returnVal = (Exception)throwable;
                } else if (Debug.trace) {
                    throwable.printStackTrace();
                }
            }
            catch (Exception exception) {
                StatusMonitor.this.returnVal = exception;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                Debug.trace("\n\n ** StatusMonitor.OpThread.run: this will never happen ** \n");
                StatusMonitor.this.close();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        StatusMonitor.this.close();
                    }
                };
                try {
                    SwingUtilities.invokeLater(runnable);
                }
                catch (Exception exception) {
                    Debug.trace("StatusMonitor.OpThread.run: ex= " + exception);
                    Debug.traceException(exception);
                }
            }
        }
    }

    private class StatusDialog
    extends JDialog {
        public StatusDialog(JDialog jDialog) {
            super(jDialog, EngineResource.getR2String("PleaseWait"), true);
        }

        public StatusDialog(JFrame jFrame) {
            super(jFrame, EngineResource.getR2String("PleaseWait"), true);
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                return;
            }
            super.processWindowEvent(windowEvent);
        }
    }

    public class StatusGroup {
        public JLabel label;
        public JProgressBar progressBar;

        StatusGroup(int n) {
            if ((n & 1) > 0) {
                this.label = new JLabel(" ");
                this.label.setHorizontalAlignment(0);
            }
            if ((n & 2) > 0) {
                this.progressBar = new JProgressBar();
                this.progressBar.setStringPainted(true);
            }
        }
    }
}

