/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util.worker;

import com.novell.gw.util.Debug;
import com.novell.gw.util.EngineResource;
import com.novell.gw.util.worker.CancelProgress;
import com.novell.gw.util.worker.NumericProgress;
import com.novell.gw.util.worker.ProgressFactory;
import com.novell.gw.util.worker.StringProgress;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressManager
implements ProgressFactory {
    public static final int DEF_POPUP_DELAY = 250;
    public static final int DEF_DLG_WIDTH = 350;
    private int dlgWidth = 350;
    private Component parentComp;
    private JPanel progressPane;
    private CancelButton cancelButton;
    private StatusDialog statusDlg;
    private boolean didCancel = false;
    private boolean cancelEnabled = true;
    private volatile boolean isShowLocked = false;
    private volatile boolean wasDisposed = false;

    public ProgressManager(Component component) {
        this.parentComp = component;
        this.progressPane = new JPanel();
        this.progressPane.setLayout(new GridBagLayout());
    }

    public void addLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.getAccessibleContext().setAccessibleName(string);
        this.addComp(jLabel, false);
    }

    public NumericProgress createNumericProgress() {
        ProgressBar progressBar = new ProgressBar();
        this.addComp(progressBar.bar, true);
        return progressBar;
    }

    public StringProgress createStringProgress() {
        ProgressLabel progressLabel = new ProgressLabel();
        this.addComp(progressLabel.label, true);
        return progressLabel;
    }

    public CancelProgress getCancelProgress() {
        if (this.cancelButton == null) {
            this.cancelButton = new CancelButton();
        }
        return this.cancelButton;
    }

    private void addComp(JComponent jComponent, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        if (bl) {
            gridBagConstraints.fill = 2;
        }
        this.progressPane.add((Component)jComponent, gridBagConstraints);
    }

    public void setDialogWidth(int n) {
        this.dlgWidth = n;
    }

    public void run(Runnable runnable, int n) {
        OpThread opThread = new OpThread(runnable);
        opThread.setPriority(10);
        opThread.start();
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                Debug.traceException(interruptedException);
            }
        }
        this.showDialog();
    }

    private void showDialog() {
        if (!this.wasDisposed) {
            this.statusDlg = this.createStatusDialog();
            this.statusDlg.pack();
            this.statusDlg.setSize(this.dlgWidth, this.statusDlg.getHeight());
            this.statusDlg.setLocationRelativeTo(this.parentComp);
            if (this.startShowLock()) {
                this.statusDlg.show();
            }
        }
    }

    private StatusDialog createStatusDialog() {
        for (Component component = this.parentComp; component != null; component = component.getParent()) {
            if (component instanceof JDialog) {
                return new StatusDialog((JDialog)component);
            }
            if (!(component instanceof JFrame)) continue;
            return new StatusDialog((JFrame)component);
        }
        return new StatusDialog((JFrame)null);
    }

    private synchronized boolean startShowLock() {
        if (!this.wasDisposed) {
            this.isShowLocked = true;
        }
        return this.isShowLocked;
    }

    private synchronized void closeDialog() {
        if (this.isShowLocked) {
            block2: while (true) {
                try {
                    while (true) {
                        if (this.statusDlg.isShowing()) {
                            this.isShowLocked = false;
                            break block2;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Debug.traceException(interruptedException);
                    continue;
                }
                break;
            }
        }
        if (this.statusDlg != null && this.statusDlg.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressManager.this.statusDlg.dispose();
                }
            });
        }
        this.wasDisposed = true;
    }

    static /* synthetic */ boolean access$102(ProgressManager progressManager, boolean bl) {
        progressManager.didCancel = bl;
        return progressManager.didCancel;
    }

    private class OpThread
    extends Thread {
        private Runnable opRunner;

        public OpThread(Runnable runnable) {
            this.opRunner = runnable;
        }

        public void run() {
            this.opRunner.run();
            ProgressManager.this.closeDialog();
        }
    }

    private class StatusDialog
    extends JDialog {
        public StatusDialog(JDialog jDialog) {
            super(jDialog, EngineResource.getR2String("PleaseWait"), true);
            this.initComponents();
        }

        public StatusDialog(JFrame jFrame) {
            super(jFrame, EngineResource.getR2String("PleaseWait"), true);
            this.initComponents();
        }

        private void initComponents() {
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            container.add((Component)ProgressManager.this.progressPane, gridBagConstraints);
            if (ProgressManager.this.cancelButton != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                container.add((Component)((ProgressManager)ProgressManager.this).cancelButton.button, gridBagConstraints);
            }
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                return;
            }
            super.processWindowEvent(windowEvent);
        }
    }

    private class CancelButton
    implements CancelProgress {
        public final JButton button = new JButton();

        public CancelButton() {
            String string = EngineResource.getR2String("CancelKey");
            Loc.setText((AbstractButton)this.button, (String)string);
            this.button.getAccessibleContext().setAccessibleName(Loc.removeHotChar((String)string));
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ CancelButton this$1;
                {
                    this.this$1 = cancelButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressManager.access$102(CancelButton.access$200(this.this$1), true);
                }
            });
        }

        public boolean didCancel() {
            return ProgressManager.this.didCancel;
        }

        public void setCancelEnabled(boolean bl) {
            ProgressManager.this.cancelEnabled = bl;
            if (this.button != null) {
                this.button.setEnabled(ProgressManager.this.cancelEnabled);
            }
        }

        static /* synthetic */ ProgressManager access$200(CancelButton cancelButton) {
            return cancelButton.ProgressManager.this;
        }
    }

    private class ProgressBar
    implements NumericProgress {
        public final JProgressBar bar = new JProgressBar();

        public void setProgressRange(int n, int n2) {
            if (this.bar != null) {
                this.bar.setMinimum(n);
                this.bar.setMaximum(n2);
                this.bar.setValue(n);
            }
        }

        public boolean incProgressValue() {
            this.bar.setValue(this.bar.getValue() + 1);
            return ProgressManager.this.didCancel;
        }

        public boolean setProgressValue(int n) {
            this.bar.setValue(n);
            return ProgressManager.this.didCancel;
        }
    }

    private class ProgressLabel
    implements StringProgress {
        public final JLabel label = new JLabel(" ");

        public boolean setProgressString(String string) {
            this.label.setText(string);
            this.label.getAccessibleContext().setAccessibleName(string);
            return ProgressManager.this.didCancel;
        }
    }
}

