/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.widgets;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class NArrowCheckBox
extends JPanel
implements ItemListener,
ItemSelectable {
    static boolean initialized = false;
    private static final String DOWN_ARROW_GIF_STRING = "downArrow.gif";
    private static final String DOWN_ARROW_LINE_GIF_STRING = "downArrowLine.gif";
    public static boolean focusFlag;
    private JCheckBox cb;
    private JLabel currentImage = null;
    private Image downArrow;
    private Image downArrowLine;
    private Vector itemListeners = null;

    private void setAccessible() {
        this.requestFocus();
        this.cb.requestFocus();
    }

    public void setArrowImage() {
        this.removeAll();
        if (this.downArrow != null && this.downArrowLine != null) {
            Image image = this.cb.isSelected() ? this.downArrow : this.downArrowLine;
            this.currentImage = new JLabel(new ImageIcon(image));
            this.add((Component)this.currentImage, "West");
        }
        this.add((Component)this.cb, "Center");
        this.validate();
    }

    public void setSelected(boolean bl) {
        this.cb.setSelected(bl);
    }

    public boolean isSelected() {
        return this.cb.isSelected();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cb) {
            this.setArrowImage();
            if (focusFlag) {
                this.setAccessible();
            }
            if (this.itemListeners != null) {
                Enumeration enumeration = this.itemListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ItemEvent itemEvent2 = new ItemEvent(this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange());
                    ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent2);
                }
            }
        }
    }

    public Object[] getSelectedObjects() {
        if (this.cb.isSelected()) {
            return new Object[]{this};
        }
        return null;
    }

    public void addItemListener(ItemListener itemListener) {
        if (this.itemListeners == null) {
            this.itemListeners = new Vector();
        }
        if (!this.itemListeners.contains(itemListener)) {
            this.itemListeners.addElement(itemListener);
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this.itemListeners != null && this.itemListeners.contains(itemListener)) {
            this.itemListeners.removeElement(itemListener);
        }
    }

    public void setEnabled(boolean bl) {
        this.cb.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.cb.isEnabled();
    }

    public NArrowCheckBox(String string, boolean bl) {
        super(new BorderLayout(2, 0));
        this.cb = new JCheckBox(string, bl);
        this.cb.setName("NArrowCheckBox");
        Loc.setText((AbstractButton)this.cb, (String)string);
        this.cb.setHorizontalAlignment(2);
        this.downArrow = widgets.getImage(DOWN_ARROW_GIF_STRING);
        this.downArrowLine = widgets.getImage(DOWN_ARROW_LINE_GIF_STRING);
        this.setArrowImage();
        this.cb.addItemListener(this);
        this.setSelected(bl);
    }

    public NArrowCheckBox(String string, boolean bl, String string2) {
        this(string, bl);
        this.setBackground(UIManager.getColor(string2));
        this.cb.setBackground(UIManager.getColor(string2));
    }
}

