/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTitledPanel;
import com.novell.application.console.widgets.widgets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NBarChartPanel
extends NTitledPanel {
    private float total;
    private float used;
    private String units;
    private Color fillColor;
    private BarChart chart;
    private final Color backgroundColor = Color.white;
    private JLabel totalAmount;
    private JLabel usedAmount;
    private JLabel availableAmount;

    public void setTotal(float f) {
        this.total = f;
        this.reset();
    }

    public void setUsed(float f) {
        this.used = f;
        this.reset();
    }

    public void setUnits(String string) {
        this.units = string;
        this.reset();
    }

    private void reset() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        this.totalAmount.setText(numberFormat.format(this.total) + " " + this.units);
        this.usedAmount.setText(numberFormat.format(this.used) + " " + this.units);
        this.availableAmount.setText(numberFormat.format(this.total - this.used) + " " + this.units);
        this.chart.reCalculate();
        this.chart.repaint();
    }

    public NBarChartPanel(String string, float f, float f2, String string2, Color color) {
        super(string);
        this.total = f;
        this.used = f2;
        this.units = string2;
        this.fillColor = color;
        this.setLayout(new BorderLayout(0, 3));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        NBarChartPanel nBarChartPanel = this;
        if (nBarChartPanel == null) {
            throw null;
        }
        this.chart = nBarChartPanel.new BarChart();
        this.add((Component)this.chart, "North");
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        NBarChartPanel nBarChartPanel2 = this;
        if (nBarChartPanel2 == null) {
            throw null;
        }
        jPanel2.add(new JPanel().add(nBarChartPanel2.new Box(null)), "West");
        JPanel jPanel3 = new JPanel(new BorderLayout(50, 0));
        jPanel3.add((Component)new JLabel(widgets.getString("totalKey")), "West");
        this.totalAmount = new JLabel(numberFormat.format(f) + " " + this.units);
        this.totalAmount.setHorizontalAlignment(4);
        jPanel3.add((Component)this.totalAmount, "East");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 0));
        NBarChartPanel nBarChartPanel3 = this;
        if (nBarChartPanel3 == null) {
            throw null;
        }
        jPanel4.add(new JPanel().add(nBarChartPanel3.new Box(color)), "West");
        JPanel jPanel5 = new JPanel(new BorderLayout(50, 0));
        jPanel5.add((Component)new JLabel(widgets.getString("usedKey")), "West");
        this.usedAmount = new JLabel(numberFormat.format(f2) + " " + this.units);
        this.usedAmount.setHorizontalAlignment(4);
        jPanel5.add((Component)this.usedAmount, "East");
        jPanel4.add((Component)jPanel5, "Center");
        jPanel.add(jPanel4);
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 0));
        NBarChartPanel nBarChartPanel4 = this;
        if (nBarChartPanel4 == null) {
            throw null;
        }
        jPanel6.add(new JPanel().add(nBarChartPanel4.new Box(Color.white)), "West");
        JPanel jPanel7 = new JPanel(new BorderLayout(50, 0));
        jPanel7.add((Component)new JLabel(widgets.getString("availableKey")), "West");
        this.availableAmount = new JLabel(numberFormat.format(f - f2) + " " + this.units);
        this.availableAmount.setHorizontalAlignment(4);
        jPanel7.add((Component)this.availableAmount, "East");
        jPanel6.add((Component)jPanel7, "Center");
        jPanel.add(jPanel6);
        this.add((Component)jPanel, "South");
    }

    private class BarChart
    extends JComponent {
        private float totalUsedPercent;
        private final int HEIGHT;

        public void reCalculate() {
            this.totalUsedPercent = (long)(NBarChartPanel.this.used / NBarChartPanel.this.total * 100.0f);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getSize().width, 20);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            graphics.drawRect(0, 0, n - 1, 19);
            graphics.setColor(NBarChartPanel.this.backgroundColor);
            graphics.fillRect(1, 1, n - 2, 18);
            graphics.setColor(NBarChartPanel.this.fillColor);
            float f = this.totalUsedPercent / 100.0f;
            int n2 = (int)((float)n * f);
            if (n2 > n - 1) {
                n2 = n - 2;
            }
            graphics.fillRect(1, 1, new Long(n2).intValue(), 18);
        }

        public BarChart() {
            this.HEIGHT = 20;
            this.reCalculate();
        }
    }

    private class Box
    extends JComponent {
        private Color fillColor;

        public Dimension getPreferredSize() {
            return new Dimension(18, 10);
        }

        public void paint(Graphics graphics) {
            if (this.fillColor != null) {
                Dimension dimension = this.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(this.fillColor);
                graphics.fillRect(1, 1, n - 2, n2 - 2);
            } else {
                super.paint(graphics);
            }
        }

        public Box(Color color) {
            this.fillColor = color;
        }
    }
}

