/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.testing.C1Hooks;
import com.novell.application.console.widgets.NDialog;
import com.novell.application.console.widgets.NIntTextField;
import com.novell.application.console.widgets.NJTextField;
import com.novell.application.console.widgets.NTextField;
import com.novell.application.console.widgets.NTitledPanel;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.localization.Loc;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class NDateTimeDlg
extends NDialog
implements ActionListener,
KeyListener,
FocusListener {
    public static final int ID_CANCEL = 0;
    public static final int ID_OK = 1;
    private Component parentFrame;
    private JComboBox monthCB;
    private NIntTextField yearTF;
    private NTextField timeTF;
    private MiniArrowButton yearUp;
    private MiniArrowButton yearDown;
    private TimeButton hourUp;
    private TimeButton hourDown;
    private TimeButton minuteUp;
    private TimeButton minuteDown;
    private JButton cancelButton;
    private JButton okButton;
    private JButton helpButton;
    private int rval = -1;
    boolean buttonFlag;
    private NTitledPanel dayTitlePanel;
    private JPanel dayPanel;
    private int currentDay;
    private String[] months;
    private int[] monthLength;
    private String[] weekdays;
    private String[] fullWeekdays;
    private DayCell[] cells;
    private Calendar calendar;
    private Calendar newCalendar;
    private int maxYear = 2037;
    private int minYear = 1970;
    private DateFormat timeFormat;

    public void setMaxYear(int n) {
        this.maxYear = n;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMinYear(int n) {
        this.minYear = n;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    public void show() {
        throw new RuntimeException("PROGRAMMING ERROR, Use method launch() not show() in NDateTimeDlg.java");
    }

    public int launch() {
        this.cells[this.currentDay - 1].requestFocus();
        super.show();
        return this.rval;
    }

    public Calendar getCalendar() {
        return this.newCalendar;
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.yearTF && this.yearTF.isModified()) {
            if (this.yearTF.getText().length() < 4) {
                this.yearTF.setIntValue(this.newCalendar.get(1));
            } else if (this.isYearValid(this.yearTF.getIntValue())) {
                this.enableYearButtons();
                this.setupDays();
            } else {
                this.getToolkit().beep();
                this.yearTF.setIntValue(this.newCalendar.get(1));
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this.timeTF) {
            try {
                Date date = this.timeFormat.parse(this.timeTF.getText());
                Calendar calendar = (Calendar)this.newCalendar.clone();
                calendar.setTime(date);
                this.newCalendar.set(11, calendar.get(11));
                this.newCalendar.set(12, calendar.get(12));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.okButton.setEnabled(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void help() {
        ShellStubs.launchHelp((String)"novellconsoleone", (String)"datetimeselector", (Window)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.yearUp) {
            if (this.isYearValid(this.yearTF.getIntValue() + 1)) {
                this.yearTF.setIntValue(this.yearTF.getIntValue() + 1);
                this.enableYearButtons();
                this.okButton.setEnabled(true);
                this.buttonFlag = true;
                this.setupDays();
                this.yearDown.requestFocus();
                this.yearUp.requestFocus();
            } else {
                this.getToolkit().beep();
            }
        } else if (object == this.yearDown) {
            if (this.isYearValid(this.yearTF.getIntValue() - 1)) {
                this.yearTF.setIntValue(this.yearTF.getIntValue() - 1);
                this.enableYearButtons();
                this.okButton.setEnabled(true);
                this.buttonFlag = true;
                this.setupDays();
                this.yearUp.requestFocus();
                this.yearDown.requestFocus();
            } else {
                this.getToolkit().beep();
            }
        } else if (object == this.hourUp) {
            this.newCalendar.roll(11, true);
            this.updateTimeTF();
            this.hourUp.transferFocus();
            this.hourUp.requestFocus();
            this.okButton.setEnabled(true);
        } else if (object == this.hourDown) {
            this.newCalendar.roll(11, false);
            this.updateTimeTF();
            this.hourDown.transferFocus();
            this.hourDown.requestFocus();
            this.okButton.setEnabled(true);
        } else if (object == this.minuteUp) {
            this.newCalendar.roll(12, true);
            this.updateTimeTF();
            this.minuteUp.transferFocus();
            this.minuteUp.requestFocus();
            this.okButton.setEnabled(true);
        } else if (object == this.minuteDown) {
            this.newCalendar.roll(12, false);
            this.updateTimeTF();
            this.minuteDown.transferFocus();
            this.minuteDown.requestFocus();
            this.okButton.setEnabled(true);
        } else if (object == this.monthCB) {
            this.okButton.setEnabled(true);
            this.buttonFlag = true;
            this.setupDays();
        } else if (object == this.cancelButton) {
            this.rval = 0;
            this.newCalendar = (Calendar)this.calendar.clone();
            this.dispose();
        } else if (object == this.helpButton) {
            this.help();
        } else if (object == this.okButton) {
            int n = this.monthCB.getSelectedIndex();
            int n2 = this.yearTF.getIntValue();
            this.newCalendar.set(n2, n, this.currentDay);
            if (this.timeTF.isModified()) {
                try {
                    Date date = this.timeFormat.parse(this.timeTF.getText());
                    Calendar calendar = (Calendar)this.newCalendar.clone();
                    calendar.setTime(date);
                    this.newCalendar.set(11, calendar.get(11));
                    this.newCalendar.set(12, calendar.get(12));
                    this.rval = 1;
                    this.dispose();
                }
                catch (ParseException parseException) {
                    String string = widgets.getString("timeFormatErrorMessageKey");
                    string = string + "\n\n" + this.timeFormat.format(this.newCalendar.getTime());
                    NMsgBox nMsgBox = new NMsgBox(this.parentFrame, widgets.getString("timeFormatErrorCaptionKey"), string, 3);
                    this.getToolkit().beep();
                    nMsgBox.setVisible(true);
                    this.timeTF.selectAll();
                    this.timeTF.requestFocus();
                }
            } else {
                this.rval = 1;
                this.dispose();
            }
        }
        super.actionPerformed(actionEvent);
    }

    private void setAccessible(FocusEvent focusEvent) {
        String string = "";
        try {
            JButton jButton = (JButton)focusEvent.getSource();
            if (focusEvent.getSource() == this.yearUp) {
                string = this.yearTF.getText() + "\t\t\t\t " + widgets.getString("yearUpKey");
            } else if (focusEvent.getSource() == this.yearDown) {
                string = this.yearTF.getText() + "\t\t\t\t " + widgets.getString("yearDownKey");
            } else if (focusEvent.getSource() == this.hourUp) {
                string = this.timeTF.getText() + "\t\t \t\t" + widgets.getString("hourUpKey");
            } else if (focusEvent.getSource() == this.hourDown) {
                string = this.timeTF.getText() + "\t\t\t\t " + widgets.getString("hourDownKey");
            } else if (focusEvent.getSource() == this.minuteUp) {
                string = this.timeTF.getText() + "\t\t\t\t " + widgets.getString("minuteUpKey");
            } else if (focusEvent.getSource() == this.minuteDown) {
                string = this.timeTF.getText() + "\t\t\t\t " + widgets.getString("minuteDownKey");
            }
            NConeFactory.novellJButton((JButton)jButton, (String)string, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateTimeTF() {
        this.timeTF.setText(this.timeFormat.format(this.newCalendar.getTime()));
        NConeFactory.novellJTextField((JTextField)this.timeTF, (String)widgets.getString("TimeKey"), (String)"This is a TextField");
    }

    private void enableYearButtons() {
        int n = this.yearTF.getIntValue();
        if (this.maxYear != -1) {
            if (n == this.maxYear) {
                this.yearUp.setEnabled(false);
            } else {
                this.yearUp.setEnabled(true);
            }
        }
        if (this.minYear != -1) {
            if (n == this.minYear) {
                this.yearDown.setEnabled(false);
            } else {
                this.yearDown.setEnabled(true);
            }
        }
    }

    private void layoutControls() {
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 3));
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 3));
        this.monthCB = new JComboBox();
        NDateTimeDlg nDateTimeDlg = this;
        if (nDateTimeDlg == null) {
            throw null;
        }
        this.monthCB.addFocusListener(new FocusAdapter(nDateTimeDlg){
            private final /* synthetic */ NDateTimeDlg this$0;

            public void focusLost(FocusEvent focusEvent) {
                NConeFactory.novellJComboBox((JComboBox)NDateTimeDlg.access$0(this.this$0), (String)Loc.removeHotChar((String)widgets.getString("monthKey")), (String)"");
            }
            {
                this.this$0 = nDateTimeDlg;
                this.constructor$0(nDateTimeDlg);
            }

            private final void constructor$0(NDateTimeDlg nDateTimeDlg) {
            }
        });
        NDateTimeDlg nDateTimeDlg2 = this;
        if (nDateTimeDlg2 == null) {
            throw null;
        }
        this.monthCB.setRenderer(nDateTimeDlg2.new MonthCBRenderer());
        this.monthCB.setMaximumRowCount(6);
        int n = 0;
        while (n < 12) {
            this.monthCB.addItem(new JLabel(this.months[n]));
            ++n;
        }
        this.monthCB.setSelectedIndex(this.newCalendar.get(2));
        this.monthCB.setFont(this.getFont());
        this.monthCB.addActionListener(this);
        this.monthCB.setName("Month");
        JLabel jLabel = new JLabel();
        Loc.setText((JLabel)jLabel, (Component)this.monthCB, (String)widgets.getString("monthKey"));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        NConeFactory.novellJComboBox((JComboBox)this.monthCB, (String)(dateFormat.format(this.newCalendar.getTime()) + Loc.removeHotChar((String)jLabel.getText())), (String)"");
        jPanel3.add((Component)jLabel, "North");
        jPanel3.add((Component)this.monthCB, "Center");
        this.yearTF = new NIntTextField(6, (long)this.minYear, (long)this.maxYear);
        this.yearTF.setIntValue(this.newCalendar.get(1));
        this.yearTF.setEditable(false);
        this.yearTF.addFocusListener(this);
        this.yearTF.addKeyListener(this);
        this.yearTF.setName("YearTextField");
        NDateTimeDlg nDateTimeDlg3 = this;
        if (nDateTimeDlg3 == null) {
            throw null;
        }
        this.yearUp = nDateTimeDlg3.new MiniArrowButton(1);
        this.yearUp.setName("YearUP");
        this.yearUp.addActionListener(this);
        NDateTimeDlg nDateTimeDlg4 = this;
        if (nDateTimeDlg4 == null) {
            throw null;
        }
        this.yearDown = nDateTimeDlg4.new MiniArrowButton(5);
        this.yearDown.addActionListener(this);
        this.yearDown.setName("YearDown");
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 0));
        jPanel5.add((Component)this.yearUp, "North");
        jPanel5.add((Component)this.yearDown, "South");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(widgets.getString("yearKey"));
        NConeFactory.makeRelation((JLabel)jLabel2, (NJTextField)this.yearTF);
        jPanel4.add((Component)jLabel2, "North");
        jPanel4.add((Component)this.yearTF, "Center");
        jPanel4.add((Component)jPanel5, "East");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel4, "East");
        jPanel.add((Component)jPanel2, "North");
        this.dayPanel = new JPanel(new GridLayout(0, 7));
        this.dayTitlePanel = new NTitledPanel(widgets.getString("dayKey"), new BorderLayout());
        this.setupDays();
        this.dayTitlePanel.add((Component)this.dayPanel, "Center");
        jPanel.add((Component)this.dayTitlePanel, "Center");
        NTitledPanel nTitledPanel = new NTitledPanel(widgets.getString("timeKey"), new BorderLayout(0, 1));
        this.timeTF = new NTextField(15);
        this.timeTF.addKeyListener(this);
        this.timeTF.setName("TimeTextField");
        this.updateTimeTF();
        JPanel jPanel6 = new JPanel(new FlowLayout(1));
        NDateTimeDlg nDateTimeDlg5 = this;
        if (nDateTimeDlg5 == null) {
            throw null;
        }
        this.hourUp = nDateTimeDlg5.new TimeButton("DoubleRightArrow.gif");
        this.hourUp.addActionListener(this);
        this.hourUp.setName("HourUpButton");
        NDateTimeDlg nDateTimeDlg6 = this;
        if (nDateTimeDlg6 == null) {
            throw null;
        }
        this.hourDown = nDateTimeDlg6.new TimeButton("DoubleLeftArrow.gif");
        this.hourDown.addActionListener(this);
        this.hourDown.setName("HourDownButton");
        NDateTimeDlg nDateTimeDlg7 = this;
        if (nDateTimeDlg7 == null) {
            throw null;
        }
        this.minuteUp = nDateTimeDlg7.new TimeButton("RightArrow.gif");
        this.minuteUp.addActionListener(this);
        this.minuteUp.setName("MinuteUpButton");
        NDateTimeDlg nDateTimeDlg8 = this;
        if (nDateTimeDlg8 == null) {
            throw null;
        }
        this.minuteDown = nDateTimeDlg8.new TimeButton("LeftArrow.gif");
        this.minuteDown.addActionListener(this);
        this.minuteDown.setName("MinuteDownButton");
        jPanel6.add(this.hourDown);
        jPanel6.add(this.minuteDown);
        jPanel6.add(this.timeTF);
        jPanel6.add(this.minuteUp);
        jPanel6.add(this.hourUp);
        nTitledPanel.add((Component)jPanel6, "Center");
        jPanel.add((Component)nTitledPanel, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        JPanel jPanel8 = new JPanel(new GridLayout(1, 3, 5, 0));
        NDateTimeDlg nDateTimeDlg9 = this;
        if (nDateTimeDlg9 == null) {
            throw null;
        }
        this.okButton = NConeFactory.novellJButton((JButton)new JButton(nDateTimeDlg9, widgets.getString("okKey")){
            private final /* synthetic */ NDateTimeDlg this$0;

            public boolean isDefaultCapable() {
                return true;
            }
            {
                this.this$0 = nDateTimeDlg;
                this.constructor$0(nDateTimeDlg, string);
            }

            private final void constructor$0(NDateTimeDlg nDateTimeDlg, String string) {
            }
        }, (String)widgets.getString("okKey"), (String)"This is a Button");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.okButton.setName("OK");
        jPanel8.add(this.okButton);
        NDateTimeDlg nDateTimeDlg10 = this;
        if (nDateTimeDlg10 == null) {
            throw null;
        }
        this.cancelButton = NConeFactory.novellJButton((JButton)new JButton(nDateTimeDlg10, widgets.getString("cancelKey")){
            private final /* synthetic */ NDateTimeDlg this$0;

            public boolean isDefaultCapable() {
                return false;
            }
            {
                this.this$0 = nDateTimeDlg;
                this.constructor$0(nDateTimeDlg, string);
            }

            private final void constructor$0(NDateTimeDlg nDateTimeDlg, String string) {
            }
        }, (String)widgets.getString("cancelKey"), (String)"This is a Button");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setName("Cancel");
        jPanel8.add(this.cancelButton);
        NDateTimeDlg nDateTimeDlg11 = this;
        if (nDateTimeDlg11 == null) {
            throw null;
        }
        this.helpButton = NConeFactory.novellJButton((JButton)new JButton(nDateTimeDlg11){
            private final /* synthetic */ NDateTimeDlg this$0;

            public boolean isDefaultCapable() {
                return false;
            }
            {
                this.this$0 = nDateTimeDlg;
                this.constructor$0(nDateTimeDlg);
            }

            private final void constructor$0(NDateTimeDlg nDateTimeDlg) {
            }
        }, (String)Loc.removeHotChar((String)widgets.getString("helpKey")), (String)"This is a Button");
        Loc.setText((AbstractButton)this.helpButton, (String)widgets.getString("helpKey"));
        this.helpButton.addActionListener(this);
        this.helpButton.setName("Help");
        jPanel8.add(this.helpButton);
        jPanel7.add(jPanel8);
        this.getContentPane().add((Component)jPanel7, "South");
        NDateTimeDlg nDateTimeDlg12 = this;
        if (nDateTimeDlg12 == null) {
            throw null;
        }
        WindowAdapter windowAdapter = new WindowAdapter(nDateTimeDlg12){
            private final /* synthetic */ NDateTimeDlg this$0;

            public void windowClosing(WindowEvent windowEvent) {
                NDateTimeDlg.access$2(this.this$0, 0);
            }
            {
                this.this$0 = nDateTimeDlg;
                this.constructor$0(nDateTimeDlg);
            }

            private final void constructor$0(NDateTimeDlg nDateTimeDlg) {
            }
        };
        this.addWindowListener(windowAdapter);
    }

    private void setupDays() {
        this.dayPanel.removeAll();
        int n = this.monthCB.getSelectedIndex();
        int n2 = this.yearTF.getIntValue();
        this.newCalendar.set(n2, n, 1);
        int n3 = n == 1 && n2 % 4 == 0 ? 29 : this.monthLength[n];
        int n4 = this.newCalendar.getFirstDayOfWeek();
        int n5 = n4 - 1;
        while (n5 < 7) {
            NDateTimeDlg nDateTimeDlg = this;
            if (nDateTimeDlg == null) {
                throw null;
            }
            this.dayPanel.add(nDateTimeDlg.new DayNameCell(this.weekdays[n5]));
            ++n5;
        }
        if (n4 != 1) {
            n5 = 0;
            while (n5 < n4 - 1) {
                NDateTimeDlg nDateTimeDlg = this;
                if (nDateTimeDlg == null) {
                    throw null;
                }
                this.dayPanel.add(nDateTimeDlg.new DayNameCell(this.weekdays[n5]));
                ++n5;
            }
        }
        n5 = this.newCalendar.get(7);
        int n6 = n4;
        while (n6 < n5) {
            NDateTimeDlg nDateTimeDlg = this;
            if (nDateTimeDlg == null) {
                throw null;
            }
            this.dayPanel.add(nDateTimeDlg.new DayNameCell(""));
            ++n6;
        }
        this.cells = new DayCell[n3];
        n6 = 0;
        while (n6 < n3) {
            NDateTimeDlg nDateTimeDlg = this;
            if (nDateTimeDlg == null) {
                throw null;
            }
            this.cells[n6] = nDateTimeDlg.new DayCell(n6 + 1, n5);
            this.dayPanel.add(this.cells[n6]);
            ++n6;
        }
        if (this.currentDay > n3) {
            this.currentDay = n3;
        }
        this.cells[this.currentDay - 1].activate();
        this.dayPanel.validate();
        this.dayPanel.repaint();
    }

    private boolean isYearValid(int n) {
        if (this.maxYear == -1 && this.minYear == -1) {
            return true;
        }
        if (this.maxYear != -1 && n > this.maxYear) {
            return false;
        }
        return this.minYear == -1 || n >= this.minYear;
    }

    static /* synthetic */ JComboBox access$0(NDateTimeDlg nDateTimeDlg) {
        return nDateTimeDlg.monthCB;
    }

    static /* synthetic */ int access$1(NDateTimeDlg nDateTimeDlg) {
        return nDateTimeDlg.rval;
    }

    static /* synthetic */ void access$2(NDateTimeDlg nDateTimeDlg, int n) {
        nDateTimeDlg.rval = n;
    }

    public NDateTimeDlg(Component component, Calendar calendar) {
        super(component, widgets.getString("NDateTimeDlgCaptionKey"), true);
        this.parentFrame = component;
        this.calendar = calendar;
        this.newCalendar = (Calendar)calendar.clone();
        this.currentDay = this.newCalendar.get(5);
        this.timeFormat = DateFormat.getTimeInstance(3);
        this.timeFormat.setTimeZone(TimeZone.getDefault());
        this.months = new String[]{widgets.getString("JanuaryKey"), widgets.getString("FebruaryKey"), widgets.getString("MarchKey"), widgets.getString("AprilKey"), widgets.getString("MayKey"), widgets.getString("JuneKey"), widgets.getString("JulyKey"), widgets.getString("AugustKey"), widgets.getString("SeptemberKey"), widgets.getString("OctoberKey"), widgets.getString("NovemberKey"), widgets.getString("DecemberKey")};
        this.monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        this.weekdays = new String[]{widgets.getString("sundayCharKey"), widgets.getString("mondayCharKey"), widgets.getString("tuesdayCharKey"), widgets.getString("wednesdayCharKey"), widgets.getString("thursdayCharKey"), widgets.getString("fridayCharKey"), widgets.getString("saturdayCharKey")};
        this.fullWeekdays = new String[]{widgets.getString("sundayDayKey"), widgets.getString("mondayDayKey"), widgets.getString("tuesdayDayKey"), widgets.getString("wednesdayDayKey"), widgets.getString("thursdayDayKey"), widgets.getString("fridayDayKey"), widgets.getString("saturdayDayKey")};
        this.layoutControls();
        this.setResizable(false);
        this.pack();
        ((Component)this).setSize((Dimension)widgets.getObject("NDateTimeDlgSizeKey"));
        C1Hooks.registerWindow((Window)this);
        this.setName("NDateTimeDlg");
    }

    private class MiniArrowButton
    extends BasicArrowButton
    implements FocusListener {
        private boolean hasFocus = false;

        public boolean isFocusTraversable() {
            return true;
        }

        public void focusGained(FocusEvent focusEvent) {
            NDateTimeDlg.this.setAccessible(focusEvent);
            this.hasFocus = true;
            this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.hasFocus = false;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(3 * dimension.width / 4, 3 * dimension.height / 4);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hasFocus) {
                Dimension dimension = this.getSize();
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            }
        }

        MiniArrowButton(int n) {
            super(n);
            this.addFocusListener(this);
            this.setRequestFocusEnabled(true);
            this.setDefaultCapable(false);
        }
    }

    private class TimeButton
    extends JButton
    implements FocusListener {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width / 2, 3 * dimension.height / 4);
        }

        public boolean isDefaultCapable() {
            return false;
        }

        public void focusGained(FocusEvent focusEvent) {
            NDateTimeDlg.this.setAccessible(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        TimeButton(String string) {
            super(widgets.getImageIcon(string));
            this.addFocusListener(this);
        }
    }

    private class MonthCBRenderer
    extends JLabel
    implements ListCellRenderer {
        public Insets getInsets() {
            return new Insets(1, 5, 1, 5);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }

        public MonthCBRenderer() {
            this.setOpaque(true);
        }
    }

    private class DayCell
    extends JPanel
    implements FocusListener {
        int day;
        JLabel label;
        Color regularForeground;
        Color regularBackground;
        Color selectedForeground = Color.white;
        Color selectedBackground = Color.gray;
        private boolean hasFocus = false;
        private CellMouseAdapter mouseAdapter;
        private CellKeyAdapter keyAdapter;

        public void activate() {
            this.label.setForeground(this.selectedForeground);
            this.setBackground(this.selectedBackground);
            if (!NDateTimeDlg.this.buttonFlag) {
                this.label.requestFocus();
            }
            NDateTimeDlg.this.buttonFlag = false;
            this.repaint();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                DayCell dayCell = this;
                if (dayCell == null) {
                    throw null;
                }
                this.accessibleContext = dayCell.new DayCellAccessible();
            }
            return this.accessibleContext;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.hasFocus = true;
            this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.hasFocus = false;
            this.repaint();
        }

        public void deactivate() {
            this.label.setForeground(this.regularForeground);
            this.setBackground(this.regularBackground);
            this.repaint();
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.hasFocus) {
                Dimension dimension = this.getSize();
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            }
        }

        public DayCell(int n, int n2) {
            super(new BorderLayout());
            this.label = new JLabel(Integer.toString(n), 0);
            int n3 = (n2 + n - 1) % 7 - 1;
            if (n3 == -1) {
                n3 = 6;
            }
            NConeFactory.novellJLabel((JLabel)this.label, (String)(widgets.getString("CurrentDayKey") + NDateTimeDlg.this.fullWeekdays[n3] + n), (String)"");
            NConeFactory.novellJPanel((JPanel)this, (String)(NDateTimeDlg.this.fullWeekdays[n3] + n), (String)"");
            this.label.setForeground(Color.black);
            this.add((Component)this.label, "Center");
            this.day = n;
            DayCell dayCell = this;
            if (dayCell == null) {
                throw null;
            }
            this.mouseAdapter = dayCell.new CellMouseAdapter();
            DayCell dayCell2 = this;
            if (dayCell2 == null) {
                throw null;
            }
            this.keyAdapter = dayCell2.new CellKeyAdapter();
            this.addMouseListener(this.mouseAdapter);
            this.addKeyListener(this.keyAdapter);
            this.addFocusListener(this);
            this.regularForeground = this.label.getForeground();
            this.regularBackground = this.getBackground();
        }

        protected class DayCellAccessible
        extends JComponent.AccessibleJComponent {
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SWING_COMPONENT;
            }

            protected DayCellAccessible() {
                super(DayCell.this);
            }
        }

        private class CellMouseAdapter
        extends MouseAdapter {
            private final /* synthetic */ NDateTimeDlg this$1;

            public void mousePressed(MouseEvent mouseEvent) {
                this.toggle();
                if (mouseEvent.getClickCount() > 1) {
                    this.this$1.okButton.doClick();
                }
            }

            public void toggle() {
                DayCell.this.requestFocus();
                if (DayCell.this.day != this.this$1.currentDay) {
                    DayCell.this.activate();
                    this.this$1.cells[this.this$1.currentDay - 1].deactivate();
                    this.this$1.currentDay = DayCell.this.day;
                    this.this$1.okButton.setEnabled(true);
                }
            }

            CellMouseAdapter() {
                this.this$1 = NDateTimeDlg.this;
            }
        }

        private class CellKeyAdapter
        extends KeyAdapter {
            private final /* synthetic */ NDateTimeDlg this$1;

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10 && DayCell.this.day == this.this$1.currentDay) {
                    this.this$1.okButton.doClick();
                }
                if (n == 32 || n == 10) {
                    DayCell.this.mouseAdapter.toggle();
                }
            }

            CellKeyAdapter() {
                this.this$1 = NDateTimeDlg.this;
            }
        }
    }

    private class DayNameCell
    extends JPanel {
        String day;
        private JLabel label;

        public DayNameCell(String string) {
            super(new BorderLayout());
            this.label = new JLabel(string, 0);
            this.add((Component)this.label, "Center");
            this.day = string;
            this.setForeground(Color.black);
        }
    }
}

