/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class NDualListLayout
implements LayoutManager {
    public static String LEFTLABEL = "leftlabel";
    public static String RIGHTLABEL = "rightlabel";
    public static String LEFTLIST = "leftlist";
    public static String RIGHTLIST = "rightlist";
    public static String TOPBUTTON = "toplist";
    public static String BOTTOMBUTTON = "bottomlist";
    private Component labelLeft;
    private Component labelRight;
    private Component listRight;
    private Component listLeft;
    private Component buttonTop;
    private Component buttonBottom;

    public void addLayoutComponent(String string, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("cannot add to layout: null component: " + string);
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
        }
        if (LEFTLIST.equals(string)) {
            this.listLeft = component;
        } else if (RIGHTLIST.equals(string)) {
            this.listRight = component;
        } else if (TOPBUTTON.equals(string)) {
            this.buttonTop = component;
        } else if (BOTTOMBUTTON.equals(string)) {
            this.buttonBottom = component;
        } else if (LEFTLABEL.equals(string)) {
            this.labelLeft = component;
        } else if (RIGHTLABEL.equals(string)) {
            this.labelRight = component;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.listLeft) {
            this.listLeft = null;
        } else if (component == this.listRight) {
            this.listRight = null;
        } else if (component == this.buttonTop) {
            this.buttonTop = null;
        } else if (component == this.buttonBottom) {
            this.buttonBottom = null;
        } else if (component == this.labelLeft) {
            this.labelLeft = null;
        } else if (component == this.labelRight) {
            this.labelRight = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.buttonTop == null ? new Dimension() : this.buttonTop.getPreferredSize();
        Dimension dimension2 = this.buttonBottom == null ? new Dimension() : this.buttonBottom.getPreferredSize();
        Dimension dimension3 = this.listLeft.getPreferredSize();
        Dimension dimension4 = this.listRight.getPreferredSize();
        Dimension dimension5 = this.labelLeft.getPreferredSize();
        Dimension dimension6 = this.labelRight.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width + Math.max(dimension3.width, dimension5.width) + Math.max(dimension4.width, dimension4.width), Math.max(dimension3.height, dimension4.height));
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.buttonTop == null ? new Dimension() : this.buttonTop.getMinimumSize();
        Dimension dimension2 = this.buttonBottom == null ? new Dimension() : this.buttonBottom.getMinimumSize();
        Dimension dimension3 = this.listLeft.getMinimumSize();
        Dimension dimension4 = this.listRight.getMinimumSize();
        Dimension dimension5 = this.labelLeft.getPreferredSize();
        Dimension dimension6 = this.labelRight.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width + Math.max(dimension3.width, dimension5.width) + Math.max(dimension4.width, dimension4.width), Math.max(dimension3.height, dimension4.height));
    }

    public void layoutContainer(Container container) {
        Dimension dimension = this.buttonTop == null ? new Dimension() : this.buttonTop.getPreferredSize();
        Dimension dimension2 = this.buttonBottom == null ? new Dimension() : this.buttonBottom.getPreferredSize();
        Dimension dimension3 = this.labelLeft.getPreferredSize();
        Dimension dimension4 = this.labelRight.getPreferredSize();
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.getSize().height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.getSize().width - insets.right;
        int n5 = container.getSize().width - (insets.left + insets.right);
        int n6 = container.getSize().height - (insets.top + insets.bottom);
        int n7 = Math.max(dimension.width, dimension2.width);
        int n8 = n7 + 10;
        int n9 = (n5 - n8) / 2;
        int n10 = Math.max(dimension3.height, dimension4.height);
        this.labelLeft.setBounds(n3, n, n9, dimension3.height);
        this.labelRight.setBounds(n4 - n9, n, n9, dimension4.height);
        this.listLeft.setBounds(n3, n + n10, n9, n6 - n10);
        this.listRight.setBounds(n4 - n9, n + n10, n9, n6 - n10);
        int n11 = dimension.height + dimension2.height + 10;
        if (this.buttonTop != null) {
            this.buttonTop.setBounds(n3 + (n5 - n7 + 1) / 2, n10 + (n6 - n11) / 2, n7, dimension.height);
        }
        if (this.buttonBottom != null) {
            this.buttonBottom.setBounds(n3 + (n5 - n7 + 1) / 2, n10 + (n6 + n11 - n11) / 2, n7, dimension2.height);
        }
    }
}

