/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NDualListOrderedLayout;
import com.novell.application.console.widgets.NList;
import com.novell.application.console.widgets.NListNode;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NDualListOrdered
extends JPanel
implements ActionListener {
    public static final int ITEM_ADDED_TO_TARGET = 0;
    public static final int ITEM_DELETED_FROM_TARGET = 1;
    public static final int ITEM_MOVED_UP_IN_TARGET = 2;
    public static final int ITEM_MOVED_DOWN_IN_TARGET = 3;
    public static final String ADD_ITEM_COMMAND = "Add";
    public static final String DELETE_ITEM_COMMAND = "Delete";
    public static final String UP_ITEM_COMMAND = "Up";
    public static final String DOWN_ITEM_COMMAND = "Down";
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private NList sourceList;
    private NList targetList;
    private JLabel sourceLabel;
    private JLabel targetLabel;
    private Vector listeners = new Vector(5);
    private boolean doubleClickAddEnabled = true;

    private void fillSourceList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.sourceList.addNode((NListNode)vector.elementAt(n));
            ++n;
        }
        this.sourceList.sort();
    }

    private void fillTargetList(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.targetList.addNode((NListNode)vector.elementAt(n));
            ++n;
        }
    }

    private void initControls(String string, String string2) {
        this.sourceList = new NList();
        this.targetList = new NList();
        this.sourceList.setName("List1");
        this.targetList.setName("List2");
        this.sourceLabel = new JLabel();
        Loc.setText((JLabel)this.sourceLabel, (Component)this.sourceList, (String)string);
        NConeFactory.makeRelation((JLabel)this.sourceLabel, (NList)this.sourceList);
        this.targetLabel = new JLabel();
        Loc.setText((JLabel)this.targetLabel, (Component)this.targetList, (String)string2);
        NConeFactory.makeRelation((JLabel)this.targetLabel, (NList)this.targetList);
        this.sourceList.getList().setSelectionMode(2);
        this.targetList.getList().setSelectionMode(2);
        NDualListOrdered nDualListOrdered = this;
        if (nDualListOrdered == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(nDualListOrdered){
            private final /* synthetic */ NDualListOrdered this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Object object = mouseEvent.getSource();
                    if (object == NDualListOrdered.access$0(this.this$0).getList()) {
                        if (NDualListOrdered.access$1(this.this$0)) {
                            NDualListOrdered.access$2(this.this$0);
                        }
                    } else if (object == NDualListOrdered.access$3(this.this$0).getList()) {
                        NDualListOrdered.access$4(this.this$0);
                    }
                }
            }
            {
                this.this$0 = nDualListOrdered;
                this.constructor$0(nDualListOrdered);
            }

            private final void constructor$0(NDualListOrdered nDualListOrdered) {
            }
        };
        this.sourceList.getList().addMouseListener(mouseAdapter);
        this.targetList.getList().addMouseListener(mouseAdapter);
        Image image = widgets.getImage("addArrow.gif");
        Image image2 = widgets.getImage("removeArrow.gif");
        Image image3 = widgets.getImage("moveUp.gif");
        Image image4 = widgets.getImage("moveDown.gif");
        if (image3 == null) {
            image3 = widgets.getImage("addArrow.gif");
        }
        if (image4 == null) {
            image4 = widgets.getImage("removeArrow.gif");
        }
        NDualListOrdered nDualListOrdered2 = this;
        if (nDualListOrdered2 == null) {
            throw null;
        }
        this.addButton = NConeFactory.novellJButton((JButton)new JButton(nDualListOrdered2, (Icon)new ImageIcon(image)){
            private final /* synthetic */ NDualListOrdered this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualListOrdered;
                this.constructor$0(nDualListOrdered, icon);
            }

            private final void constructor$0(NDualListOrdered nDualListOrdered, Icon icon) {
            }
        }, (String)widgets.getString("addKey"), (String)"This is a button");
        NDualListOrdered nDualListOrdered3 = this;
        if (nDualListOrdered3 == null) {
            throw null;
        }
        this.removeButton = NConeFactory.novellJButton((JButton)new JButton(nDualListOrdered3, (Icon)new ImageIcon(image2)){
            private final /* synthetic */ NDualListOrdered this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualListOrdered;
                this.constructor$0(nDualListOrdered, icon);
            }

            private final void constructor$0(NDualListOrdered nDualListOrdered, Icon icon) {
            }
        }, (String)widgets.getString("removeKey"), (String)"This is a button");
        NDualListOrdered nDualListOrdered4 = this;
        if (nDualListOrdered4 == null) {
            throw null;
        }
        this.upButton = NConeFactory.novellJButton((JButton)new JButton(nDualListOrdered4, (Icon)new ImageIcon(image3)){
            private final /* synthetic */ NDualListOrdered this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualListOrdered;
                this.constructor$0(nDualListOrdered, icon);
            }

            private final void constructor$0(NDualListOrdered nDualListOrdered, Icon icon) {
            }
        }, (String)UP_ITEM_COMMAND, (String)"This is a button");
        NDualListOrdered nDualListOrdered5 = this;
        if (nDualListOrdered5 == null) {
            throw null;
        }
        this.downButton = NConeFactory.novellJButton((JButton)new JButton(nDualListOrdered5, (Icon)new ImageIcon(image4)){
            private final /* synthetic */ NDualListOrdered this$0;

            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
            {
                this.this$0 = nDualListOrdered;
                this.constructor$0(nDualListOrdered, icon);
            }

            private final void constructor$0(NDualListOrdered nDualListOrdered, Icon icon) {
            }
        }, (String)"down", (String)"This is a button");
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.addButton.setName(ADD_ITEM_COMMAND);
        this.removeButton.setName("Remove");
        this.upButton.setName(UP_ITEM_COMMAND);
        this.downButton.setName(DOWN_ITEM_COMMAND);
        this.add(NDualListOrderedLayout.LEFTLABEL, this.sourceLabel);
        this.add(NDualListOrderedLayout.RIGHTLABEL, this.targetLabel);
        this.add(NDualListOrderedLayout.LEFTLIST, this.sourceList);
        this.add(NDualListOrderedLayout.RIGHTLIST, this.targetList);
        this.add(NDualListOrderedLayout.ADDBUTTON, this.addButton);
        this.add(NDualListOrderedLayout.REMOVEBUTTON, this.removeButton);
        this.add(NDualListOrderedLayout.UPBUTTON, this.upButton);
        this.add(NDualListOrderedLayout.DOWNBUTTON, this.downButton);
    }

    public void addSourceNode(NListNode nListNode) {
        this.sourceList.addNode(nListNode);
        this.sourceList.sort();
    }

    public void addSourceNodes(Vector vector) {
        this.fillSourceList(vector);
    }

    public void addTargetNode(NListNode nListNode) {
        this.targetList.addNode(nListNode);
    }

    public void addTargetNodes(Vector vector) {
        this.fillTargetList(vector);
    }

    public void clearSourceList() {
        this.sourceList.removeAllNodes();
    }

    public void clearTargetList() {
        this.targetList.removeAllNodes();
    }

    public void clearLists() {
        this.clearSourceList();
        this.clearTargetList();
    }

    public void refresh() {
        this.sourceList.getList().repaint();
        this.targetList.getList().repaint();
    }

    public int getTargetCount() {
        return this.targetList.getNumNodes();
    }

    public int getSourceCount() {
        return this.sourceList.getNumNodes();
    }

    public String[] getTargetItems() {
        int n = this.targetList.getNumNodes();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.targetList.getNodeAt(n2).getText();
            ++n2;
        }
        return stringArray;
    }

    public NListNode[] getTargetNodes() {
        return this.targetList.getNodes();
    }

    public void setVisibleRowCount(int n) {
        this.sourceList.getList().setVisibleRowCount(n);
        this.targetList.getList().setVisibleRowCount(n);
    }

    public void requestFocus() {
        super.requestFocus();
        this.sourceList.getList().requestFocus();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        boolean bl = false;
        int n = 0;
        while (n < this.listeners.size()) {
            if ((ActionListener)this.listeners.elementAt(n) == actionListener) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.listeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.listeners.contains(actionListener)) {
            this.listeners.removeElement(actionListener);
        }
    }

    public void enableMultipleSelectionMode() {
        this.sourceList.getList().setSelectionMode(2);
        this.targetList.getList().setSelectionMode(2);
    }

    public void enableSingleSelectionMode() {
        this.sourceList.getList().setSelectionMode(0);
        this.targetList.getList().setSelectionMode(0);
    }

    public void enableUpButton(boolean bl) {
        this.upButton.setEnabled(bl);
    }

    public void enableDownButton(boolean bl) {
        this.downButton.setEnabled(bl);
    }

    public void enableAddButton(boolean bl) {
        this.addButton.setEnabled(bl);
    }

    public void enableRemoveButton(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    public void enableDoubleClickAdd(boolean bl) {
        this.doubleClickAddEnabled = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.addPressed();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.removePressed();
        } else if (actionEvent.getSource() == this.upButton) {
            this.upPressed();
        } else if (actionEvent.getSource() == this.downButton) {
            this.downPressed();
        }
    }

    private void addPressed() {
        NListNode[] nListNodeArray = this.sourceList.getSelectedNodes();
        int n = this.sourceList.getList().getSelectedIndex();
        int n2 = 0;
        while (n2 < nListNodeArray.length) {
            NListNode nListNode = nListNodeArray[n2];
            if (nListNode.isEnabled()) {
                this.sourceList.removeNode(nListNode);
                this.targetList.addNode(nListNode);
            }
            ++n2;
        }
        if (this.sourceList.getNumNodes() > 0) {
            this.sourceList.getList().setSelectedIndex(n);
        } else {
            this.sourceList.getList().clearSelection();
            this.targetList.getList().setSelectedIndex(0);
        }
        this.repaint();
        this.dispatch(0, ADD_ITEM_COMMAND);
    }

    private void removePressed() {
        NListNode[] nListNodeArray = this.targetList.getSelectedNodes();
        int n = this.sourceList.getList().getSelectedIndex();
        int n2 = 0;
        while (n2 < nListNodeArray.length) {
            NListNode nListNode = nListNodeArray[n2];
            if (nListNode.isEnabled()) {
                this.targetList.removeNode(nListNode);
                this.sourceList.addNode(nListNode);
            }
            ++n2;
        }
        this.sourceList.sort();
        if (this.targetList.getNumNodes() > 0) {
            this.targetList.getList().setSelectedIndex(n);
        } else {
            this.targetList.getList().clearSelection();
            this.sourceList.getList().setSelectedIndex(0);
        }
        this.repaint();
        this.dispatch(1, DELETE_ITEM_COMMAND);
    }

    private void upPressed() {
        if (this.targetList.getNumSelectedNodes() > 1) {
            return;
        }
        int n = this.targetList.getList().getSelectedIndex();
        if (n == 0) {
            return;
        }
        NListNode nListNode = this.targetList.getNodeAt(n);
        this.targetList.removeNodeAt(n);
        this.targetList.insertNodeAt(nListNode, n - 1);
        this.targetList.setSelectedIndex(n - 1);
        this.repaint();
        this.dispatch(2, UP_ITEM_COMMAND);
    }

    private void downPressed() {
        int n;
        if (this.targetList.getNumSelectedNodes() > 1) {
            return;
        }
        int n2 = this.targetList.getList().getSelectedIndex();
        if (n2 == (n = this.targetList.getNumNodes()) - 1) {
            return;
        }
        NListNode nListNode = this.targetList.getNodeAt(n2);
        this.targetList.removeNodeAt(n2);
        this.targetList.insertNodeAt(nListNode, n2 + 1);
        this.targetList.setSelectedIndex(n2 + 1);
        this.repaint();
        this.dispatch(3, DOWN_ITEM_COMMAND);
    }

    private void dispatch(int n, String string) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ActionEvent actionEvent = new ActionEvent(this, n, string);
            ((ActionListener)this.listeners.elementAt(n2)).actionPerformed(actionEvent);
            ++n2;
        }
    }

    static /* synthetic */ NList access$0(NDualListOrdered nDualListOrdered) {
        return nDualListOrdered.sourceList;
    }

    static /* synthetic */ boolean access$1(NDualListOrdered nDualListOrdered) {
        return nDualListOrdered.doubleClickAddEnabled;
    }

    static /* synthetic */ void access$2(NDualListOrdered nDualListOrdered) {
        nDualListOrdered.addPressed();
    }

    static /* synthetic */ NList access$3(NDualListOrdered nDualListOrdered) {
        return nDualListOrdered.targetList;
    }

    static /* synthetic */ void access$4(NDualListOrdered nDualListOrdered) {
        nDualListOrdered.removePressed();
    }

    public NDualListOrdered(Vector vector, Vector vector2, String string, String string2) {
        this.setLayout(new NDualListOrderedLayout());
        this.initControls(string, string2);
        this.fillSourceList(vector);
        this.fillTargetList(vector2);
    }
}

