/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class NHexTextField
extends NTextField
implements KeyListener {
    private static final int BAD_HEX_STRING = 1;
    private int upperLimit;
    private String hexCharacterSet = "0123456789ABCDEFabcdef";
    private String lastValidEntry = "";

    public int getUpperBound() {
        return this.upperLimit;
    }

    public void setUpperBound(int n) {
        this.upperLimit = n;
    }

    public void keyTyped(KeyEvent keyEvent) {
        String string = this.getText();
        char c = keyEvent.getKeyChar();
        int n = this.getCaretPosition();
        if (!keyEvent.isActionKey()) {
            if (Character.isISOControl(c)) {
                if (string.length() > this.upperLimit && this.upperLimit > 0) {
                    this.getToolkit().beep();
                    this.setText(this.lastValidEntry);
                } else {
                    int n2 = 0;
                    while (n2 < string.length()) {
                        if (!this.isHexDigit(string.charAt(n2))) {
                            this.getToolkit().beep();
                            this.setText(this.lastValidEntry);
                            break;
                        }
                        ++n2;
                    }
                }
            } else if (string.length() + 1 > this.upperLimit && this.upperLimit > 0 || !this.isHexDigit(c)) {
                this.getToolkit().beep();
                keyEvent.consume();
            }
        }
        this.setModified(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.lastValidEntry = this.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void setText(String string) {
        super.setText(string);
        this.lastValidEntry = string;
    }

    private boolean isHexDigit(char c) {
        return this.hexCharacterSet.indexOf(c) != -1;
    }

    public NHexTextField(int n) {
        this.upperLimit = n;
        this.addKeyListener(this);
    }

    public NHexTextField(int n, int n2) {
        super(n);
        this.upperLimit = n2;
        this.addKeyListener(this);
    }

    public NHexTextField(String string, int n) {
        super(string);
        this.lastValidEntry = string;
        int n2 = 0;
        while (n2 < string.length()) {
            if (!this.isHexDigit(string.charAt(n2))) {
                throw new RuntimeException(this.getClass().getName());
            }
            ++n2;
        }
        this.upperLimit = n;
        this.addKeyListener(this);
    }

    public NHexTextField(String string, int n, int n2) {
        super(string, n);
        this.lastValidEntry = string;
        int n3 = 0;
        while (n3 < string.length()) {
            if (!this.isHexDigit(string.charAt(n3))) {
                throw new RuntimeException(this.getClass().getName());
            }
            ++n3;
        }
        this.upperLimit = n2;
        this.addKeyListener(this);
    }
}

