/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTextField;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;

public class NIntTextField
extends NTextField
implements KeyListener,
FocusListener {
    private long upperLimit;
    private long lowerLimit;
    private Component parent;
    private String lastValidEntry = "";

    public boolean isDataValid() {
        long l;
        try {
            l = this.getLongValue();
        }
        catch (Exception exception) {
            return false;
        }
        return l >= this.lowerLimit && l <= this.upperLimit;
    }

    public long getLongValue() {
        return Long.valueOf(this.getText());
    }

    public int getIntValue() {
        return Integer.valueOf(this.getText());
    }

    public void setLongValue(long l) {
        this.setText(Long.toString(l));
    }

    public void setIntValue(int n) {
        this.setText(Integer.toString(n));
    }

    public void setText(String string) {
        super.setText(string);
        this.lastValidEntry = string;
    }

    public void setLowerBound(long l) {
        this.lowerLimit = l;
    }

    public void displayError() {
        String string = MessageFormat.format(widgets.getString("invalidEntryPatternKey"), Long.toString(this.lowerLimit), Long.toString(this.upperLimit));
        NMsgBox nMsgBox = new NMsgBox(this.parent, widgets.getString("invalidEntryKey"), string, 3);
        this.getToolkit().beep();
        nMsgBox.setVisible(true);
        this.requestFocus();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = this.getCaretPosition();
        String string = this.getText();
        boolean bl = false;
        String string2 = this.getSelectedText();
        if (string2 != null && string2.length() != 0) {
            bl = true;
        }
        if (Character.isDigit(c)) {
            if (!bl) {
                if (string.length() != 0 && n2 == 0 && string.charAt(0) == '-') {
                    this.getToolkit().beep();
                    keyEvent.consume();
                }
                try {
                    String string3 = string.substring(0, n2) + c + string.substring(n2, string.length());
                    long l = Long.valueOf(string3);
                    if (l < this.lowerLimit || l > this.upperLimit) {
                        this.displayError();
                        keyEvent.consume();
                    }
                }
                catch (Exception exception) {
                    this.displayError();
                    keyEvent.consume();
                }
            } else {
                try {
                    long l = Long.valueOf(String.valueOf(c));
                    if (l < this.lowerLimit || l > this.upperLimit) {
                        this.displayError();
                        keyEvent.consume();
                    }
                }
                catch (Exception exception) {
                    this.displayError();
                    keyEvent.consume();
                }
            }
        } else if (!keyEvent.isActionKey()) {
            if (c == '-') {
                if (n2 != 0 && !bl) {
                    this.getToolkit().beep();
                    keyEvent.consume();
                } else if (this.lowerLimit >= 0L) {
                    this.displayError();
                    keyEvent.consume();
                }
            } else if (!Character.isISOControl(c)) {
                this.getToolkit().beep();
                keyEvent.consume();
            } else if (Character.isISOControl(c) && string.length() > 0 && !bl && !string.equals("-")) {
                try {
                    long l = Long.valueOf(string);
                    if (l < this.lowerLimit || l > this.upperLimit) {
                        this.getToolkit().beep();
                        keyEvent.consume();
                        this.setText(this.lastValidEntry);
                    }
                }
                catch (Exception exception) {
                    this.getToolkit().beep();
                    keyEvent.consume();
                    this.setText(this.lastValidEntry);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.lastValidEntry = this.getText();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.getText().equals("-")) {
            this.setText("");
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public NIntTextField(int n, long l) {
        super(n);
        this.lowerLimit = 1L;
        this.upperLimit = l;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.parent = widgets.getFrame(this);
    }

    public NIntTextField(int n, long l, Component component) {
        super(n);
        this.lowerLimit = 1L;
        this.upperLimit = l;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.parent = component;
    }

    public NIntTextField(int n, long l, long l2) {
        super(n);
        this.lowerLimit = l;
        this.upperLimit = l2;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.parent = widgets.getFrame(this);
    }

    public NIntTextField(String string, long l, long l2) {
        super(string);
        this.lastValidEntry = string;
        this.lowerLimit = l;
        this.upperLimit = l2;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.parent = widgets.getFrame(this);
    }

    public NIntTextField(String string, int n, long l, long l2) {
        super(string, n);
        this.lastValidEntry = string;
        this.lowerLimit = l;
        this.upperLimit = l2;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.parent = widgets.getFrame(this);
    }
}

