/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.testing.C1Automation;
import com.novell.application.console.widgets.NListDataModel;
import com.novell.application.console.widgets.NListNode;
import com.novell.application.console.widgets.NListRenderer;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;

public class NList
extends JScrollPane
implements KeyListener,
AdjustmentListener,
C1Automation {
    private String searchBuffer = "";
    private NListDataModel dataModel;
    private String lastChar;
    private JList list = new JList();
    private JScrollBar vsb;
    private int alignment = 2;
    private int leadIndex;

    public String[] getSelectedStrings() {
        if (this.getNumNodes() > 0) {
            Object[] objectArray = this.list.getSelectedValues();
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                NListNode nListNode = (NListNode)objectArray[n];
                stringArray[n] = nListNode.toString();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return this.list.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getSelectedString() {
        if (this.getNumNodes() > 0) {
            return ((NListNode)this.list.getSelectedValue()).toString();
        }
        return null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        switch (keyEvent.getKeyCode()) {
            case 34: {
                int n = this.list.getSelectedIndex();
                int n2 = this.vsb.getBlockIncrement();
                int n3 = n + n2;
                if (keyEvent.isShiftDown()) {
                    if (this.list.getSelectionMode() == 1) {
                        if (this.leadIndex != -1) {
                            this.leadIndex = Math.min(this.leadIndex + n2, this.dataModel.getSize() - 1);
                        }
                        this.list.setSelectionInterval(n, this.leadIndex);
                        this.list.ensureIndexIsVisible(this.leadIndex);
                        break;
                    }
                    this.list.setSelectedIndex(n);
                    keyEvent.consume();
                    break;
                }
                this.leadIndex = -1;
                if (n3 < this.dataModel.getSize()) {
                    this.list.setSelectedIndex(n3);
                    this.list.ensureIndexIsVisible(n3 - 1);
                    break;
                }
                n3 = this.dataModel.getSize() - 1;
                this.list.setSelectedIndex(n3);
                this.list.ensureIndexIsVisible(n3);
                break;
            }
            case 33: {
                int n = this.list.getSelectedIndex();
                int n4 = this.vsb.getBlockIncrement();
                int n5 = n - n4;
                if (keyEvent.isShiftDown()) {
                    if (this.list.getSelectionMode() == 1) {
                        if (this.leadIndex != -1) {
                            this.leadIndex = Math.max(0, this.leadIndex - n4);
                        }
                        this.list.setSelectionInterval(n, this.leadIndex);
                        this.list.ensureIndexIsVisible(this.leadIndex);
                        break;
                    }
                    this.list.setSelectedIndex(n);
                    keyEvent.consume();
                    break;
                }
                this.leadIndex = -1;
                if (n5 > 0) {
                    this.list.setSelectedIndex(n5);
                    this.list.ensureIndexIsVisible(n5 - 1);
                    break;
                }
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
                break;
            }
            case 36: {
                int n = this.list.getSelectedIndex();
                int n6 = this.dataModel.getSize() - 1;
                if (keyEvent.isShiftDown()) {
                    if (this.list.getSelectionMode() == 1) {
                        this.leadIndex = 0;
                        this.list.setSelectionInterval(n, this.leadIndex);
                        this.list.ensureIndexIsVisible(this.leadIndex);
                        break;
                    }
                    this.list.setSelectedIndex(n);
                    keyEvent.consume();
                    break;
                }
                this.leadIndex = -1;
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
                break;
            }
            case 35: {
                int n = this.list.getSelectedIndex();
                int n7 = this.dataModel.getSize() - 1;
                if (keyEvent.isShiftDown()) {
                    if (this.list.getSelectionMode() == 1) {
                        this.leadIndex = n7;
                        this.list.setSelectionInterval(n, this.leadIndex);
                        this.list.ensureIndexIsVisible(this.leadIndex);
                        break;
                    }
                    this.list.setSelectedIndex(n);
                    keyEvent.consume();
                    break;
                }
                this.leadIndex = -1;
                this.list.setSelectedIndex(n7);
                this.list.ensureIndexIsVisible(n7);
                break;
            }
            case 40: {
                if (!keyEvent.isShiftDown() || this.list.getSelectionMode() != 0) break;
                this.list.setSelectedIndex(this.list.getSelectedIndex());
                keyEvent.consume();
                break;
            }
            case 38: {
                if (!keyEvent.isShiftDown() || this.list.getSelectionMode() != 0) break;
                this.list.setSelectedIndex(this.list.getSelectedIndex());
                keyEvent.consume();
                break;
            }
            default: {
                char c;
                int n = keyEvent.getModifiers();
                if (n == 8 || n == 2 || n == 4) break;
                this.leadIndex = -1;
                if (keyEvent.getID() != 401 || !NList.isValidCharacter(c = keyEvent.getKeyChar())) break;
                this.lastChar = "" + c;
                this.searchBuffer = this.searchBuffer + this.lastChar;
                this.searchTo(this.searchBuffer);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    public boolean searchTo(String string) {
        int n = this.list.getSelectedIndex();
        int n2 = this.dataModel.find(n, string);
        if (n2 != -1) {
            this.list.setSelectedIndex(n2);
            this.list.ensureIndexIsVisible(n2);
            return true;
        }
        n2 = this.dataModel.find(0, string);
        if (n2 != -1) {
            this.list.setSelectedIndex(n2);
            this.list.ensureIndexIsVisible(n2);
            return true;
        }
        if (this.lastChar == null) {
            return false;
        }
        this.searchBuffer = string = this.lastChar.toLowerCase();
        n = n + 1 < this.dataModel.getSize() ? ++n : 0;
        n2 = this.dataModel.find(n, string);
        if (n2 != -1) {
            this.list.setSelectedIndex(n2);
            this.list.ensureIndexIsVisible(n2);
            return true;
        }
        n2 = this.dataModel.find(0, string);
        if (n2 != -1) {
            this.list.setSelectedIndex(n2);
            this.list.ensureIndexIsVisible(n2);
            return true;
        }
        this.searchBuffer = "";
        return false;
    }

    static boolean isValidCharacter(char c) {
        boolean bl = true;
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            default: {
                if (c == ' ') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void addNode(NListNode nListNode) {
        this.dataModel.addNode(nListNode);
    }

    public void addNode(String string, Image image) {
        NListNode nListNode = new NListNode(string, new ImageIcon(image), this.alignment);
        this.dataModel.addNode(nListNode);
    }

    public void addNode(String string) {
        NListNode nListNode = new NListNode(string, this.alignment);
        this.dataModel.addNode(nListNode);
    }

    public void addNode(String string, Icon icon) {
        NListNode nListNode = new NListNode(string, icon, this.alignment);
        this.dataModel.addNode(nListNode);
    }

    public void setNodes(Vector vector) {
        this.dataModel.setNodes(vector);
    }

    public void addNodes(Vector vector) {
        this.dataModel.addNodes(vector);
    }

    public void addNodes(Array array) {
        Vector<Object> vector = new Vector<Object>(array.size());
        int n = 0;
        while (n < array.size()) {
            vector.addElement(array.at(n));
            ++n;
        }
        this.dataModel.addNodes(vector);
    }

    public int getNumNodes() {
        return this.dataModel.getSize();
    }

    public NListNode[] getNodes() {
        int n = this.getNumNodes();
        NListNode[] nListNodeArray = new NListNode[n];
        int n2 = 0;
        while (n2 < n) {
            nListNodeArray[n2] = this.getNodeAt(n2);
            ++n2;
        }
        return nListNodeArray;
    }

    public int getNumSelectedNodes() {
        if (this.getNumNodes() == 0) {
            return 0;
        }
        int[] nArray = this.list.getSelectedIndices();
        if (nArray == null) {
            return 0;
        }
        return nArray.length;
    }

    public NListNode getNodeAt(int n) {
        return (NListNode)this.dataModel.getElementAt(n);
    }

    public NListNode getSelectedNode() {
        return this.getNodeAt(this.list.getSelectedIndex());
    }

    public NListNode[] getSelectedNodes() {
        int[] nArray = this.list.getSelectedIndices();
        NListNode[] nListNodeArray = new NListNode[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nListNodeArray[n] = this.getNodeAt(nArray[n]);
            ++n;
        }
        return nListNodeArray;
    }

    public void insertNodeAt(NListNode nListNode, int n) {
        this.dataModel.insertNodeAt(nListNode, n);
    }

    public void removeNode(NListNode nListNode) {
        this.dataModel.removeNode(nListNode);
    }

    public void removeNodeAt(int n) {
        this.dataModel.removeNodesAt(n, n);
    }

    public void removeNodesAt(int n, int n2) {
        this.dataModel.removeNodesAt(n, n2);
    }

    public void removeAllNodes() {
        this.dataModel.removeAllNodes();
    }

    public void sort() {
        this.dataModel.sort();
    }

    public void slowSort() {
        this.dataModel.slowSort();
    }

    public JList getList() {
        return this.list;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.list.setCellRenderer(listCellRenderer);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public void setVisibleRowCount(int n) {
        this.list.setVisibleRowCount(n);
    }

    public Vector c1AutomationInvoke(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        if (vector == null) {
            vector2.addElement("listFind");
            vector2.addElement("listGetCount");
            vector2.addElement("listGetItems");
            vector2.addElement("listGetSelectedItems");
            vector2.addElement("listGetSelectedItem");
            vector2.addElement("listMultiSelect");
            vector2.addElement("listSelectAll");
            vector2.addElement("listSelect");
            vector2.addElement("listUnselectAll");
            return vector2;
        }
        String string = (String)vector.elementAt(0);
        this.requestFocus();
        if (string.equalsIgnoreCase("listFind")) {
            if (this.getNumNodes() == -1) {
                vector2.addElement(new Boolean(false));
                return vector2;
            }
            NListNode[] nListNodeArray = this.getNodes();
            String string2 = (String)vector.elementAt(1);
            boolean bl = false;
            int n = 0;
            while (n < nListNodeArray.length) {
                if (string2.equalsIgnoreCase(nListNodeArray[n].toString())) {
                    bl = true;
                    vector2.addElement(new Boolean(true));
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector2.addElement(new Boolean(false));
                vector2.addElement("Not found in Nlist: " + string2);
            }
        } else if (string.equalsIgnoreCase("listGetCount")) {
            int n = this.getNumNodes();
            if (n == -1) {
                vector2.addElement(new Integer(0));
            } else {
                vector2.addElement(new Integer(n));
            }
        } else if (string.equalsIgnoreCase("listGetItems")) {
            int n = this.getNumNodes();
            if (n == -1) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("No items located in NList");
            }
            String[] stringArray = new String[n];
            NListNode[] nListNodeArray = this.getNodes();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = new String(nListNodeArray[n2].toString());
                ++n2;
            }
            vector2.addElement(stringArray);
        } else if (string.equalsIgnoreCase("listGetSelectedItems")) {
            NListNode[] nListNodeArray = this.getSelectedNodes();
            if (nListNodeArray.length == 0) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("No items were selected in NList");
            }
            int n = 0;
            while (n < nListNodeArray.length) {
                vector2.addElement(nListNodeArray[n].toString());
                ++n;
            }
        } else if (string.equalsIgnoreCase("listGetSelectedItem")) {
            String string3;
            try {
                string3 = this.getSelectedString();
            }
            catch (NullPointerException nullPointerException) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("No item selected in specified NList");
                return vector2;
            }
            vector2.addElement(string3);
        } else if (string.equalsIgnoreCase("listMultiSelect")) {
            JList jList = this.list;
            Vector<Integer> vector3 = new Vector<Integer>();
            if (this.getSelectionMode() != 2) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("NList does not support multiple selection");
                return vector2;
            }
            int n = 1;
            while (n < vector.size()) {
                String string4 = (String)vector.elementAt(n);
                int n3 = 0;
                while (n3 < this.getNumNodes()) {
                    NListNode nListNode = this.getNodeAt(n3);
                    if (nListNode.toString().equalsIgnoreCase(string4)) {
                        vector3.addElement(new Integer(n3));
                        break;
                    }
                    ++n3;
                }
                ++n;
            }
            int[] nArray = new int[vector3.size()];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = (Integer)vector3.elementAt(n);
                ++n;
            }
            jList.setSelectedIndices(nArray);
        } else if (string.equalsIgnoreCase("listSelectAll")) {
            if (this.getSelectionMode() != 2) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("This NList does not support multiple selection");
                return vector2;
            }
            int[] nArray = new int[this.getNumNodes()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            this.list.setSelectedIndices(nArray);
        } else if (string.equalsIgnoreCase("listSelect")) {
            if (this.getNumNodes() == -1) {
                vector2.addElement(new Integer(-1));
                vector2.addElement("No items located in this NList");
                return vector2;
            }
            if (vector.elementAt(1) instanceof String) {
                String string5 = (String)vector.elementAt(1);
                int n = 0;
                while (n < this.getNumNodes()) {
                    if (this.getNodeAt(n).toString().equalsIgnoreCase(string5)) {
                        vector2.addElement(new Boolean(true));
                        this.list.setSelectedIndex(n);
                        return vector2;
                    }
                    ++n;
                }
                vector2.addElement(new Integer(-1));
                vector2.addElement("Item does not exist in NList: " + (String)vector.elementAt(1));
            } else if (vector.elementAt(1) instanceof Integer) {
                int n = (Integer)vector.elementAt(1);
                int n4 = this.getNumNodes();
                if (n4 == -1) {
                    vector2.addElement(new Integer(-1));
                    vector2.addElement("No items located in specified NList");
                    return vector2;
                }
                if (n > n4 - 1) {
                    vector2.addElement(new Integer(-1));
                    vector2.addElement("IndexOutOfBounds error. Only " + n4 + " items detected in list");
                    return vector2;
                }
                this.list.setSelectedIndex(n);
            } else {
                vector.addElement(new Integer(-1));
                vector.addElement("Invalid argument to NList::listSelect");
            }
        } else if (string.equalsIgnoreCase("listUnselectAll")) {
            this.clearSelection();
        } else {
            vector2.addElement(new Integer(-1));
            vector2.addElement(string + " not supported in NList::c1AutomationInvoke override");
        }
        return vector2;
    }

    public NList() {
        this.getViewport().setView(this.list);
        this.vsb = this.getVerticalScrollBar();
        Font font = this.list.getFont();
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
        this.vsb.setUnitIncrement(fontMetrics.getHeight());
        this.vsb.addAdjustmentListener(this);
        this.list.addKeyListener(this);
        this.list.setCellRenderer(new NListRenderer());
        this.dataModel = new NListDataModel(new Vector());
        this.list.setModel(this.dataModel);
        this.list.setBorder(new BevelBorder(1));
        this.list.setSelectionMode(0);
        this.list.setDoubleBuffered(true);
        this.list.setSelectedIndex(0);
    }

    public NList(Vector vector) {
        this();
        this.dataModel.setNodes(vector);
    }

    public NList(NListNode[] nListNodeArray) {
        this();
        this.dataModel.setNodes(nListNodeArray);
    }
}

