/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NListNode;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.DList;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Sorting;
import com.objectspace.jgl.predicates.LessCollator;
import com.objectspace.jgl.predicates.LessString;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class NListDataModel
implements ListModel {
    private Vector dataListeners;
    private DList totalNodes = new DList();

    public void addListDataListener(ListDataListener listDataListener) {
        if (!this.dataListeners.contains(listDataListener)) {
            this.dataListeners.addElement(listDataListener);
        }
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        if (this.dataListeners.contains(listDataListener)) {
            this.dataListeners.removeElement(listDataListener);
        }
    }

    public Object getElementAt(int n) {
        if (n >= 0 && n < this.totalNodes.size()) {
            Object object = this.totalNodes.at(n);
            if (object instanceof String) {
                object = new NListNode((String)object);
            }
            if (!(object instanceof JLabel)) {
                throw new RuntimeException("Object type not supported in NList");
            }
            return object;
        }
        return null;
    }

    public int getSize() {
        return this.totalNodes.size();
    }

    public void setNodes(Vector vector) {
        this.totalNodes.clear();
        int n = 0;
        while (n < vector.size()) {
            this.totalNodes.add(vector.elementAt(n));
            ++n;
        }
        this.notifyContentsChanged();
    }

    public void setNodes(NListNode[] nListNodeArray) {
        this.totalNodes.clear();
        int n = 0;
        while (n < nListNodeArray.length) {
            this.totalNodes.add((Object)nListNodeArray[n]);
            ++n;
        }
        this.notifyContentsChanged();
    }

    public void addNodes(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.totalNodes.add(vector.elementAt(n));
            ++n;
        }
        this.notifyContentsChanged();
    }

    public void addNode(NListNode nListNode) {
        this.totalNodes.add((Object)nListNode);
        this.notifyContentsChanged();
    }

    public void addNodes(NListNode[] nListNodeArray) {
        int n = 0;
        while (n < nListNodeArray.length) {
            this.totalNodes.add((Object)nListNodeArray[n]);
            ++n;
        }
        this.notifyContentsChanged();
    }

    public void insertNodeAt(NListNode nListNode, int n) {
        if (n >= 0 && n <= this.totalNodes.size()) {
            this.totalNodes.insert(n, (Object)nListNode);
        }
        this.notifyContentsChanged();
    }

    public void removeAllNodes() {
        this.totalNodes.clear();
        this.notifyContentsChanged();
    }

    public void removeNodesAt(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            if (n3 <= this.totalNodes.size() - 1 && n3 >= 0) {
                this.totalNodes.remove(n3);
            }
            --n3;
        }
        this.notifyContentsChanged();
    }

    public void removeNode(NListNode nListNode) {
        this.totalNodes.remove((Object)nListNode);
        this.notifyContentsChanged();
    }

    public Vector getAllNodes() {
        Vector<Object> vector = new Vector<Object>(this.totalNodes.size());
        int n = 0;
        while (n < this.totalNodes.size()) {
            vector.addElement(this.totalNodes.at(n));
            ++n;
        }
        return vector;
    }

    public void sort() {
        Sorting.sort((Sequence)this.totalNodes, (BinaryPredicate)new LessString());
        this.notifyContentsChanged();
    }

    public void slowSort() {
        Sorting.sort((Sequence)this.totalNodes, (BinaryPredicate)new LessCollator());
        this.notifyContentsChanged();
    }

    public int find(int n, String string) {
        string = string.toUpperCase();
        int n2 = n;
        while (n2 < this.totalNodes.size()) {
            String string2 = this.totalNodes.at(n2).toString();
            if ((string2 = string2.toUpperCase()).startsWith(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void notifyContentsChanged() {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.totalNodes.size() - 1);
        int n = 0;
        while (n < this.dataListeners.size()) {
            ((ListDataListener)this.dataListeners.elementAt(n)).contentsChanged(listDataEvent);
            ++n;
        }
    }

    NListDataModel(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.totalNodes.add(vector.elementAt(n));
            ++n;
        }
        this.dataListeners = new Vector();
    }
}

