/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.widgets.NTab;
import com.novell.application.console.widgets.NTabsEvent;
import com.novell.application.console.widgets.NTabsListener;
import com.novell.application.console.widgets.Page;
import com.novell.application.console.widgets.widgets;
import com.objectspace.jgl.Array;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;

class NTabs
extends JComponent
implements ItemListener,
FocusListener,
KeyListener,
Accessible {
    static Font normalFont = new Font("Dialog", 0, 11);
    static Font selectFont = new Font("Dialog", 1, 11);
    static Color fgColor = null;
    static Color bgColor = null;
    static FontMetrics fmn = null;
    static FontMetrics fms = null;
    private NTab clickedTab = null;
    private NTab leftMost = null;
    private NTab selectedTab = null;
    private Array theListeners = null;
    private boolean scrollers = false;
    private boolean lButtonUp = true;
    private boolean rButtonUp = true;
    private boolean lButtonEnabled = false;
    private boolean rButtonEnabled = true;
    private boolean haveFocus = false;
    private Rectangle lScrollButton = new Rectangle();
    private Rectangle rScrollButton = new Rectangle();
    private Array theTabs = null;
    private String menuSelection = null;

    public void addNTabsListener(NTabsListener nTabsListener) {
        this.theListeners.add((Object)nTabsListener);
    }

    public void removeNTabsListener(NTabsListener nTabsListener) {
        this.theListeners.remove((Object)nTabsListener);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this != null && this.selectedTab.tabTitle != null) {
            NConeFactory.novellJComponent((JComponent)this, (String)(this.selectedTab.tabTitle + "\t" + this.selectedTab.getDefaultPageTitle() + widgets.getString("tabKey")), (String)"");
        }
        this.haveFocus = true;
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            NTabs nTabs = this;
            if (nTabs == null) {
                throw null;
            }
            this.accessibleContext = nTabs.new NTabsAccessible();
        }
        return this.accessibleContext;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.haveFocus = false;
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            int n = this.theTabs.indexOf((Object)this.selectedTab);
            if (n == 0) {
                n = this.theTabs.size() - 1;
            } else {
                --n;
                if (this.leftMost == this.selectedTab) {
                    this.leftMost = (NTab)this.theTabs.at(n);
                }
            }
            this.clickedTab = (NTab)this.theTabs.at(n);
            this.switchTab(false);
        } else if (keyEvent.getKeyCode() == 39) {
            int n = this.theTabs.indexOf((Object)this.selectedTab);
            if (n + 1 == this.theTabs.size()) {
                n = 0;
                this.leftMost = (NTab)this.theTabs.at(n);
            } else {
                ++n;
            }
            this.clickedTab = (NTab)this.theTabs.at(n);
            this.switchTab(false);
        } else if (keyEvent.getKeyCode() == 38) {
            if (this.selectedTab.isExtended()) {
                Array array = this.selectedTab.getPages();
                int n = array.indexOf((Object)this.selectedTab.findPage(this.selectedTab.getDefaultPage()));
                n = n == 0 ? array.size() - 1 : --n;
                Page page = (Page)array.at(n);
                this.menuSelection = new String(page.getPageID());
                this.clickedTab = this.selectedTab;
                this.switchTab(true);
            }
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.selectedTab.isExtended()) {
                Array array = this.selectedTab.getPages();
                int n = array.indexOf((Object)this.selectedTab.findPage(this.selectedTab.getDefaultPage()));
                n = n + 1 == array.size() ? 0 : ++n;
                Page page = (Page)array.at(n);
                this.menuSelection = new String(page.getPageID());
                this.clickedTab = this.selectedTab;
                this.switchTab(true);
            }
        } else if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && this.selectedTab.isExtended()) {
            this.clickedTab = this.selectedTab;
            this.showPopUp();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dirtyPage(String string, boolean bl) {
        Page page = this.findPage(string);
        if (page != null) {
            page.dirty(bl);
        }
    }

    boolean existsPage(String string) {
        NTab nTab = null;
        Enumeration enumeration = this.theTabs.elements();
        while (enumeration.hasMoreElements()) {
            nTab = (NTab)enumeration.nextElement();
            if (!nTab.existsPage(string)) continue;
            return true;
        }
        return false;
    }

    Page findPage(String string) {
        NTab nTab = null;
        Page page = null;
        Enumeration enumeration = this.theTabs.elements();
        if (enumeration.hasMoreElements()) {
            nTab = (NTab)enumeration.nextElement();
            page = nTab.findPage(string);
            if (page == null) {
                return null;
            }
        }
        return page;
    }

    boolean existsTab(String string) {
        NTab nTab = null;
        Enumeration enumeration = this.theTabs.elements();
        while (enumeration.hasMoreElements()) {
            nTab = (NTab)enumeration.nextElement();
            if (!string.equals(nTab.getTabID())) continue;
            return true;
        }
        return false;
    }

    private NTab findTab(String string) {
        NTab nTab = null;
        Enumeration enumeration = this.theTabs.elements();
        while (enumeration.hasMoreElements()) {
            nTab = (NTab)enumeration.nextElement();
            if (string.equals(nTab.getTabID())) break;
            nTab = null;
        }
        return nTab;
    }

    public String getCurrentPage() {
        return this.selectedTab.getDefaultPage();
    }

    public void setCurrentPage(String string) throws IllegalArgumentException {
    }

    public void addTab(String string, String string2, boolean bl) throws IllegalArgumentException {
        NTab nTab = null;
        if (this.existsTab(string)) {
            throw new IllegalArgumentException(string + " already exists.");
        }
        nTab = new NTab(string, string2, bl);
        this.theTabs.add((Object)nTab);
        this.selectedTab = (NTab)this.theTabs.front();
        this.selectedTab.select(true);
        this.leftMost = this.selectedTab;
    }

    public void addPage(String string, String string2, String string3) throws IllegalArgumentException {
        NTab nTab = this.findTab(string);
        if (nTab == null) {
            throw new IllegalArgumentException(string + " dosn't exist.");
        }
        nTab.addPage(string2, string3);
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, 39);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 39);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MenuItem menuItem = (MenuItem)itemEvent.getSource();
        this.menuSelection = new String(menuItem.getActionCommand());
        this.switchTab(true);
    }

    private void showPopUp() {
        Rectangle rectangle = null;
        PopupMenu popupMenu = new PopupMenu();
        Array array = this.clickedTab.getPages();
        Enumeration enumeration = array.elements();
        String string = null;
        String string2 = null;
        Page page = null;
        while (enumeration.hasMoreElements()) {
            page = (Page)enumeration.nextElement();
            string2 = page.getPageID();
            string = page.getPageTitle();
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
            checkboxMenuItem.setActionCommand(string2);
            checkboxMenuItem.addItemListener(this);
            if (string2.equals(this.clickedTab.getDefaultPage())) {
                checkboxMenuItem.setState(true);
            }
            popupMenu.add(checkboxMenuItem);
        }
        rectangle = this.clickedTab.getBounds();
        this.add(popupMenu);
        popupMenu.show(this, rectangle.x - 2, rectangle.y + rectangle.height - 2);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getPoint());
        Rectangle rectangle = null;
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.scrollers) {
                    if (this.lScrollButton.contains(point.x, point.y)) {
                        if (!this.lButtonEnabled) break;
                        int n = this.theTabs.indexOf((Object)this.leftMost);
                        if (n < 1) {
                            this.lButtonEnabled = false;
                        } else {
                            this.leftMost = (NTab)this.theTabs.at(n - 1);
                            this.lButtonUp = false;
                        }
                        this.repaint();
                        break;
                    }
                    if (this.rScrollButton.contains(point.x, point.y)) {
                        if (!this.rButtonEnabled) break;
                        int n = this.theTabs.indexOf((Object)this.leftMost);
                        if (n == -1 || n >= this.theTabs.size() - 1) {
                            this.rButtonEnabled = false;
                        } else {
                            this.leftMost = (NTab)this.theTabs.at(n + 1);
                            this.rButtonUp = false;
                        }
                        this.repaint();
                        break;
                    }
                }
                boolean bl = false;
                int n = this.theTabs.size();
                int n2 = this.theTabs.indexOf((Object)this.leftMost);
                while (n2 < n) {
                    this.clickedTab = (NTab)this.theTabs.at(n2);
                    if (this.clickedTab.contains(point.x, point.y)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) break;
                if (this.clickedTab.isExtended()) {
                    if (this.clickedTab.isSelected() || point.x > this.clickedTab.getHotZone()) {
                        this.showPopUp();
                        break;
                    }
                    this.switchTab(false);
                    break;
                }
                if (this.clickedTab.isSelected()) {
                    this.repaint();
                }
                this.switchTab(false);
                break;
            }
            case 502: {
                if (!this.scrollers) break;
                this.lButtonEnabled = this.leftMost != (NTab)this.theTabs.front();
                NTab nTab = (NTab)this.theTabs.back();
                rectangle = nTab.getBounds();
                this.rButtonEnabled = nTab.getShowingZone() >= this.getSize().width - 42;
                this.lButtonUp = true;
                this.rButtonUp = true;
                this.repaint(this.getSize().width - 42, 0, 42, 39);
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    void setMenuSelection(String string) {
        this.menuSelection = string;
    }

    boolean setClickedTab(String string) {
        NTab nTab = null;
        Object var3_3 = null;
        Enumeration enumeration = this.theTabs.elements();
        while (enumeration.hasMoreElements()) {
            nTab = (NTab)enumeration.nextElement();
            if (nTab.findPage(string) == null) continue;
            this.clickedTab = nTab;
            this.menuSelection = string;
            this.switchTab(true);
            return true;
        }
        return false;
    }

    void switchTab(boolean bl) {
        boolean bl2 = true;
        int n = this.theListeners.size();
        Rectangle rectangle = this.clickedTab.getBounds();
        NTabsListener nTabsListener = null;
        NTabsEvent nTabsEvent = new NTabsEvent(this.selectedTab.getDefaultPage());
        int n2 = 0;
        while (n2 < n) {
            nTabsListener = (NTabsListener)this.theListeners.at(n2);
            if (!nTabsListener.loseFocus(nTabsEvent)) {
                bl2 = false;
            }
            ++n2;
        }
        if (bl2) {
            int n3;
            if (bl) {
                this.clickedTab.setDefaultPage(this.menuSelection);
            }
            NTabsEvent nTabsEvent2 = new NTabsEvent(this.clickedTab.getDefaultPage());
            this.selectedTab.select(false);
            this.clickedTab.select(true);
            this.selectedTab = this.clickedTab;
            Graphics graphics = this.getGraphics();
            this.computeTabBounds(graphics);
            if (this.clickedTab.getShowingZone() > this.getSize().width - 42 || this.clickedTab.getTabWidth() == 0) {
                n3 = this.theTabs.size();
                int n4 = 0;
                while (n4 < n3) {
                    this.leftMost = (NTab)this.theTabs.at(n4);
                    this.computeTabBounds(graphics);
                    if (this.clickedTab.getShowingZone() < this.getSize().width - 42) break;
                    ++n4;
                }
            }
            if (this.scrollers) {
                this.lButtonEnabled = this.leftMost != (NTab)this.theTabs.front();
                NTab nTab = (NTab)this.theTabs.back();
                this.rButtonEnabled = nTab.getShowingZone() >= this.getSize().width - 42;
                this.lButtonUp = true;
                this.rButtonUp = true;
            }
            this.paintImmediately(this.getBounds());
            this.requestFocus();
            n3 = 0;
            while (n3 < n) {
                nTabsListener = (NTabsListener)this.theListeners.at(n3);
                nTabsListener.gainFocus(nTabsEvent2);
                ++n3;
            }
        }
    }

    void computeTabBounds(Graphics graphics) {
        NTab nTab = null;
        Point point = new Point(2, 2);
        int n = this.theTabs.size();
        int n2 = 0;
        while (n2 < this.theTabs.indexOf((Object)this.leftMost)) {
            nTab = (NTab)this.theTabs.at(n2);
            nTab.setBounds(-1, -1, 0, 0);
            ++n2;
        }
        n2 = this.theTabs.indexOf((Object)this.leftMost);
        while (n2 < n) {
            nTab = (NTab)this.theTabs.at(n2);
            nTab.computeTabBounds(graphics, point);
            point = nTab.getEndPoint();
            ++n2;
        }
        nTab = (NTab)this.theTabs.back();
        this.scrollers = nTab.getShowingZone() > this.getSize().width - 42 || this.leftMost != (NTab)this.theTabs.front();
    }

    public void paint(Graphics graphics) {
        boolean bl = false;
        int n = this.theTabs.size();
        int n2 = this.getSize().width;
        NTab nTab = null;
        this.computeTabBounds(graphics);
        int n3 = this.leftMost.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n2, n3 + 18);
        int n4 = this.theTabs.indexOf((Object)this.leftMost);
        while (n4 < n) {
            nTab = (NTab)this.theTabs.at(n4);
            if (nTab.isSelected()) {
                bl = true;
            } else {
                nTab.paint(graphics, false);
            }
            ++n4;
        }
        graphics.setColor(Color.white);
        graphics.drawLine(0, 21, n2 - 2, 21);
        graphics.drawLine(0, 21, 0, 38);
        graphics.setColor(Color.gray);
        graphics.drawLine(n2 - 2, 21, n2 - 2, 38);
        graphics.setColor(Color.black);
        graphics.drawLine(n2 - 1, 21, n2 - 1, 38);
        if (bl) {
            this.selectedTab.paint(graphics, this.haveFocus);
        }
        if (this.scrollers) {
            this.drawScrollers(graphics);
        }
    }

    void drawScrollers(Graphics graphics) {
        int n = ((NTab)this.theTabs.back()).getHeight();
        int n2 = this.getSize().width;
        NTab nTab = null;
        int n3 = n2 - 42;
        this.lScrollButton.setBounds(n2 - 30, 0, 15, n);
        this.rScrollButton.setBounds(n2 - 14, 0, 15, n);
        graphics.setColor(this.getBackground());
        graphics.fillRect(n3 + 1, 0, 41, n + 18);
        graphics.setColor(Color.black);
        graphics.drawLine(n3 + 41, n, n3 + 41, n + 18);
        graphics.setColor(Color.gray);
        graphics.drawLine(n3 + 40, n, n3 + 40, n + 18);
        graphics.setColor(Color.white);
        graphics.drawLine(n3 + 1, n, n3 + 40, n);
        graphics.setColor(Color.black);
        graphics.drawLine(n3 + 41, n - 16, n3 + 41, n);
        graphics.drawLine(n3 + 12, n - 1, n3 + 41, n - 1);
        graphics.drawLine(n3 + 11, n - 16, n3 + 11, n - 2);
        graphics.drawLine(n3 + 12, n - 17, n3 + 40, n - 17);
        graphics.drawLine(n3 + 26, n - 16, n3 + 26, n - 1);
        Polygon polygon = new Polygon();
        if (this.rButtonUp) {
            polygon.addPoint(n3 + 32, n - 5);
            polygon.addPoint(n3 + 32, n - 13);
            polygon.addPoint(n3 + 36, n - 9);
        } else {
            polygon.addPoint(n3 + 33, n - 4);
            polygon.addPoint(n3 + 33, n - 12);
            polygon.addPoint(n3 + 37, n - 8);
        }
        if (this.rButtonEnabled) {
            graphics.setColor(Color.black);
            graphics.fillPolygon(polygon);
        } else {
            graphics.setColor(Color.gray);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.white);
            graphics.drawLine(n3 + 33, n - 5, n3 + 35, n - 7);
        }
        Polygon polygon2 = new Polygon();
        if (this.lButtonUp) {
            polygon2.addPoint(n3 + 21, n - 5);
            polygon2.addPoint(n3 + 21, n - 13);
            polygon2.addPoint(n3 + 17, n - 9);
        } else {
            polygon2.addPoint(n3 + 22, n - 4);
            polygon2.addPoint(n3 + 22, n - 12);
            polygon2.addPoint(n3 + 18, n - 8);
        }
        if (this.lButtonEnabled) {
            graphics.setColor(Color.black);
            graphics.fillPolygon(polygon2);
        } else {
            graphics.setColor(Color.gray);
            graphics.fillPolygon(polygon2);
            graphics.setColor(Color.white);
            graphics.drawLine(n3 + 21, n - 7, n3 + 21, n - 11);
        }
        graphics.setColor(Color.gray);
        if (this.rButtonUp) {
            graphics.drawLine(n3 + 40, n - 16, n3 + 40, n - 2);
            graphics.drawLine(n3 + 27, n - 2, n3 + 40, n - 2);
        }
        if (this.lButtonUp) {
            graphics.drawLine(n3 + 12, n - 2, n3 + 25, n - 2);
            graphics.drawLine(n3 + 25, n - 16, n3 + 25, n - 2);
        }
        if ((nTab = (NTab)this.theTabs.back()).getShowingZone() > this.getSize().width - 42) {
            graphics.setColor(Color.gray);
            graphics.drawLine(n3 + 1, n - 2, n3 + 1, n - 2);
            graphics.drawLine(n3 + 2, n - 3, n3 + 2, n - 5);
            graphics.drawLine(n3 + 1, n - 6, n3 + 1, n - 8);
            graphics.drawLine(n3, n - 9, n3, n - 11);
            graphics.drawLine(n3 + 1, n - 12, n3 + 1, n - 14);
            graphics.drawLine(n3 + 2, n - 15, n3 + 2, n - 17);
            nTab = this.selectedTab;
            if (nTab.getShowingZone() > this.getSize().width - 42 && nTab.getBounds().x < this.getSize().width - 42) {
                graphics.drawLine(n3 + 1, n - 18, n3 + 1, n - 20);
                if (nTab.isExtended()) {
                    graphics.drawLine(n3, n - 1, n3, n + 1);
                    graphics.drawLine(n3 + 1, n + 2, n3 + 1, n + 2);
                    graphics.drawLine(n3 + 2, n + 3, n3 + 2, n + 5);
                    graphics.drawLine(n3 + 1, n + 6, n3 + 1, n + 8);
                    graphics.drawLine(n3, n + 9, n3, n + 11);
                    graphics.drawLine(n3 + 1, n + 12, n3 + 1, n + 14);
                    graphics.drawLine(n3 + 2, n + 15, n3 + 2, n + 16);
                }
            }
        }
        if (this.lButtonUp) {
            graphics.setColor(Color.white);
            graphics.drawLine(n3 + 12, n - 16, n3 + 24, n - 16);
            graphics.drawLine(n3 + 12, n - 16, n3 + 12, n - 3);
        } else {
            graphics.setColor(Color.gray);
            graphics.drawLine(n3 + 12, n - 16, n3 + 25, n - 16);
            graphics.drawLine(n3 + 12, n - 16, n3 + 12, n - 2);
        }
        if (this.rButtonUp) {
            graphics.setColor(Color.white);
            graphics.drawLine(n3 + 27, n - 16, n3 + 39, n - 16);
            graphics.drawLine(n3 + 27, n - 16, n3 + 27, n - 3);
        } else {
            graphics.setColor(Color.gray);
            graphics.drawLine(n3 + 27, n - 16, n3 + 40, n - 16);
            graphics.drawLine(n3 + 27, n - 16, n3 + 27, n - 2);
        }
    }

    void showThisPage(String string) {
        boolean bl = false;
        int n = this.theTabs.size();
        NTab nTab = null;
        int n2 = 0;
        while (n2 < n) {
            nTab = (NTab)this.theTabs.at(n2);
            if (nTab.existsPage(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            if (!nTab.isSelected()) {
                this.selectedTab.select(false);
                nTab.select(true);
                if (nTab.getShowingZone() > this.getSize().width - 42) {
                    n2 = 0;
                    while (n2 < n) {
                        this.leftMost = (NTab)this.theTabs.at(n2);
                        Graphics graphics = this.getGraphics();
                        this.computeTabBounds(graphics);
                        if (nTab.getShowingZone() > this.getSize().width - 42) break;
                        ++n2;
                    }
                    if (this.scrollers) {
                        this.lButtonEnabled = this.leftMost != (NTab)this.theTabs.front();
                        NTab nTab2 = (NTab)this.theTabs.back();
                        this.rButtonEnabled = nTab2.getShowingZone() >= this.getSize().width - 42;
                        this.lButtonUp = true;
                        this.rButtonUp = true;
                    }
                }
            }
            nTab.setDefaultPage(string);
            this.repaint();
        }
    }

    Array getTabs() {
        return this.theTabs;
    }

    public NTabs(Color color, Color color2) {
        fgColor = color;
        bgColor = color2;
        this.setBackground(color2);
        this.theTabs = new Array();
        this.theListeners = new Array();
        this.enableEvents(16L);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public NTabs() {
        this(UIManager.getColor("Panel.foreground"), UIManager.getColor("Panel.background"));
    }

    protected class NTabsAccessible
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected NTabsAccessible() {
            super(NTabs.this);
        }
    }
}

