/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTreeNode;
import com.novell.application.console.widgets.NTreeRenderer;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NTree
extends JTree {
    private boolean checkBoxMode;

    private void initNode(TreeNode treeNode) {
        if (treeNode instanceof NTreeNode) {
            ((NTreeNode)treeNode).setTree(this);
            int n = treeNode.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                this.initNode(treeNode.getChildAt(n2));
                ++n2;
            }
        }
    }

    public void toggleCheckBoxMode() {
        this.checkBoxMode = !this.checkBoxMode;
        this.repaint();
    }

    public void setCheckBoxMode(boolean bl) {
        this.checkBoxMode = bl;
        this.repaint();
    }

    public boolean isCheckBoxModeOn() {
        return this.checkBoxMode;
    }

    private void init() {
        this.setFont(new Font("SansSerif", 0, 12));
        this.setCellRenderer(new NTreeRenderer(this));
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.checkBoxMode && mouseEvent.getID() == 501) {
            Object object;
            int n = this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            Rectangle rectangle = this.getRowBounds(n);
            int n2 = mouseEvent.getX() - rectangle.x;
            if (n2 >= 0 && n2 <= 10 && (object = this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getLastPathComponent()) instanceof NTreeNode) {
                NTreeNode nTreeNode = (NTreeNode)object;
                nTreeNode.toggleCheck();
                this.repaint();
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        NTreeNode nTreeNode;
        if (this.checkBoxMode && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 32 && (nTreeNode = NTree.getNodeFromPath(this.getSelectionPath())) != null) {
            nTreeNode.toggleCheck();
        }
        super.processKeyEvent(keyEvent);
    }

    public static NTreeNode getNodeFromPath(TreePath treePath) {
        NTreeNode nTreeNode = null;
        Object object = null;
        if (treePath != null && ((object = treePath.getLastPathComponent()) != null || object instanceof NTreeNode) && object instanceof NTreeNode) {
            nTreeNode = (NTreeNode)object;
        }
        return nTreeNode;
    }

    public NTree() {
        this.init();
    }

    public NTree(Hashtable hashtable) {
        super(hashtable);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof NTreeNode)) continue;
            this.initNode((TreeNode)v);
        }
        this.init();
    }

    public NTree(Object[] objectArray) {
        super(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof NTreeNode) {
                this.initNode((TreeNode)objectArray[n]);
            }
            ++n;
        }
        this.init();
    }

    public NTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    public NTree(TreeNode treeNode) {
        super(treeNode);
        this.initNode(treeNode);
        this.init();
    }

    public NTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.initNode(treeNode);
        this.init();
    }

    public NTree(Vector vector) {
        super(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof NTreeNode)) continue;
            this.initNode((TreeNode)e);
        }
        this.init();
    }
}

