/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.NTree;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class NTreeNode
extends DefaultMutableTreeNode {
    private boolean checked;
    private boolean partiallyChecked;
    private ImageIcon icon;
    private NTree tree;
    private Object data;

    public void add(NTreeNode nTreeNode) {
        super.add(nTreeNode);
        nTreeNode.setTree(this.tree);
        this.updateCheckState();
        TreeNode treeNode = this.getParent();
        while (treeNode != null && treeNode instanceof NTreeNode) {
            ((NTreeNode)treeNode).updateCheckState();
            treeNode = treeNode.getParent();
        }
    }

    void updateCheckState() {
        this.checked = this.areAllChildrenChecked(this);
        if (!this.checked) {
            this.partiallyChecked = this.areSomeChildrenChecked(this);
        }
    }

    public ImageIcon getImageIcon() {
        return this.icon;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Image getImage() {
        if (this.icon != null) {
            return this.icon.getImage();
        }
        return null;
    }

    void setTree(NTree nTree) {
        this.tree = nTree;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isPartiallyChecked() {
        return this.partiallyChecked;
    }

    public void setChecked(boolean bl) {
        this.setCheckedImpl(bl);
        NTreeNode nTreeNode = this;
        TreeNode treeNode = nTreeNode.getParent();
        while (treeNode != null) {
            if (!(treeNode instanceof NTreeNode)) continue;
            NTreeNode nTreeNode2 = (NTreeNode)treeNode;
            nTreeNode2.checked = this.areAllChildrenChecked(nTreeNode2);
            if (!nTreeNode2.checked) {
                nTreeNode2.partiallyChecked = this.areSomeChildrenChecked(nTreeNode2);
            }
            treeNode = treeNode.getParent();
        }
    }

    private void setCheckedImpl(boolean bl) {
        this.checked = bl;
        this.partiallyChecked = false;
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode = this.getChildAt(n2);
            if (treeNode instanceof NTreeNode) {
                NTreeNode nTreeNode = (NTreeNode)treeNode;
                nTreeNode.setCheckedImpl(bl);
            }
            ++n2;
        }
    }

    public void toggleCheck() {
        this.setChecked(!this.checked);
        this.tree.repaint();
    }

    private boolean areAllChildrenChecked(NTreeNode nTreeNode) {
        int n = nTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            NTreeNode nTreeNode2;
            TreeNode treeNode = nTreeNode.getChildAt(n2);
            if (treeNode instanceof NTreeNode && !this.areAllChildrenCheckedImpl(nTreeNode2 = (NTreeNode)treeNode)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean areAllChildrenCheckedImpl(NTreeNode nTreeNode) {
        if (!nTreeNode.isChecked()) {
            return false;
        }
        int n = nTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            NTreeNode nTreeNode2;
            TreeNode treeNode = nTreeNode.getChildAt(n2);
            if (treeNode instanceof NTreeNode && !this.areAllChildrenCheckedImpl(nTreeNode2 = (NTreeNode)treeNode)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean areSomeChildrenChecked(NTreeNode nTreeNode) {
        int n = nTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            NTreeNode nTreeNode2;
            TreeNode treeNode = nTreeNode.getChildAt(n2);
            if (treeNode instanceof NTreeNode && this.areSomeChildrenCheckedImpl(nTreeNode2 = (NTreeNode)treeNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean areSomeChildrenCheckedImpl(NTreeNode nTreeNode) {
        if (nTreeNode.isChecked()) {
            return true;
        }
        int n = nTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            NTreeNode nTreeNode2;
            TreeNode treeNode = nTreeNode.getChildAt(n2);
            if (treeNode instanceof NTreeNode && this.areSomeChildrenCheckedImpl(nTreeNode2 = (NTreeNode)treeNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public NTreeNode(String string) {
        super(string, true);
    }

    public NTreeNode(String string, ImageIcon imageIcon) {
        super(string, true);
        this.icon = imageIcon;
    }

    public NTreeNode(String string, ImageIcon imageIcon, Object object) {
        super(string, true);
        this.icon = imageIcon;
        this.data = object;
    }
}

