/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.widgets;
import com.objectspace.jgl.adapters.VectorArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;

public class NVerticalFlowLayout
implements LayoutManager2,
Serializable {
    public static final String CENTER = "Center";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    private VectorArray components;
    private boolean uniformWidths;
    private int vGap;
    private int externalPadLeft;
    private int externalPadRight;
    private int externalPadTop;
    private int externalPadBottom;
    private int internalPadX;
    private int internalPadY;
    private int widestWidth;
    private Dimension preferredSize;
    private Insets insets;
    private boolean dirty = false;

    public void addLayoutComponent(String string, Component component) {
        NVerticalFlowLayout nVerticalFlowLayout;
        if (component == null) {
            throw new IllegalArgumentException("Cannot add component: component is null.");
        }
        if (string == null) {
            string = CENTER;
        }
        if (string.equals(CENTER) || string.equals(LEFT) || string.equals(RIGHT)) {
            nVerticalFlowLayout = this;
            if (nVerticalFlowLayout == null) {
                throw null;
            }
        } else {
            throw new IllegalArgumentException("Cannot add component: constraint is invalid.");
        }
        AlignedComponent alignedComponent = nVerticalFlowLayout.new AlignedComponent(component, string);
        this.components.add((Object)alignedComponent);
        this.dirty = true;
    }

    public void removeLayoutComponent(Component component) {
        if (component != null) {
            Enumeration enumeration = this.components.elements();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                    Component component2 = alignedComponent.getComponent();
                    if (component != component2) continue;
                    this.components.remove((Object)alignedComponent);
                    this.dirty = true;
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot remove component: component is null.");
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.insets == null || !this.insets.equals(container.getInsets())) {
            this.dirty = true;
        }
        if (this.preferredSize == null || this.dirty) {
            Enumeration enumeration;
            int n = 0;
            this.widestWidth = 0;
            this.preferredSize = null;
            int n2 = 0;
            int n3 = 0;
            this.insets = container.getInsets();
            if (this.insets != null) {
                n2 = this.insets.left + this.insets.right;
                n3 = this.insets.bottom + this.insets.top;
            }
            if ((enumeration = this.components.elements()) != null) {
                while (enumeration.hasMoreElements()) {
                    AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                    Dimension dimension = alignedComponent.getComponent().getPreferredSize();
                    int n4 = dimension.width;
                    if (n4 > this.widestWidth) {
                        this.widestWidth = n4;
                    }
                    n += dimension.height + this.internalPadY * 2 + this.vGap;
                }
                this.preferredSize = new Dimension(this.widestWidth + this.externalPadLeft + this.externalPadRight + this.internalPadX * 2, n + this.externalPadTop + this.externalPadBottom);
                this.preferredSize.width += n2;
                this.preferredSize.height += n3;
            } else {
                this.preferredSize = new Dimension(n2, n3);
            }
            this.dirty = false;
        }
        return this.preferredSize;
    }

    public void layoutContainer(Container container) {
        Enumeration enumeration;
        Insets insets;
        int n = this.externalPadTop;
        int n2 = 0;
        if (this.dirty) {
            this.preferredLayoutSize(container);
        }
        if ((insets = container.getInsets()) != null) {
            n += insets.top;
        }
        if ((enumeration = this.components.elements()) != null) {
            while (enumeration.hasMoreElements()) {
                AlignedComponent alignedComponent = (AlignedComponent)enumeration.nextElement();
                Component component = alignedComponent.getComponent();
                String string = alignedComponent.getAlignment();
                int n3 = component.getPreferredSize().height + this.internalPadY * 2;
                if (this.uniformWidths) {
                    n2 = this.widestWidth + this.internalPadX * 2;
                    component.setLocation(this.externalPadLeft, n);
                } else {
                    n2 = component.getPreferredSize().width;
                    if (string.equals(LEFT)) {
                        component.setLocation(this.externalPadLeft, n);
                    } else if (string.equals(RIGHT)) {
                        if (insets != null) {
                            component.setLocation(insets.left + this.externalPadLeft + this.widestWidth - n2, n);
                        } else {
                            component.setLocation(this.externalPadLeft + this.widestWidth - n2, n);
                        }
                    } else {
                        component.setLocation(this.externalPadLeft + this.widestWidth / 2 - n2 / 2, n);
                    }
                }
                component.setSize(n2, n3);
                n += n3 + this.vGap;
            }
        }
    }

    public boolean areWidthsUniform() {
        return this.uniformWidths;
    }

    public int getVerticalGap() {
        return this.vGap;
    }

    public int getExternalPadLeft() {
        return this.externalPadLeft;
    }

    public int getExternalPadRight() {
        return this.externalPadRight;
    }

    public int getExternalPadTop() {
        return this.externalPadTop;
    }

    public int getExternalPadBottom() {
        return this.externalPadBottom;
    }

    public int getInternalPadX() {
        return this.internalPadX;
    }

    public int getInternalPadY() {
        return this.internalPadY;
    }

    public void setUniformWidths(boolean bl) {
        this.uniformWidths = bl;
    }

    public void setVerticalGap(int n) {
        this.vGap = n;
    }

    public void setExternalPadLeft(int n) {
        this.externalPadLeft = n;
    }

    public void setExternalPadRight(int n) {
        this.externalPadRight = n;
    }

    public void setExternalPadTop(int n) {
        this.externalPadTop = n;
    }

    public void setExternalPadBottom(int n) {
        this.externalPadBottom = n;
    }

    public void setInternalPadX(int n) {
        this.internalPadX = n;
    }

    public void setInternalPadY(int n) {
        this.internalPadY = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        this.dirty = true;
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        this.addLayoutComponent((String)object, component);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public NVerticalFlowLayout() {
        this.uniformWidths = true;
        this.vGap = widgets.getInt("ButtonXGapKey");
        this.externalPadLeft = widgets.getInt("ButtonLeftExternalPadKey");
        this.externalPadRight = widgets.getInt("ButtonRightExternalPadKey");
        this.externalPadTop = widgets.getInt("ButtonTopExternalPadKey");
        this.externalPadBottom = widgets.getInt("ButtonBottomExternalPadKey");
        this.internalPadX = widgets.getInt("ButtonXInternalPadKey");
        this.internalPadY = widgets.getInt("ButtonYInternalPadKey");
        this.components = new VectorArray();
    }

    public NVerticalFlowLayout(boolean bl, int n) {
        this.uniformWidths = bl;
        this.vGap = n;
        this.components = new VectorArray();
    }

    private class AlignedComponent {
        Component comp;
        String alignment;

        public Component getComponent() {
            return this.comp;
        }

        public String getAlignment() {
            return this.alignment;
        }

        public AlignedComponent(Component component, String string) {
            this.comp = component;
            this.alignment = string;
        }
    }
}

