/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.testing.C1Hooks;
import com.novell.application.console.widgets.NDialog;
import com.novell.application.console.widgets.NWizardPage;
import com.novell.application.console.widgets.widgets;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class NWizard
extends NDialog
implements ActionListener {
    public static final int ID_OK = 0;
    public static final int ID_CANCEL = 1;
    public static final int NEXT = 0;
    public static final int BACK = 1;
    protected JPanel buttonPanel;
    protected JPanel sunkenPanel;
    protected JPanel bottomPanel;
    protected JPanel pagePanel;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton cancelButton;
    protected JButton finishButton;
    protected JButton helpButton;
    protected int rval;
    protected CardLayout pagePanelLayout;
    protected int totalPages;
    protected int currentPage;
    protected Vector pageList;
    protected Stack visitOrder;
    protected JFrame parentFrame;
    protected Image wizardImage;
    protected Dimension pageSize = new Dimension(350, 300);
    protected boolean paintCalled = false;

    public Dimension getWizardPageSize() {
        return this.pageSize;
    }

    public void setWizardPageSize(Dimension dimension) {
        this.pageSize = dimension;
    }

    public void addPage(NWizardPage nWizardPage) {
        ++this.totalPages;
        this.pagePanel.add((Component)nWizardPage, Integer.toString(this.totalPages));
        this.pageList.addElement(nWizardPage);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    public int launch() {
        this.show();
        return this.rval;
    }

    public void show() {
        this.pack();
        ((NWizardPage)this.pageList.elementAt(this.currentPage - 1)).onActivate(0);
        super.show();
    }

    protected void gotoPage(int n, boolean bl) {
        if (bl && n != this.currentPage) {
            this.visitOrder.push(new Integer(this.currentPage));
        }
        if (n < this.currentPage && n > 0) {
            try {
                Integer n2 = (Integer)this.visitOrder.pop();
                while (n2 >= n) {
                    n2 = (Integer)this.visitOrder.pop();
                }
                this.visitOrder.push(n2);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.setupButtons(n);
        int n3 = ((NWizardPage)this.pageList.elementAt(n - 1)).onActivate(0);
        if (n3 == -1) {
            this.currentPage = n;
            this.pagePanelLayout.show(this.pagePanel, Integer.toString(this.currentPage));
        } else {
            this.currentPage = n3;
            this.gotoPage(this.currentPage, false);
        }
    }

    protected void setupButtons(int n) {
        if (n == 1) {
            this.nextButton.requestFocus();
            this.setBackButton(false);
            this.setNextButton(true);
            this.setFinishButton(false);
        } else if (n == this.totalPages) {
            this.setBackButton(true);
            this.setNextButton(false);
            this.setFinishButton(true);
        } else {
            this.setBackButton(true);
            this.setNextButton(true);
            this.setFinishButton(false);
        }
    }

    public void setBackButton(boolean bl) {
        this.backButton.setEnabled(bl);
    }

    public void setNextButton(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(boolean bl) {
        this.finishButton.setEnabled(bl);
    }

    public Frame getWizardParent() {
        return this.parentFrame;
    }

    protected void backButtonPressed() {
        Integer n = (Integer)this.visitOrder.pop();
        this.currentPage = n;
        this.setupButtons(this.currentPage);
        this.pagePanelLayout.show(this.pagePanel, n.toString());
        ((NWizardPage)this.pageList.elementAt(this.currentPage - 1)).onActivate(1);
    }

    protected void nextButtonPressed() {
        int n = ((NWizardPage)this.pageList.elementAt(this.currentPage - 1)).nextPage();
        if (n > this.totalPages || n < -1) {
            System.out.println("Invalid next page returned by page: " + this.currentPage);
            return;
        }
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                this.gotoPage(this.currentPage + 1, true);
                break;
            }
            default: {
                this.gotoPage(n, true);
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.backButton) {
            this.backButtonPressed();
        } else if (actionEvent.getSource() == this.nextButton) {
            this.nextButtonPressed();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.rval = 1;
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.finishButton) {
            boolean bl = ((NWizardPage)this.pageList.elementAt(this.currentPage - 1)).finish();
            if (bl) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.helpButton) {
            ((NWizardPage)this.pageList.elementAt(this.currentPage - 1)).help();
        }
    }

    protected void help() {
        this.helpButton.doClick();
    }

    public void paint(Graphics graphics) {
        if (!this.paintCalled) {
            this.nextButton.requestFocus();
            this.paintCalled = true;
        }
        super.paint(graphics);
    }

    public NWizard(JFrame jFrame, String string, Image image, boolean bl) {
        super((Component)jFrame, string, bl);
        this.wizardImage = image;
        this.getContentPane().setLayout(new BorderLayout(15, 10));
        this.totalPages = 0;
        this.currentPage = 1;
        this.parentFrame = jFrame;
        this.rval = 0;
        this.pageList = new Vector(15, 5);
        this.visitOrder = new Stack();
        this.backButton = NConeFactory.novellJButton((JButton)new JButton(), (String)Loc.removeHotChar((String)widgets.getString("backKey")), (String)"This is a Button");
        Loc.setText((AbstractButton)this.backButton, (String)widgets.getString("backKey"));
        this.nextButton = NConeFactory.novellJButton((JButton)new JButton(), (String)Loc.removeHotChar((String)widgets.getString("nextKey")), (String)"This is a Button");
        Loc.setText((AbstractButton)this.nextButton, (String)widgets.getString("nextKey"));
        this.cancelButton = NConeFactory.novellJButton((JButton)new JButton(widgets.getString("cancelKey")), (String)widgets.getString("cancelKey"), (String)"This is a Button");
        this.finishButton = NConeFactory.novellJButton((JButton)new JButton(Loc.removeHotChar((String)widgets.getString("finishKey"))), (String)Loc.removeHotChar((String)widgets.getString("finishKey")), (String)"This is a Button");
        this.helpButton = NConeFactory.novellJButton((JButton)new JButton(), (String)Loc.removeHotChar((String)widgets.getString("helpKey")), (String)"This is a Button");
        Loc.setText((AbstractButton)this.helpButton, (String)widgets.getString("helpKey"));
        this.buttonPanel = new JPanel(new FlowLayout(2, 1, 0));
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(this.nextButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.finishButton);
        this.buttonPanel.add(this.helpButton);
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.pagePanelLayout = new CardLayout();
        this.pagePanel = new JPanel(this.pagePanelLayout);
        if (this.wizardImage != null) {
            JLabel jLabel = new JLabel(new ImageIcon(this.wizardImage));
            jLabel.setBorder(new BevelBorder(1));
            jLabel.setVerticalAlignment(1);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            this.getContentPane().add("West", jPanel);
        }
        this.bottomPanel = new JPanel(new BorderLayout(0, 5));
        NWizard nWizard = this;
        if (nWizard == null) {
            throw null;
        }
        this.sunkenPanel = new JPanel(nWizard){
            private final /* synthetic */ NWizard this$0;

            public Dimension getPreferredSize() {
                return new Dimension(0, 4);
            }
            {
                this.this$0 = nWizard;
                this.constructor$0(nWizard);
            }

            private final void constructor$0(NWizard nWizard) {
            }
        };
        this.sunkenPanel.setBorder(new BevelBorder(1));
        this.bottomPanel.add("North", this.sunkenPanel);
        this.bottomPanel.add("South", this.buttonPanel);
        this.getContentPane().add("Center", this.pagePanel);
        this.getContentPane().add("South", this.bottomPanel);
        this.setBackButton(false);
        this.setFinishButton(false);
        this.setName("Wizzard");
        C1Hooks.registerWindow((Window)this);
        this.backButton.setName("Back");
        this.nextButton.setName("Next");
        this.cancelButton.setName("Cancel");
        this.finishButton.setName("Finish");
        this.helpButton.setName("Help");
        this.pack();
    }
}

