/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.widgets;

import com.novell.application.console.widgets.Dw;
import com.novell.application.console.widgets.widgets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class NWrapLabel
extends JComponent
implements Accessible {
    private String m_text = "";
    private int m_totalChars = 0;
    private int m_maxPixels = 0;
    private int m_maxWidestCharsPerLine = 0;
    private int m_margin = 0;
    private Insets m_insets = new Insets(0, 0, 0, 0);
    private Image m_textImage = null;
    private Dimension m_textImageSize = null;
    private int m_preferredRowCount = -1;
    private int m_paintedRowCount = -1;
    private Font m_font;
    private FontMetrics m_metrics;
    private Color m_foreground = null;
    private Color m_background = null;
    private boolean m_bNoWrap = true;
    private boolean m_bRevalidateRequested = false;
    private boolean m_bRepackPerformed = false;
    private boolean m_bGetPrefSizeCalled = false;

    private void init(String string, boolean bl) {
        if (string != null) {
            this.m_totalChars = string.length();
            this.m_text = string;
        }
        this.m_bNoWrap = bl;
        this.m_maxPixels = 0;
        this.m_maxWidestCharsPerLine = widgets.getInt("MsgBoxMaxWidestCharsPerLineKey");
        this.m_font = new Font("SansSerif", 0, 12);
        super.setFont(this.m_font);
        this.m_metrics = ((Component)this).getFontMetrics(this.m_font);
        this.m_background = new JLabel().getBackground();
        this.m_foreground = Color.black;
        this.setName("WrapLabel");
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            NWrapLabel nWrapLabel = this;
            if (nWrapLabel == null) {
                throw null;
            }
            this.accessibleContext = nWrapLabel.new NWrapLabelAccessible();
        }
        return this.accessibleContext;
    }

    public String getText() {
        return this.m_text;
    }

    public void setForeground(Color color) {
        if (color != null) {
            this.resetImage();
            this.m_foreground = color;
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.resetImage();
            this.m_background = color;
            this.repaint();
        }
    }

    public void setBorder(Border border, int n) {
        if (n > 0) {
            this.m_margin = n;
        }
        this.resetImage();
        super.setBorder(border);
        this.reValidate("setBorder");
    }

    public void setText(String string) {
        if (string != null) {
            this.resetImage();
            this.m_text = string;
            this.m_totalChars = this.m_text.length();
            this.reValidate("setText");
        }
    }

    public void setMaxLineLength(int n) {
        if (n > 0) {
            this.resetImage();
            this.m_maxPixels = 0;
            this.m_maxWidestCharsPerLine = n;
            this.reValidate("setWidthInChars");
        }
    }

    public void setMaxWidth(int n) {
        if (n > 0) {
            this.resetImage();
            this.m_bNoWrap = false;
            this.m_maxPixels = n;
            this.reValidate("setWidthInPixels");
        }
    }

    public void setNoWrap(boolean bl) {
        this.resetImage();
        this.m_bNoWrap = bl;
        this.m_maxPixels = 0;
        this.reValidate("setNoWrap");
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetImage();
        this.m_font = font;
        this.m_metrics = ((Component)this).getFontMetrics(this.m_font);
        this.reValidate("setFont");
    }

    public void setMargin(int n) {
        if (n > 0) {
            this.resetImage();
            this.m_margin = n;
            this.reValidate("setMargin");
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Dw.out("NWrapLabel.setBounds: size = " + n3 + "," + n4);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        this.getInsetsFromBorder();
        if (this.m_bNoWrap) {
            dimension.width = this.m_metrics.stringWidth(this.m_text) + this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
            dimension.height = this.m_metrics.getHeight() + this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom;
        } else {
            Dimension dimension2;
            dimension.width = this.m_maxPixels > 0 ? this.m_maxPixels + this.m_margin * 2 + this.m_insets.left + this.m_insets.right : ((dimension2 = this.getSize()) != null && dimension2.width > 0 ? dimension2.width : this.getWidestLine() + this.m_margin * 2 + this.m_insets.left + this.m_insets.right);
            this.m_preferredRowCount = this.processRows(null);
            dimension.height = this.m_preferredRowCount * this.m_metrics.getHeight() + this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom;
        }
        this.m_bGetPrefSizeCalled = true;
        Dw.out("NWrapLabel::getPreferredSize:  preferred size = " + dimension);
        return dimension;
    }

    public void paint(Graphics graphics) {
        Dw.out("\n>>>NWrapLabel.paint()...");
        super.paint(graphics);
        if (this.m_bNoWrap) {
            Dw.out(">>> Painting NWrapLabel... freeFlow enabled.");
            this.m_paintedRowCount = this.processRows(graphics);
            Dw.out("    m_paintedRowCount = " + this.m_paintedRowCount);
        } else if (!this.m_bGetPrefSizeCalled) {
            Dw.out(">>> Painting NWrapLabel blindly... preferred size never requested!");
            this.m_paintedRowCount = this.processRows(graphics);
            Dw.out("    m_paintedRowCount = " + this.m_paintedRowCount);
        } else if (this.m_bRevalidateRequested) {
            Dw.out(">>> Painting NWrapLabel after one revalidation...");
            this.m_paintedRowCount = this.processRows(graphics);
            Dw.out("    m_preferredRowCount = " + this.m_preferredRowCount);
            Dw.out("    m_paintedRowCount = " + this.m_paintedRowCount);
            this.m_bRevalidateRequested = false;
        } else {
            boolean bl = this.m_paintedRowCount != -1;
            int n = this.processRows(null);
            if (this.m_maxPixels > 0 || n == this.m_preferredRowCount || bl && n == this.m_paintedRowCount) {
                if (this.m_maxPixels > 0) {
                    Dw.out(">>> Painting NWrapLabel width contrained...");
                } else {
                    Dw.out(">>> Painting NWrapLabel perfectly...");
                }
                Dw.out("    neededRowCount = " + n);
                Dw.out("    m_preferredRowCount = " + this.m_preferredRowCount);
                this.m_paintedRowCount = this.processRows(graphics);
                Dw.out("    m_paintedRowCount = " + this.m_paintedRowCount);
            } else {
                Dw.out(">>> Requesting revalidation of NWrapLabel prior to paint...");
                Dw.out("    neededRowCount = " + n);
                Dw.out("    m_preferredRowCount = " + this.m_preferredRowCount);
                Dw.out("    m_paintedRowCount = " + this.m_paintedRowCount);
                this.myRevalidate();
                this.m_bRevalidateRequested = true;
                int n2 = this.m_paintedRowCount;
                this.processRows(graphics);
                this.m_paintedRowCount = n2;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void getInsetsFromBorder() {
        Border border = this.getBorder();
        this.m_insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getWidestLine() {
        String string = this.m_text;
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_totalChars == 0) {
            return 0;
        }
        if (this.m_bNoWrap) {
            return this.m_metrics.stringWidth(this.m_text);
        }
        if (this.m_maxPixels == 0) {
            int n5 = 0;
            while (n5 < this.m_maxWidestCharsPerLine) {
                string2 = string2 + widgets.getString("WidestCharacterKey");
                ++n5;
            }
            n4 = this.m_metrics.stringWidth(string2);
        } else {
            n4 = this.m_maxPixels;
            n4 -= this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
        }
        n = this.getNextNewlineChar(n2);
        if (n >= 0) {
            do {
                n3 = Math.max(this.getPixelLength(string, n2, n), n3);
                n2 = n + 1;
                if (n2 > this.m_totalChars - 1) return Math.min(n3, n4);
            } while ((n = this.getNextNewlineChar(n2)) >= 0);
            n3 = Math.max(this.getPixelLength(string, n2, this.m_totalChars), n3);
            return Math.min(n3, n4);
        } else {
            n3 = Math.max(this.m_metrics.stringWidth(this.m_text), n3);
        }
        return Math.min(n3, n4);
    }

    private int getNextNewlineChar(int n) {
        return this.m_text.indexOf(10, n);
    }

    private int getPixelLength(String string, int n, int n2) {
        return this.m_metrics.stringWidth(string.substring(n, n2));
    }

    private synchronized int processRows(Graphics graphics) {
        boolean bl;
        String string = "";
        Dimension dimension = this.getSize();
        String string2 = "";
        int[] nArray = new int[1];
        int n = this.m_metrics.getMaxDescent();
        int n2 = this.m_metrics.getHeight();
        int n3 = 0;
        int n4 = 0;
        Graphics graphics2 = null;
        this.getInsetsFromBorder();
        boolean bl2 = bl = graphics != null && (this.m_textImage == null || this.m_textImageSize == null || this.m_textImageSize.width == 0 || this.m_textImageSize.height == 0 || this.m_textImageSize.width != dimension.width || this.m_textImageSize.height != dimension.height);
        if (dimension.width == 0 || dimension.height == 0) {
            if (this.m_maxPixels > 0) {
                dimension.width = this.m_maxPixels;
                dimension.width -= this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
            } else {
                dimension.width = this.getWidestLine();
            }
            n3 = 0;
            while (n3 < this.m_totalChars) {
                ++n4;
                string2 = this.getRowText(dimension.width, n3, nArray, graphics);
                if (string2 == null) break;
                n3 = nArray[0];
            }
            dimension.height = n4 * n2;
            dimension.width += this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
            dimension.height += this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom;
            if (graphics != null) {
                this.setSize(dimension);
            } else {
                return n4;
            }
        }
        if (this.m_maxPixels > 0 && dimension.width > this.m_maxPixels) {
            dimension.width = this.m_maxPixels;
        }
        dimension.width -= this.m_margin * 2 + this.m_insets.left + this.m_insets.right;
        dimension.height -= this.m_margin * 2 + this.m_insets.top + this.m_insets.bottom;
        if (bl) {
            this.m_textImage = this.createImage(dimension.width, dimension.height);
            graphics2 = this.m_textImage.getGraphics();
            graphics2.setColor(this.m_background);
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            graphics2.setFont(this.m_font);
            graphics2.setColor(this.m_foreground);
        }
        int n5 = 0;
        n3 = 0;
        while (n3 < this.m_totalChars) {
            ++n4;
            string2 = this.getRowText(dimension.width, n3, nArray, graphics);
            if (string2 == null) break;
            if (bl) {
                graphics2.drawString(string2, 0, (n5 += n2) - n);
            }
            n3 = nArray[0];
        }
        if (bl) {
            graphics2.dispose();
        }
        if (graphics != null) {
            graphics.drawImage(this.m_textImage, this.m_insets.left + this.m_margin, this.m_insets.top + this.m_margin, this);
            this.m_textImageSize = this.getSize();
        }
        return n4;
    }

    private String getRowText(int n, int n2, int[] nArray, Graphics graphics) {
        boolean bl = false;
        String string = null;
        String string2 = "";
        char c = '\u0000';
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        if (this.m_text.length() == 0) {
            return "";
        }
        n5 = n2;
        while (n5 < this.m_totalChars) {
            c = this.m_text.charAt(n5);
            switch (c) {
                case '\t': 
                case ' ': {
                    n4 = n5;
                    break;
                }
                case '\n': {
                    n4 = n5;
                    bl = true;
                    break;
                }
                default: {
                    string2 = this.m_text.substring(n2, n5 + 1);
                    if (this.m_metrics.stringWidth(string2) > n) {
                        bl = true;
                        break;
                    }
                    if (!this.isConnector(c)) break;
                    n3 = n5;
                    break;
                }
            }
            if (bl) {
                if (" \t\n".indexOf(c) != -1) {
                    nArray[0] = n5 + 1;
                    --n5;
                } else if (n3 > n4) {
                    nArray[0] = n3 + 1;
                    n5 = n3;
                } else if (n4 > 0) {
                    nArray[0] = n4 + 1;
                    n5 = n4;
                } else {
                    nArray[0] = n5--;
                }
                if (n5 < this.m_totalChars) {
                    string = this.m_text.substring(n2, n5 + 1);
                }
                return string;
            }
            ++n5;
        }
        nArray[0] = n5 + 1;
        if (n5 - 1 < this.m_totalChars) {
            string = this.m_text.substring(n2, n5);
        }
        return string;
    }

    private boolean isConnector(char c) {
        String string = widgets.getString("WordConnectorDelimeterKey");
        return string.indexOf(c) > 0;
    }

    private void reValidate(String string) {
        Dw.outncr("NWrapLabel.reValidate(" + string + "):  ");
        if (this.m_paintedRowCount != -1) {
            Dw.out("myRevalidate(" + this.m_paintedRowCount + ")...");
            this.setSize(0, 0);
            this.myRevalidate();
        } else {
            Dw.out("revalidate()...");
            this.revalidate();
        }
    }

    private void myRevalidate() {
        Dw.out(">>> myRevalidation of NWrapLabel...");
        this.m_bRepackPerformed = false;
        this.invalidate();
        Container container = this;
        while (container.getParent() != null) {
            if ((container = container.getParent()) instanceof Window) break;
        }
        if (container instanceof Window) {
            ((Window)container).pack();
            this.m_bRepackPerformed = true;
        }
    }

    private void resetImage() {
        if (this.m_textImage != null) {
            this.m_textImage.flush();
        }
        this.m_textImage = null;
    }

    public void setFreeFlow(boolean bl) {
        this.setNoWrap(bl);
    }

    public void setWidthInChars(int n) {
        this.setMaxLineLength(n);
    }

    public void setWidthInPixels(int n) {
        this.setMaxWidth(n);
    }

    public NWrapLabel(String string) {
        this.init(string, false);
    }

    public NWrapLabel(String string, boolean bl) {
        this.init(string, bl);
    }

    protected class NWrapLabelAccessible
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected NWrapLabelAccessible() {
            super(NWrapLabel.this);
        }
    }
}

