/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import java.util.Vector;

public class FilterResultModifier
extends ResultModifier {
    public static final String OR = new String("|");
    public static final String AND = new String("&");
    public static final String EQUAL = new String("=");
    public static final String NOT_EQUAL = new String("!");
    public static final String GREATER_OR_EQUAL = new String(">=");
    public static final String LESS_OR_EQUAL = new String("<=");
    public static final String APPROX = "~=";
    public static final String PRESENT = "=*";
    public static final String NOT_PRESENT = "!*";
    private Vector filters = new Vector();

    public void addFilter(Filter filter) {
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public Filter[] getFRMFilters() {
        Filter[] filterArray = new Filter[this.filters.size()];
        filterArray = this.filters.toArray(filterArray);
        return filterArray;
    }

    public Filter getFilter() {
        if (this.filters.size() == 0) {
            return null;
        }
        return (Filter)this.filters.firstElement();
    }

    public String getFilterString() {
        Filter filter = (Filter)this.filters.firstElement();
        StringBuffer stringBuffer = new StringBuffer();
        Filter.FilterItemGroupPair[] filterItemGroupPairArray = filter.getFilterItemGroupPairs();
        if (filterItemGroupPairArray.length > 1) {
            stringBuffer.append("(");
            stringBuffer.append(filterItemGroupPairArray[0].getLogicalFilter());
        }
        int n = 0;
        while (n < filterItemGroupPairArray.length) {
            FilterItemGroup filterItemGroup = filterItemGroupPairArray[n].getFilterItemGroup();
            FilterItemGroup.FilterItem[] filterItemArray = filterItemGroup.getFilterItems();
            if (filterItemArray[0].getLogicalFilter() != null) {
                stringBuffer.append("(");
                stringBuffer.append(filterItemArray[0].getLogicalFilter());
            }
            int n2 = 0;
            while (n2 < filterItemArray.length) {
                String string = filterItemArray[n2].getCompareFilter();
                stringBuffer.append("(");
                if (string.equals(NOT_EQUAL)) {
                    stringBuffer.append(string);
                    stringBuffer.append("(");
                    stringBuffer.append(filterItemArray[n2].getAttributeName());
                    stringBuffer.append(EQUAL);
                    stringBuffer.append(filterItemArray[n2].getAttributeValue());
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append(filterItemArray[n2].getAttributeName());
                    stringBuffer.append(string);
                    stringBuffer.append(filterItemArray[n2].getAttributeValue());
                }
                stringBuffer.append(")");
                ++n2;
            }
            if (filterItemArray[0].getLogicalFilter() != null) {
                stringBuffer.append(")");
            }
            ++n;
        }
        if (filterItemGroupPairArray.length > 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof FilterResultModifier && super.equals(object) && ((Object)((Object)this)).toString().equals(object.toString())) {
            bl = true;
        }
        return bl;
    }

    public FilterResultModifier(String string, Filter filter, boolean bl) {
        super(string);
        this.setSubContainerSearch(bl);
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public FilterResultModifier(String string, int n, Filter filter, boolean bl) {
        super(string, n, 0, new ResultModifierFilterEntry("", null), bl);
        if (filter != null) {
            this.filters.addElement(filter);
        }
    }

    public static class FilterItemGroup {
        private Vector filterItems = new Vector();

        public void addFilterItem(String string, String string2, String string3, String string4) {
            FilterItemGroup filterItemGroup = this;
            if (filterItemGroup == null) {
                throw null;
            }
            FilterItem filterItem = filterItemGroup.new FilterItem(string, string2, string3, string4);
            this.filterItems.addElement(filterItem);
        }

        public FilterItem[] getFilterItems() {
            Object[] objectArray = new FilterItem[this.filterItems.size()];
            this.filterItems.copyInto(objectArray);
            return objectArray;
        }

        public class FilterItem {
            private String attributeName;
            private String compareFilter;
            private String attributeValue;
            private String logicalFilter;

            public String getAttributeName() {
                return this.attributeName;
            }

            public String getCompareFilter() {
                return this.compareFilter;
            }

            public String getAttributeValue() {
                return this.attributeValue;
            }

            public String getLogicalFilter() {
                return this.logicalFilter;
            }

            FilterItem(String string, String string2, String string3, String string4) {
                this.attributeName = string;
                this.compareFilter = string2;
                this.attributeValue = string3;
                this.logicalFilter = string4;
            }
        }
    }

    public static class Filter {
        private Vector filter = new Vector();
        private String filterTypeName = null;

        public String getFilterTypeName() {
            return this.filterTypeName;
        }

        public void addFilterItemGroupPair(FilterItemGroup filterItemGroup, String string) {
            Filter filter = this;
            if (filter == null) {
                throw null;
            }
            this.filter.addElement(filter.new FilterItemGroupPair(filterItemGroup, string));
        }

        public FilterItemGroupPair[] getFilterItemGroupPairs() {
            Object[] objectArray = new FilterItemGroupPair[this.filter.size()];
            this.filter.copyInto(objectArray);
            return objectArray;
        }

        public Filter() {
            this.filterTypeName = null;
        }

        public Filter(String string) {
            this.filterTypeName = string;
        }

        public class FilterItemGroupPair {
            private FilterItemGroup group;
            private String logicalFilter;

            public FilterItemGroup getFilterItemGroup() {
                return this.group;
            }

            public String getLogicalFilter() {
                return this.logicalFilter;
            }

            public FilterItemGroupPair(FilterItemGroup filterItemGroup, String string) {
                this.group = filterItemGroup;
                this.logicalFilter = string;
            }
        }
    }
}

