/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class StringStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_CI_EQUAL_OBJ = 2;
    private static final int BAD_COMPARE_OBJ = 3;
    private static final int WITHIN_BOUNDS = 4;
    private static final int BAD_TOSTRING_OBJ = 5;

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof StringValue) {
            if (valueComponent.getSyntax() == valueComponent2.getSyntax()) {
                StringValue stringValue = (StringValue)valueComponent;
                StringValue stringValue2 = (StringValue)valueComponent2;
                return stringValue.getValue().equals(stringValue2.getValue());
            }
            return false;
        }
        throw new AdminError(1, this.getClass());
    }

    protected final boolean equalsIgnoreCase(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof StringValue) {
            if (valueComponent.getSyntax() == valueComponent2.getSyntax()) {
                StringValue stringValue = (StringValue)valueComponent;
                StringValue stringValue2 = (StringValue)valueComponent2;
                return stringValue.getValue().equalsIgnoreCase(stringValue2.getValue());
            }
            return false;
        }
        throw new AdminError(2, this.getClass());
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof StringValue && valueComponent2 instanceof StringValue) {
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            StringValue stringValue = (StringValue)valueComponent;
            StringValue stringValue2 = (StringValue)valueComponent2;
            return stringValue.getValue().compareTo(stringValue2.getValue());
        }
        throw new AdminError(3, this.getClass());
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof StringValue) {
            return ((StringValue)valueComponent).getValue().toString();
        }
        throw new AdminError(5, this.getClass());
    }

    public boolean canCreateValue(Object object) {
        if (object instanceof String) {
            return this.isLegalString((String)object);
        }
        return false;
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        String string;
        if (object instanceof String && this.isLegalString(string = (String)object)) {
            return new StringValue(this.getSyntax(), string);
        }
        throw new ComponentCreationException();
    }

    public ValueComponent createValueComponent() {
        return new StringValue(this.getSyntax(), "");
    }

    public boolean isLegalString(String string) {
        return true;
    }

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof StringValue) {
            StringValue stringValue = (StringValue)valueComponent;
            long l3 = stringValue.getValue().length();
            return l3 >= l && l3 <= l2;
        }
        throw new AdminError(4, this.getClass());
    }

    protected boolean stringIsValid(String string, String string2) {
        int n = string2.length();
        while (n-- > 0) {
            if (string.indexOf(string2.charAt(n)) != -1) continue;
            return false;
        }
        return true;
    }

    public abstract Syntax getSyntax();
}

