/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public abstract class TimeStrategy
implements ValueStrategy {
    private static final int BAD_OBJ = 1;
    protected static final int WITHIN_BOUNDS = 3;

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        return this.compare(valueComponent, valueComponent2) == 0L;
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof DateValue) {
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            DateValue dateValue = (DateValue)valueComponent;
            DateValue dateValue2 = (DateValue)valueComponent2;
            return dateValue.getMillis() - dateValue2.getMillis();
        }
        throw new AdminError(1, this.getClass());
    }

    public boolean canCreateValue(Object object) {
        long l;
        if (object instanceof Number && (l = ((Number)object).longValue()) >= 0L) {
            return true;
        }
        return object instanceof Date || object instanceof String;
    }

    public ValueComponent createValueComponent() {
        return new DateValue(this.getSyntax(), new Date());
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof Date) {
            Date date = (Date)object;
            return new DateValue(this.getSyntax(), date);
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l >= 0L) {
                return new DateValue(this.getSyntax(), l);
            }
        } else if (object instanceof String) {
            try {
                Date date = DateFormat.getDateInstance().parse((String)object);
                return new DateValue(this.getSyntax(), date);
            }
            catch (ParseException parseException) {
                throw new ComponentCreationException();
            }
        }
        throw new ComponentCreationException();
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof DateValue) {
            Date date = ((DateValue)valueComponent).getValue();
            return date.toString();
        }
        return valueComponent.toString();
    }

    public abstract Syntax getSyntax();

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof DateValue) {
            DateValue dateValue = (DateValue)valueComponent;
            long l3 = dateValue.getMillis();
            return l3 >= l && l3 <= l2;
        }
        throw new AdminError(3, this.getClass());
    }
}

