/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;

public abstract class ValueListFacade {
    private static int REPLACE_COMPONENT = 1;
    private static int CREATE_COMPONENT = 2;
    protected ValueList valueList;

    public final ValueList getValueList() {
        return this.valueList;
    }

    protected final void replaceStringValue(String string, int n) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent valueComponent = this.valueList.getElementAt(n);
            ValueComponent valueComponent2 = valueComponent.getSyntax().createValueComponent(string);
            this.replaceComp(valueComponent, valueComponent2);
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceLongValue(long l, int n) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent valueComponent = this.valueList.getElementAt(n);
            ValueComponent valueComponent2 = valueComponent.getSyntax().createValueComponent(new Long(l));
            this.replaceComp(valueComponent, valueComponent2);
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceHexValue(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent valueComponent = this.valueList.getElementAt(n);
            ValueComponent valueComponent2 = valueComponent.getSyntax().createValueComponent(byArray);
            this.replaceComp(valueComponent, valueComponent2);
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceBooleanValue(boolean bl, int n) throws ArrayIndexOutOfBoundsException {
        try {
            ValueComponent valueComponent = this.valueList.getElementAt(n);
            ValueComponent valueComponent2 = valueComponent.getSyntax().createValueComponent(new Boolean(bl));
            this.replaceComp(valueComponent, valueComponent2);
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(CREATE_COMPONENT, this.getClass());
        }
    }

    protected final void replaceValueList(ValueList valueList, int n) throws ArrayIndexOutOfBoundsException {
        ValueComponent valueComponent = this.valueList.getElementAt(n);
        this.replaceComp(valueComponent, valueList);
    }

    private final void replaceComp(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (!this.valueList.replaceComponent(valueComponent, valueComponent2)) {
            throw new AdminError(REPLACE_COMPONENT, this.getClass());
        }
    }

    public ValueListFacade(ValueList valueList) {
        this.valueList = valueList;
    }
}

