/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.CaseIgnoreListFacade;
import com.novell.admin.ns.ldap.LDAPSyntax;
import java.util.StringTokenizer;
import java.util.Vector;

final class CaseIgnoreListStrategy
extends ListStrategy {
    public ValueComponent createValueComponent() {
        ValueList valueList = new ValueList(LDAPSyntax.SYN_CI_LIST);
        valueList.initList(new StringValue(LDAPSyntax.SYN_DIRECTORY_STRING, ""));
        return valueList;
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof String) {
            ValueList valueList = new ValueList(LDAPSyntax.SYN_CI_LIST);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "$");
            while (stringTokenizer.hasMoreTokens()) {
                valueList.initList(new StringValue(LDAPSyntax.SYN_DIRECTORY_STRING, stringTokenizer.nextToken()));
            }
            return valueList;
        }
        throw new ComponentCreationException();
    }

    public Vector getAddableSyntaxes(ValueList valueList) {
        Vector<LDAPSyntax> vector = new Vector<LDAPSyntax>();
        vector.addElement(LDAPSyntax.SYN_DIRECTORY_STRING);
        return vector;
    }

    public boolean canInsertComponent(ValueList valueList, ValueComponent valueComponent) {
        if (valueComponent.getSyntax() == LDAPSyntax.SYN_DIRECTORY_STRING) {
            return !valueList.contains(valueComponent);
        }
        return false;
    }

    public boolean canRemoveComponent(ValueList valueList, ValueComponent valueComponent) {
        return valueList.contains(valueComponent);
    }

    public Object createFacade(ValueComponent valueComponent) throws IncompatibleComponentException {
        return new CaseIgnoreListFacade((ValueList)valueComponent);
    }

    CaseIgnoreListStrategy() {
    }
}

