/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ldap.ClassFlag;

public final class LDAPClassFlags
implements Cloneable {
    public static final int EFFECTIVE_CLASS = 1;
    public static final int AUXILIARY_CLASS = 2;
    public static final int CONTAINER_CLASS = 4;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private static final ClassFlag[] classFlagTable = new ClassFlag[]{new ClassFlag(1, "EFFECTIVE"), new ClassFlag(2, "AUXILIARY")};
    private int flags;

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object object) {
        if (object instanceof LDAPClassFlags) {
            LDAPClassFlags lDAPClassFlags = (LDAPClassFlags)object;
            return lDAPClassFlags.flags == this.flags;
        }
        return false;
    }

    public boolean isFlagSet(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public void clearFlag(int n) {
        this.flags &= ~n;
    }

    public String[] getStrings() {
        int n = 0;
        int n2 = 0;
        while (n2 < classFlagTable.length) {
            if ((this.flags & LDAPClassFlags.classFlagTable[n2].flag) != 0) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < classFlagTable.length) {
            if ((this.flags & LDAPClassFlags.classFlagTable[n2].flag) != 0) {
                stringArray[n++] = LDAPClassFlags.classFlagTable[n2].string;
            }
            ++n2;
        }
        return stringArray;
    }

    public Object clone() {
        try {
            return (LDAPClassFlags)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AdminError(1, this.getClass());
        }
    }

    public LDAPClassFlags(int n) {
        this.flags = n;
    }
}

