/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultSchemaDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Schema;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.ldap.LDAPNamespaceException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Vector;

public final class LDAPSchemaDefinition
extends DefaultSchemaDefinition {
    private Schema schema = null;
    private PropertyChangeSupport changeSupporter;
    private VetoableChangeSupport vetoSupporter;

    public AttributeDefinition getAttributeDefinition(String string) throws NamespaceException {
        return super.getAttributeDefinition(string.toLowerCase());
    }

    public void putAttributeDefinition(AttributeDefinition attributeDefinition) throws LDAPNamespaceException, SPIException, PropertyVetoException {
        String string = attributeDefinition.getName();
        LDAPAttributeDefinition lDAPAttributeDefinition = (LDAPAttributeDefinition)this.attributes.get(string.toLowerCase());
        if (lDAPAttributeDefinition != null) {
            throw LDAPNamespaceException.CANT_MODIFY_EXISTING_ATTRIBUTE;
        }
        this.vetoSupporter.fireVetoableChange(string, lDAPAttributeDefinition, attributeDefinition);
        if (this.schema != null) {
            this.schema.writeAttributeDefinition((LDAPAttributeDefinition)attributeDefinition);
        }
        this.attributes.put(string.toLowerCase(), attributeDefinition);
        this.changeSupporter.firePropertyChange(string, lDAPAttributeDefinition, attributeDefinition);
    }

    public void putClassDefinition(ClassDefinition classDefinition) throws NamespaceException, SPIException, PropertyVetoException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)classDefinition;
        AttributeDefinition[] attributeDefinitionArray = null;
        String string = classDefinition.getName();
        LDAPClassDefinition lDAPClassDefinition2 = (LDAPClassDefinition)this.classes.get(string.toLowerCase());
        String[] stringArray = lDAPClassDefinition.getSuperClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (!this.classes.containsKey(stringArray[n])) {
                throw LDAPNamespaceException.SUPERCLASS_NOT_DEFINED;
            }
            ++n;
        }
        attributeDefinitionArray = classDefinition.getMandatoryAttributes();
        n = 0;
        while (n < attributeDefinitionArray.length) {
            if (!this.attributes.containsKey(attributeDefinitionArray[n].getName())) {
                throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
            }
            ++n;
        }
        if (lDAPClassDefinition2 != null) {
            LDAPAttributeDefinition[] lDAPAttributeDefinitionArray = (LDAPAttributeDefinition[])lDAPClassDefinition2.getMandatoryAttributes();
            if (attributeDefinitionArray.length == lDAPAttributeDefinitionArray.length) {
                Vector<LDAPAttributeDefinition> vector = new Vector<LDAPAttributeDefinition>(lDAPAttributeDefinitionArray.length);
                int n2 = 0;
                while (n2 < lDAPAttributeDefinitionArray.length) {
                    vector.addElement(lDAPAttributeDefinitionArray[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < lDAPAttributeDefinitionArray.length) {
                    if (!vector.contains(attributeDefinitionArray[n2])) {
                        throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
                    }
                    ++n2;
                }
            } else {
                throw NamespaceException.MODIFYING_MANDATORY_ATTRIBUTES_NOT_ALLOWED;
            }
        }
        attributeDefinitionArray = classDefinition.getOptionalAttributes();
        int n3 = 0;
        while (n3 < attributeDefinitionArray.length) {
            if (!this.attributes.containsKey(attributeDefinitionArray[n3].getName())) {
                throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
            }
            ++n3;
        }
        if (lDAPClassDefinition2 != null && lDAPClassDefinition2.getClassFlags().getFlags() != ((LDAPClassDefinition)classDefinition).getClassFlags().getFlags()) {
            throw NamespaceException.MODIFY_CLASS_FLAGS_NOT_ALLOWED;
        }
        this.vetoSupporter.fireVetoableChange(string, lDAPClassDefinition2, lDAPClassDefinition);
        if (this.schema != null) {
            if (lDAPClassDefinition2 != null) {
                this.schema.modifyClassDefinition((LDAPClassDefinition)classDefinition);
            } else {
                this.schema.writeClassDefinition((LDAPClassDefinition)classDefinition);
            }
        }
        this.classes.put(string.toLowerCase(), classDefinition);
        this.changeSupporter.firePropertyChange(string, lDAPClassDefinition2, classDefinition);
    }

    public void removeAttributeDefinition(String string) throws NamespaceException, SPIException, PropertyVetoException {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(string);
        if (attributeDefinition == null) {
            return;
        }
        ClassDefinition[] classDefinitionArray = this.getClassesUsingAttribute(string);
        if (classDefinitionArray.length != 0) {
            throw NamespaceException.ATTRIBUTE_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(string, attributeDefinition, null);
        if (this.schema != null) {
            this.schema.deleteAttributeDefinition((LDAPAttributeDefinition)attributeDefinition);
        }
        this.attributes.remove(string);
        this.changeSupporter.firePropertyChange(string, attributeDefinition, null);
    }

    public void removeClassDefinition(String string) throws NamespaceException, SPIException, PropertyVetoException {
        ClassDefinition[] classDefinitionArray = this.getSubClasses(string);
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        if (classDefinitionArray.length != 0) {
            throw NamespaceException.CLASS_IN_USE;
        }
        this.vetoSupporter.fireVetoableChange(string, lDAPClassDefinition, null);
        if (this.schema != null) {
            this.schema.deleteClassDefinition(lDAPClassDefinition);
        }
        this.classes.remove(string);
        this.changeSupporter.firePropertyChange(string, lDAPClassDefinition, null);
    }

    public ClassDefinition[] getEffectiveClasses(String string) {
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        try {
            if (this.getUnexpandedClassDefinition(string).isContainer()) {
                Enumeration enumeration = this.classes.elements();
                while (enumeration.hasMoreElements()) {
                    LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)enumeration.nextElement();
                    if (!lDAPClassDefinition.isEffective() || !this.canContain(string, lDAPClassDefinition.getName())) continue;
                    try {
                        vector.addElement(this.getClassDefinition(lDAPClassDefinition.getName()));
                    }
                    catch (NamespaceException namespaceException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition getUnexpandedClassDefinition(String string) throws NamespaceException {
        ClassDefinition classDefinition = (ClassDefinition)this.classes.get(string.toLowerCase());
        if (classDefinition != null) {
            return classDefinition;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public ClassDefinition getClassDefinition(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        ClassDefinition[] classDefinitionArray = this.getSuperClasses(string);
        ClassDefinition[] classDefinitionArray2 = this.getContainmentClasses(string);
        AttributeDefinition[] attributeDefinitionArray = this.getOptionalAttributes(string);
        AttributeDefinition[] attributeDefinitionArray2 = this.getMandatoryAttributes(string);
        AttributeDefinition[] attributeDefinitionArray3 = this.getNamingAttributes(string);
        String[] stringArray = new String[classDefinitionArray.length];
        String[] stringArray2 = new String[classDefinitionArray2.length];
        int n = 0;
        while (n < classDefinitionArray.length) {
            stringArray[n] = classDefinitionArray[n].getName();
            ++n;
        }
        n = 0;
        while (n < classDefinitionArray2.length) {
            stringArray2[n] = classDefinitionArray2[n].getName();
            ++n;
        }
        LDAPClassDefinition lDAPClassDefinition2 = new LDAPClassDefinition(lDAPClassDefinition.getName(), lDAPClassDefinition.getClassFlags(), stringArray2, stringArray, attributeDefinitionArray2, attributeDefinitionArray3, attributeDefinitionArray, lDAPClassDefinition.getASN1Data());
        lDAPClassDefinition2.setExpanded(true);
        return lDAPClassDefinition2;
    }

    public ClassDefinition[] getSuperClasses(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllSuperClassesOf(lDAPClassDefinition, vector);
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean canContain(String string, String string2) {
        try {
            ClassDefinition[] classDefinitionArray = this.getContainmentClasses(string2);
            int n = 0;
            while (n < classDefinitionArray.length) {
                if (classDefinitionArray[n].getName().equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return false;
    }

    public ClassDefinition[] getContainmentClasses(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllContainmentClassesOf(lDAPClassDefinition, vector);
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition[] getSubClasses(String string) {
        Vector<LDAPClassDefinition> vector = new Vector<LDAPClassDefinition>(10, 10);
        Object[] objectArray = null;
        ClassDefinition[] classDefinitionArray = this.getClassDefinitions();
        int n = 0;
        while (n < classDefinitionArray.length) {
            LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)classDefinitionArray[n];
            if (lDAPClassDefinition.isInheritedFrom(string)) {
                vector.addElement(lDAPClassDefinition);
            }
            ++n;
        }
        objectArray = new LDAPClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getNamingAttributes(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllNamingAttributes(lDAPClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getOptionalAttributes(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllOptionalAttributes(lDAPClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getMandatoryAttributes(String string) throws NamespaceException {
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)this.getUnexpandedClassDefinition(string);
        Vector vector = new Vector();
        this.getAllMandatoryAttributes(lDAPClassDefinition, vector);
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Object clone() {
        LDAPSchemaDefinition lDAPSchemaDefinition = (LDAPSchemaDefinition)super.clone();
        lDAPSchemaDefinition.schema = null;
        lDAPSchemaDefinition.changeSupporter = new PropertyChangeSupport(lDAPSchemaDefinition);
        lDAPSchemaDefinition.vetoSupporter = new VetoableChangeSupport(lDAPSchemaDefinition);
        return lDAPSchemaDefinition;
    }

    public void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        String string = attributeDefinition.getName();
        this.attributes.put(string.toLowerCase(), attributeDefinition);
    }

    public void addClassDefinition(ClassDefinition classDefinition) {
        String string = classDefinition.getName();
        this.classes.put(string.toLowerCase(), classDefinition);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoSupporter.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoSupporter.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupporter.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupporter.removePropertyChangeListener(propertyChangeListener);
    }

    private void getAllSuperClassesOf(LDAPClassDefinition lDAPClassDefinition, Vector vector) throws NamespaceException {
        String[] stringArray = lDAPClassDefinition.getSuperClasses();
        int n = 0;
        while (n < stringArray.length) {
            LDAPClassDefinition lDAPClassDefinition2 = (LDAPClassDefinition)this.getUnexpandedClassDefinition(stringArray[n]);
            vector.addElement(lDAPClassDefinition2);
            this.getAllSuperClassesOf(lDAPClassDefinition2, vector);
            ++n;
        }
    }

    private void getAllContainmentClassesOf(LDAPClassDefinition lDAPClassDefinition, Vector vector) throws NamespaceException {
        String[] stringArray = lDAPClassDefinition.getContainmentClasses();
        String[] stringArray2 = lDAPClassDefinition.getSuperClasses();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(this.getUnexpandedClassDefinition(stringArray[n]));
            ++n;
        }
        n = 0;
        while (n < stringArray2.length) {
            this.getAllContainmentClassesOf((LDAPClassDefinition)this.getUnexpandedClassDefinition(stringArray2[n]), vector);
            ++n;
        }
    }

    private void getAllNamingAttributes(LDAPClassDefinition lDAPClassDefinition, Vector vector) throws NamespaceException {
        Vector<LDAPClassDefinition> vector2 = new Vector<LDAPClassDefinition>();
        vector2.addElement(lDAPClassDefinition);
        this.getAllSuperClassesOf(lDAPClassDefinition, vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LDAPClassDefinition lDAPClassDefinition2 = (LDAPClassDefinition)enumeration.nextElement();
            AttributeDefinition[] attributeDefinitionArray = lDAPClassDefinition2.getNamingAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
    }

    private void getAllOptionalAttributes(LDAPClassDefinition lDAPClassDefinition, Vector vector) throws NamespaceException {
        Vector<LDAPClassDefinition> vector2 = new Vector<LDAPClassDefinition>();
        vector2.addElement(lDAPClassDefinition);
        this.getAllSuperClassesOf(lDAPClassDefinition, vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LDAPClassDefinition lDAPClassDefinition2 = (LDAPClassDefinition)enumeration.nextElement();
            AttributeDefinition[] attributeDefinitionArray = lDAPClassDefinition2.getOptionalAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
    }

    private void getAllMandatoryAttributes(LDAPClassDefinition lDAPClassDefinition, Vector vector) throws NamespaceException {
        Vector<LDAPClassDefinition> vector2 = new Vector<LDAPClassDefinition>();
        vector2.addElement(lDAPClassDefinition);
        this.getAllSuperClassesOf(lDAPClassDefinition, vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LDAPClassDefinition lDAPClassDefinition2 = (LDAPClassDefinition)enumeration.nextElement();
            AttributeDefinition[] attributeDefinitionArray = lDAPClassDefinition2.getMandatoryAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
    }

    public LDAPSchemaDefinition(Schema schema) {
        this.schema = schema;
        this.changeSupporter = new PropertyChangeSupport(this);
        this.vetoSupporter = new VetoableChangeSupport(this);
    }
}

