/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.ldap.LDAPSyntax;
import java.util.Vector;

public final class TypedNameFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public static ValueList createValueList(String string, long l, long l2) {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(string);
            vector.addElement(new Long(l));
            vector.addElement(new Long(l2));
            ValueComponent valueComponent = LDAPSyntax.SYN_TYPED_NAME.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.TypedNameFacade");
        }
    }

    public String getObject() {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(0);
        return stringValue.getValue();
    }

    public long getLevel() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(1);
        return longValue.getValue();
    }

    public long getInterval() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(2);
        return longValue.getValue();
    }

    public void setObject(String string) {
        ValueStrategy valueStrategy = (ValueStrategy)LDAPSyntax.SYN_DN.getStrategy();
        if (valueStrategy.canCreateValue(string)) {
            this.replaceStringValue(string, 0);
        }
        throw new FacadeParameterException();
    }

    public void setLevel(long l) {
        this.replaceLongValue(l, 1);
    }

    public void setInterval(long l) {
        this.replaceLongValue(l, 2);
    }

    public TypedNameFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != LDAPSyntax.SYN_TYPED_NAME) {
            throw new IncompatibleComponentException();
        }
    }
}

