/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class HoldFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public static ValueList createValueList(String string, long l) {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(string);
            vector.addElement(new Long(l));
            ValueComponent valueComponent = NDSSyntax.SYN_HOLD.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.nds.HoldFacade");
        }
    }

    public String getSubject() {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(0);
        return stringValue.getValue();
    }

    public int getAmount() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(1);
        return (int)longValue.getValue();
    }

    public void setSubject(String string) {
        ValueStrategy valueStrategy = (ValueStrategy)NDSSyntax.SYN_DIST_NAME.getStrategy();
        if (valueStrategy.canCreateValue(string)) {
            this.replaceStringValue(string, 0);
        }
        throw new FacadeParameterException();
    }

    public void setAmount(int n) {
        this.replaceLongValue(n, 1);
    }

    public HoldFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != NDSSyntax.SYN_HOLD) {
            throw new IncompatibleComponentException();
        }
    }
}

