/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.MODObject;
import com.novell.admin.ns.MultiObjModificationCallBack;
import com.novell.admin.ns.MultiObjModificationNamespace;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NSObjectCache;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import java.util.Enumeration;
import java.util.Vector;

public final class MultiObjModificationNamespaceImpl
implements MultiObjModificationNamespace {
    private NDSNamespace namespace;
    private NSObjectCache nsObjectLookupTable;

    public void updateMultipleObjects(ObjectEntryCollection objectEntryCollection, MODObject mODObject, MultiObjModificationCallBack multiObjModificationCallBack) {
        String[] stringArray = mODObject.getAddedAttributes();
        String[] stringArray2 = mODObject.getModifiedAttributes();
        String[] stringArray3 = mODObject.getDeletedAttributes();
        ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
        while (objectEntryEnumeration.hasMoreElements()) {
            try {
                ObjectEntry objectEntry = (ObjectEntry)objectEntryEnumeration.nextElement();
                if (multiObjModificationCallBack.update(objectEntry) == 0) {
                    return;
                }
                NSObject nSObject = this.namespace.getDetails(objectEntry);
                this.stuffNSObjectWithAttributeChanges(nSObject, mODObject, stringArray);
                this.stuffNSObjectWithAttributeChanges(nSObject, mODObject, stringArray2);
                int n = 0;
                while (n < stringArray3.length) {
                    String string = stringArray3[n];
                    NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute(string);
                    NDSObjectAttribute nDSObjectAttribute2 = (NDSObjectAttribute)mODObject.getAttribute(string);
                    if (nDSObjectAttribute != null) {
                        nSObject.deleteAttribute(string);
                    }
                    ++n;
                }
                this.namespace.update(nSObject);
            }
            catch (Exception exception) {
                if (multiObjModificationCallBack.handleException(exception) != 0) continue;
                return;
            }
        }
    }

    public MODObject getMODDetails(ObjectEntryCollection objectEntryCollection, Object object) {
        ObjectEntry objectEntry = objectEntryCollection.getFirstElement();
        MODObject mODObject = null;
        mODObject = (MODObject)this.nsObjectLookupTable.getDetails(object, objectEntry);
        if (mODObject == null) {
            mODObject = new MODObject(objectEntry);
            this.nsObjectLookupTable.setDetails(object, mODObject);
        }
        return mODObject;
    }

    private void stuffNSObjectWithAttributeChanges(NSObject nSObject, NSObject nSObject2, String[] stringArray) throws NamespaceException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute(string);
            NDSObjectAttribute nDSObjectAttribute2 = (NDSObjectAttribute)nSObject2.getAttribute(string);
            if (nDSObjectAttribute == null) {
                nSObject.addAttribute(nDSObjectAttribute2);
            } else if (nSObject.isNamedBy(string)) {
                this.modifyNamingAttrib(nSObject, nSObject2, string);
            } else if (nDSObjectAttribute.getAttributeDefinition().isSingleValued() || this.behavesLikeSingleValued(string)) {
                NDSObjectAttribute nDSObjectAttribute3 = this.getAttributeDifferences(nDSObjectAttribute, nDSObjectAttribute2);
                Enumeration enumeration = nDSObjectAttribute3.getValueComponents();
                if (enumeration.hasMoreElements()) {
                    nDSObjectAttribute.removeAllComponents();
                    while (enumeration.hasMoreElements()) {
                        nDSObjectAttribute.addComponent((ValueComponent)enumeration.nextElement());
                    }
                }
            } else if (string.equalsIgnoreCase("ACL")) {
                this.stuffACLValues(nSObject, nDSObjectAttribute2);
            } else {
                this.appendValues(nSObject, nDSObjectAttribute2);
            }
            ++n;
        }
    }

    private void stuffACLValues(NSObject nSObject, NDSObjectAttribute nDSObjectAttribute) throws NamespaceException {
        NDSObjectAttribute nDSObjectAttribute2 = (NDSObjectAttribute)nSObject.getAttribute(nDSObjectAttribute.getName());
        Enumeration enumeration = nDSObjectAttribute2.getValueComponents();
        Enumeration enumeration2 = nDSObjectAttribute.getValueComponents();
        while (enumeration2.hasMoreElements()) {
            int n;
            boolean bl = false;
            ValueList valueList = (ValueList)enumeration2.nextElement();
            ObjectACLFacade objectACLFacade = (ObjectACLFacade)valueList.createFacade();
            ObjectACLFacade objectACLFacade2 = null;
            enumeration = nDSObjectAttribute2.getValueComponents();
            while (enumeration.hasMoreElements()) {
                long l;
                long l2;
                ValueList valueList2 = (ValueList)enumeration.nextElement();
                objectACLFacade2 = (ObjectACLFacade)valueList2.createFacade();
                if (!objectACLFacade.getProtectedAttrName().equalsIgnoreCase(objectACLFacade2.getProtectedAttrName()) || !objectACLFacade.getSubjectName().equalsIgnoreCase(objectACLFacade2.getSubjectName()) || (l2 = objectACLFacade.getPrivileges()) == (l = objectACLFacade2.getPrivileges())) continue;
                if ((l2 & 0x40L) != 0L && (l & 0x40L) != 0L) {
                    nDSObjectAttribute2.replaceComponent(valueList2, valueList);
                    bl = true;
                    continue;
                }
                if ((l2 & 0x40L) != 0L || (l & 0x40L) != 0L) continue;
                nDSObjectAttribute2.replaceComponent(valueList2, valueList);
                bl = true;
            }
            if (bl || nDSObjectAttribute2.contains(valueList) || (n = this.getACLSimilarValueCount(nDSObjectAttribute2, objectACLFacade2)) >= 2) continue;
            nDSObjectAttribute2.addComponent(valueList);
        }
    }

    private int getACLSimilarValueCount(NDSObjectAttribute nDSObjectAttribute, ObjectACLFacade objectACLFacade) {
        int n = 0;
        Enumeration enumeration = nDSObjectAttribute.getValueComponents();
        while (enumeration.hasMoreElements()) {
            ValueList valueList = (ValueList)enumeration.nextElement();
            ObjectACLFacade objectACLFacade2 = (ObjectACLFacade)valueList.createFacade();
            if (!objectACLFacade2.getProtectedAttrName().equalsIgnoreCase(objectACLFacade.getProtectedAttrName()) || !objectACLFacade2.getSubjectName().equalsIgnoreCase(objectACLFacade.getSubjectName())) continue;
            ++n;
        }
        return n;
    }

    private NDSObjectAttribute getAttributeDifferences(NDSObjectAttribute nDSObjectAttribute, NDSObjectAttribute nDSObjectAttribute2) {
        ValueComponent valueComponent;
        Vector<ValueComponent> vector = new Vector<ValueComponent>();
        Vector<ValueComponent> vector2 = new Vector<ValueComponent>();
        Enumeration enumeration = nDSObjectAttribute2.getValueComponents();
        Enumeration enumeration2 = nDSObjectAttribute.getValueComponents();
        NDSObjectAttribute nDSObjectAttribute3 = null;
        while (enumeration.hasMoreElements()) {
            valueComponent = (ValueComponent)enumeration.nextElement();
            if (nDSObjectAttribute.contains(valueComponent)) continue;
            vector.addElement(valueComponent);
        }
        Object[] objectArray = new ValueComponent[vector.size()];
        vector.copyInto(objectArray);
        while (enumeration2.hasMoreElements()) {
            valueComponent = (ValueComponent)enumeration2.nextElement();
            if (nDSObjectAttribute2.contains(valueComponent)) continue;
            vector2.addElement(valueComponent);
        }
        Object[] objectArray2 = new ValueComponent[vector2.size()];
        vector2.copyInto(objectArray2);
        try {
            nDSObjectAttribute3 = new NDSObjectAttribute(nDSObjectAttribute.getAttributeDefinition(), (ValueComponent[])objectArray2);
            int n = 0;
            while (n < objectArray2.length) {
                nDSObjectAttribute3.removeComponent((ValueComponent)objectArray2[n]);
                ++n;
            }
            nDSObjectAttribute3.addComponents((ValueComponent[])objectArray);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return nDSObjectAttribute3;
    }

    private boolean behavesLikeSingleValued(String string) {
        boolean bl = false;
        if (string.equals("Description") || string.equals("Internet EMail Address") || string.equals("SA") || string.equals("S") || string.equals("Postal Office Box") || string.equals("Physical Delivery Office Name") || string.equals("Postal Code") || string.equals("Postal Address")) {
            bl = true;
        }
        return bl;
    }

    private void modifyNamingAttrib(NSObject nSObject, NSObject nSObject2, String string) {
        NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute(string);
        NDSObjectAttribute nDSObjectAttribute2 = (NDSObjectAttribute)nSObject2.getAttribute(string);
        String string2 = nSObject.getObjectEntry().getName();
        String string3 = nSObject2.getObjectEntry().getName();
        Enumeration enumeration = nDSObjectAttribute.getValueComponents();
        Vector<ValueComponent> vector = new Vector<ValueComponent>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((ValueComponent)enumeration.nextElement());
        }
        Enumeration enumeration2 = nDSObjectAttribute2.getValueComponents();
        while (enumeration2.hasMoreElements()) {
            ValueComponent valueComponent = (ValueComponent)enumeration2.nextElement();
            if (string3.equalsIgnoreCase(valueComponent.toString())) continue;
            try {
                nDSObjectAttribute.addComponent(valueComponent);
            }
            catch (NamespaceException namespaceException) {
                // empty catch block
            }
        }
    }

    private void appendValues(NSObject nSObject, NDSObjectAttribute nDSObjectAttribute) throws NamespaceException {
        if (!nDSObjectAttribute.getAttributeDefinition().isSingleValued()) {
            NDSObjectAttribute nDSObjectAttribute2 = (NDSObjectAttribute)nSObject.getAttribute(nDSObjectAttribute.getName());
            Enumeration enumeration = nDSObjectAttribute.getValueComponents();
            while (enumeration.hasMoreElements()) {
                nDSObjectAttribute2.addComponent((ValueComponent)enumeration.nextElement());
            }
        }
    }

    public MultiObjModificationNamespaceImpl(NDSNamespace nDSNamespace, NSObjectCache nSObjectCache) {
        this.namespace = nDSNamespace;
        this.nsObjectLookupTable = nSObjectCache;
    }
}

