/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.DefaultClassDefinition;
import com.novell.admin.ns.nds.NDSClassFlags;
import java.util.Enumeration;
import java.util.Vector;

public final class NDSClassDefinition
extends DefaultClassDefinition {
    private Vector superClassNames = null;
    private NDSClassFlags classFlags = null;
    private byte[] asn1Data;
    private boolean expanded = false;

    public String[] getSuperClasses() {
        Object[] objectArray = new String[this.superClassNames.size()];
        this.superClassNames.copyInto(objectArray);
        return objectArray;
    }

    public boolean isInheritedFrom(String string) {
        return this.superClassNames.contains(string);
    }

    public NDSClassFlags getClassFlags() {
        return (NDSClassFlags)this.classFlags.clone();
    }

    public byte[] getASN1Data() {
        byte[] byArray = new byte[this.asn1Data.length];
        System.arraycopy(this.asn1Data, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NDSClassDefinition)) return false;
        NDSClassDefinition nDSClassDefinition = (NDSClassDefinition)object;
        if (!super.equals(object)) {
            return false;
        }
        NDSClassDefinition nDSClassDefinition2 = nDSClassDefinition;
        synchronized (nDSClassDefinition2) {
            NDSClassDefinition nDSClassDefinition3 = this;
            synchronized (nDSClassDefinition3) {
                if (nDSClassDefinition.superClassNames.size() != this.superClassNames.size()) return false;
                if (nDSClassDefinition.classFlags.getFlags() != this.classFlags.getFlags()) return false;
                Enumeration enumeration = this.superClassNames.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    boolean bl = nDSClassDefinition.superClassNames.contains(string);
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public NDSClassDefinition(String string, NDSClassFlags nDSClassFlags, String[] stringArray, String[] stringArray2, AttributeDefinition[] attributeDefinitionArray, AttributeDefinition[] attributeDefinitionArray2, AttributeDefinition[] attributeDefinitionArray3, byte[] byArray) {
        super(string, stringArray, attributeDefinitionArray, attributeDefinitionArray2, attributeDefinitionArray3, nDSClassFlags.isFlagSet(1), nDSClassFlags.isFlagSet(2), nDSClassFlags.isFlagSet(4), nDSClassFlags.isFlagSet(32));
        int n;
        this.classFlags = (NDSClassFlags)nDSClassFlags.clone();
        if (byArray != null) {
            if (byArray.length != 32) {
                this.asn1Data = new byte[32];
                if (byArray.length > 32) {
                    n = 0;
                    while (n < 32) {
                        this.asn1Data[n] = byArray[n];
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < byArray.length) {
                        this.asn1Data[n] = byArray[n];
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < 32 - byArray.length) {
                        this.asn1Data[n++] = 0;
                        ++n2;
                    }
                }
            } else {
                this.asn1Data = byArray;
            }
        } else {
            this.asn1Data = new byte[32];
            n = 0;
            while (n < 32) {
                this.asn1Data[n] = 0;
                ++n;
            }
        }
        if (stringArray2 != null) {
            this.superClassNames = new Vector(stringArray2.length);
            n = 0;
            while (n < stringArray2.length) {
                this.superClassNames.addElement(stringArray2[n]);
                ++n;
            }
        } else {
            this.superClassNames = new Vector();
        }
    }
}

