/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class ObjectACLFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public static ValueList createValueList(String string, String string2, long l) {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(string);
            vector.addElement(string2);
            vector.addElement(new Long(l));
            ValueComponent valueComponent = NDSSyntax.SYN_OBJECT_ACL.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.nds.ObjectACLFacade");
        }
    }

    public String getProtectedAttrName() {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(0);
        return stringValue.getValue();
    }

    public String getSubjectName() {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(1);
        return stringValue.getValue();
    }

    public long getPrivileges() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(2);
        return longValue.getValue();
    }

    public void setProtectedAttrName(String string) {
        this.replaceStringValue(string, 0);
    }

    public void setSubjectName(String string) {
        ValueStrategy valueStrategy = (ValueStrategy)NDSSyntax.SYN_DIST_NAME.getStrategy();
        if (!valueStrategy.canCreateValue(string)) {
            throw new FacadeParameterException();
        }
        this.replaceStringValue(string, 1);
    }

    public void setPrivileges(long l) {
        this.replaceLongValue(l, 2);
    }

    public ObjectACLFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != NDSSyntax.SYN_OBJECT_ACL) {
            throw new IncompatibleComponentException();
        }
    }
}

