/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.OctetListFacade;
import java.util.Enumeration;
import java.util.Vector;

final class OctetListStrategy
extends ListStrategy {
    public ValueComponent createValueComponent() {
        ValueList valueList = new ValueList(NDSSyntax.SYN_OCTET_LIST);
        byte[] byArray = new byte[]{0};
        valueList.initList(new HexValue(NDSSyntax.SYN_OCTET_STRING, byArray));
        return valueList;
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (!(object instanceof Vector)) {
            throw new ComponentCreationException();
        }
        Vector vector = (Vector)object;
        ValueList valueList = new ValueList(NDSSyntax.SYN_OCTET_LIST);
        Vector vector2 = vector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                HexValue hexValue;
                Object e = enumeration.nextElement();
                if (e instanceof byte[]) {
                    valueList.initList(new HexValue(NDSSyntax.SYN_OCTET_STRING, (byte[])e));
                    continue;
                }
                if (!(e instanceof HexValue) || (hexValue = (HexValue)e).getSyntax() != NDSSyntax.SYN_OCTET_STRING) continue;
                valueList.initList(hexValue);
            }
        }
        return valueList;
    }

    public Vector getAddableSyntaxes(ValueList valueList) {
        Vector<NDSSyntax> vector = new Vector<NDSSyntax>();
        vector.addElement(NDSSyntax.SYN_OCTET_STRING);
        return vector;
    }

    public boolean canInsertComponent(ValueList valueList, ValueComponent valueComponent) {
        if (valueComponent.getSyntax() == NDSSyntax.SYN_OCTET_STRING) {
            return !valueList.contains(valueComponent);
        }
        return false;
    }

    public boolean canRemoveComponent(ValueList valueList, ValueComponent valueComponent) {
        return valueList.contains(valueComponent);
    }

    public Object createFacade(ValueComponent valueComponent) throws IncompatibleComponentException {
        return new OctetListFacade((ValueList)valueComponent);
    }

    OctetListStrategy() {
    }
}

