/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import java.util.Vector;

public final class ReplicaPointerFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int SERVER_NAME_INDEX = 0;
    private static final int REPLICA_TYPE_INDEX = 1;
    private static final int REPLICA_NUMBER_INDEX = 2;
    private static final int REPLICA_COUNT_INDEX = 3;
    private static final int HINT_INDEX = 4;

    public static ValueList createValueList(String string, int n, int n2, int n3, NetAddressFacade netAddressFacade) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(string);
        vector.addElement(new Integer(n));
        vector.addElement(new Integer(n2));
        vector.addElement(new Integer(n3));
        vector.addElement(netAddressFacade.getValueList());
        try {
            ValueComponent valueComponent = NDSSyntax.SYN_REPLICA_POINTER.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.nds.ReplicaPointerFacade");
        }
    }

    public String getServerName() {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(0);
        return stringValue.getValue();
    }

    public long getReplicaType() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(1);
        return longValue.getValue();
    }

    public long getReplicaNumber() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(2);
        return longValue.getValue();
    }

    public long getReplicaCount() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(3);
        return longValue.getValue();
    }

    public NetAddressFacade getNetworkAddressHint() {
        ValueList valueList = (ValueList)this.valueList.getElementAt(4);
        return (NetAddressFacade)valueList.createFacade();
    }

    public void setServerName(String string) {
        this.replaceStringValue(string, 0);
    }

    public void setReplicaType(int n) {
        this.replaceLongValue(n, 1);
    }

    public void setReplicaNumber(int n) {
        this.replaceLongValue(n, 2);
    }

    public void setReplicaCount(int n) {
        this.replaceLongValue(n, 3);
    }

    public void setNetworkAddressHint(NetAddressFacade netAddressFacade) {
        this.replaceValueList(netAddressFacade.getValueList(), 4);
    }

    public ReplicaPointerFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != NDSSyntax.SYN_REPLICA_POINTER) {
            throw new IncompatibleComponentException();
        }
    }
}

