/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class TimeStampFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;

    public static ValueList createValueList(long l, int n, int n2) {
        try {
            Vector<Number> vector = new Vector<Number>();
            vector.addElement(new Long(l));
            vector.addElement(new Integer(n));
            vector.addElement(new Integer(n2));
            ValueComponent valueComponent = NDSSyntax.SYN_TIMESTAMP.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.nds.TimeStampFacade");
        }
    }

    public int getSeconds() {
        DateValue dateValue = (DateValue)this.valueList.getElementAt(0);
        return (int)(dateValue.getMillis() / 1000L);
    }

    public int getReplica() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(1);
        return (int)longValue.getValue();
    }

    public int getEvent() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(2);
        return (int)longValue.getValue();
    }

    public void setSeconds(int n) {
        this.replaceLongValue(n, 0);
    }

    public void setReplica(int n) {
        this.replaceLongValue(n, 1);
    }

    public void setEvent(int n) {
        this.replaceLongValue(n, 2);
    }

    public TimeStampFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != NDSSyntax.SYN_TIMESTAMP) {
            throw new IncompatibleComponentException();
        }
    }
}

