/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.ActionList;
import com.appframework.AppActionModel;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.ExtendedAction;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.resources.GWIcons;
import com.appframework.utils.OS;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public abstract class AppAction
extends ExtendedAction
implements MVCView {
    protected ActionList actionList;
    protected AppActionModel appActionModel;
    protected Object mvcModel;
    private boolean isTextVisible;
    private boolean selected = false;

    public AppAction(ActionList actionList, AppActionModel appActionModel) {
        super(appActionModel.getCaption(), appActionModel.getIcon());
        if (appActionModel.getIcon() == null && !OS.isMacOS()) {
            this.putValue("SmallIcon", GWIcons.EMPTY_ICON);
        }
        this.setToolTipText(appActionModel.getToolTipText());
        this.actionList = actionList;
        this.appActionModel = appActionModel;
        this.registerListeners();
        if (appActionModel == null) {
            throw new IllegalArgumentException();
        }
    }

    public AppActionModel getAppActionModel() {
        return this.appActionModel;
    }

    public ActionList getActionList() {
        return this.actionList;
    }

    public void setController(MVCController mVCController) {
        if (mVCController instanceof ApplicationFrameActionList) {
            this.actionList = (ApplicationFrameActionList)mVCController;
        }
    }

    public MVCController getController() {
        return this.actionList;
    }

    public void setMVCModel(Object object) {
        this.mvcModel = object;
    }

    public Object getMVCModel() {
        return this.mvcModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            this.performAction(actionEvent);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public JMenuItem getMenuItem() {
        JMenuItem jMenuItem = OS.createMenuItem(this);
        jMenuItem.setSelected(this.selected);
        return jMenuItem;
    }

    public JMenuItem getPopupMenuItem() {
        return this.getMenuItem();
    }

    public JMenu getMenu() {
        return null;
    }

    public JComponent getToolBarComponent() {
        return this.createActionButton();
    }

    public void disposeAction() {
        this.actionList = null;
    }

    protected void showWithText() {
        this.isTextVisible = true;
    }

    protected void performAction(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(null, "This action is not implemented yet", "", 1);
    }

    protected void registerListeners() {
    }

    protected String getUserGuid() {
        Component component = null;
        component = this.getActionList().getOwnerComponent();
        if (component instanceof ApplicationFrame) {
            return ((ApplicationFrame)component).getUserGuid();
        }
        throw new IllegalStateException("not ApplicationFrame");
    }

    protected AbstractButton createActionButton() {
        ToolBarButton toolBarButton = null;
        toolBarButton = new ToolBarButton(this);
        ((JComponent)toolBarButton).setToolTipText(this.getToolTipText());
        if (!this.isTextVisible) {
            toolBarButton.setText(null);
        }
        return toolBarButton;
    }
}

