/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.resources.StringResources;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class AppActionModel {
    private String name;
    private String caption;
    private String toolTipText;
    private KeyStroke mnemonic = null;
    private KeyStroke accelerator = null;
    private int mnemonicIndex = -1;
    private ImageIcon icon;
    private int type = 1;
    public static final int NORMAL = 1;
    public static final int CHECKABLE = 2;
    public static final int RADIO = 3;

    public AppActionModel(String string) {
        this(string, string);
    }

    public AppActionModel(String string, String string2) {
        this(string, string2, null);
    }

    public AppActionModel(String string, String string2, int n) {
        this(string, string2, null, n);
    }

    public AppActionModel(String string, String string2, ImageIcon imageIcon) {
        this(string, string2, string2, imageIcon, 1);
    }

    public AppActionModel(String string, String string2, ImageIcon imageIcon, int n) {
        this(string, string2, string2, imageIcon, n);
    }

    public AppActionModel(String string, String string2, String string3, ImageIcon imageIcon) {
        this(string, string2, string3, imageIcon, 1);
    }

    public AppActionModel(String string, String string2, String string3, ImageIcon imageIcon, int n) {
        this.name = string;
        if (!OS.isMacOS()) {
            this.mnemonicIndex = StringResources.getDisplayedMnemonicIndex(string2);
            this.mnemonic = KeyStroke.getKeyStroke(StringResources.getMnemonic(string2));
        }
        this.caption = string2;
        this.toolTipText = string3;
        this.icon = imageIcon;
        this.type = n;
    }

    public boolean isCheckable() {
        return this.type == 2;
    }

    public boolean isRadio() {
        return this.type == 3;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.accelerator = keyStroke;
    }

    public KeyStroke getMnemonic() {
        return this.mnemonic;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setName(String string) {
        this.name = string;
    }
}

