/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.cache.IdentifiedObject;
import com.appframework.filter.FiltersFactory;
import com.appframework.level.LevelManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.selection.SelectionManagersFactory;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionCancelFrame;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.AbstractOpenViewFrame;
import com.novell.gw.jclient.application.frames.addressbook.FrameAddressBook;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.options.WindowBoundsListener;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class Application
extends MVCController {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$Application == null ? (class$com$appframework$Application = Application.class$("com.appframework.Application")) : class$com$appframework$Application));
    protected static IDObjectsCollection appFrames = new IDObjectsCollection();
    static /* synthetic */ Class class$com$appframework$Application;

    public Application() {
        super(LevelManager.getInstance().getGlobalLevel(), null);
    }

    public static int getGWMainAppFramesCount() {
        int n = 0;
        for (int i = 0; i < appFrames.size(); ++i) {
            if (!(appFrames.getIDObjectAt(i) instanceof GWMainAppFrame)) continue;
            ++n;
        }
        return n;
    }

    public static int getGWFramesCount(Class clazz) {
        int n = 0;
        for (int i = 0; i < appFrames.size(); ++i) {
            try {
                if (!appFrames.getIDObjectAt(i).getClass().equals(clazz)) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                logger.debug((Object)exception, (Throwable)exception);
            }
        }
        return n;
    }

    public static Point[] getGWFrameCoords(Class clazz, ApplicationFrame applicationFrame) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < appFrames.size(); ++i) {
            try {
                if (!appFrames.getIDObjectAt(i).getClass().equals(clazz) || appFrames.getIDObjectAt(i) == applicationFrame) continue;
                arrayList.add(((ApplicationFrame)appFrames.getIDObjectAt(i)).getLocation());
                continue;
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                logger.debug((Object)exception, (Throwable)exception);
            }
        }
        return arrayList.toArray(new Point[0]);
    }

    static void addFrame(ApplicationFrame applicationFrame) {
        logger.debug((Object)("ADD FRAME TO APPLICATION FRAMES : [ " + applicationFrame.getClass().getName() + " " + applicationFrame.getName() + " ]"));
        appFrames.addIDObject(applicationFrame);
        applicationFrame.addComponentListener(new WindowBoundsListener(applicationFrame.getOptionFrameName()));
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
    }

    public static void removeFrame(ApplicationFrame applicationFrame) {
        logger.debug((Object)("REMOVE FRAME FROM APPLICATIONS FRAME : [ " + applicationFrame.getClass().getName() + " " + applicationFrame.getName() + " ]"));
        appFrames.removeIDObject(applicationFrame);
    }

    public static void disposeFrame(IDObjectsCollection iDObjectsCollection) {
        Iterator iterator = iDObjectsCollection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractItem)) continue;
            Application.disposeFrame((AbstractItem)e);
        }
    }

    public static void disposeFrame(AbstractItem abstractItem) {
        ApplicationFrame[] applicationFrameArray = Application.getFramesForItem(abstractItem);
        if (applicationFrameArray != null) {
            for (int i = 0; i < applicationFrameArray.length; ++i) {
                ApplicationFrame applicationFrame = applicationFrameArray[i];
                applicationFrame.setVisible(false);
                Application.disposeFrame(applicationFrame);
            }
        }
    }

    private static ApplicationFrame[] getFramesForItem(AbstractItem abstractItem) {
        if (abstractItem == null) {
            return null;
        }
        ArrayList<ApplicationFrame> arrayList = new ArrayList<ApplicationFrame>();
        int n = appFrames.size();
        for (int i = 0; i < n; ++i) {
            AbstractItem abstractItem2;
            ApplicationFrame applicationFrame;
            IdentifiedObject identifiedObject = appFrames.getIDObjectAt(i);
            if (identifiedObject instanceof AbstractOpenViewFrame) {
                applicationFrame = (AbstractOpenViewFrame)identifiedObject;
                abstractItem2 = ((AbstractOpenViewFrame)applicationFrame).getGwItem();
                if (!abstractItem2.getID().equals(abstractItem.getID())) continue;
                arrayList.add(applicationFrame);
                continue;
            }
            if (!(identifiedObject instanceof FrameCompose) || !(abstractItem2 = ((FrameCompose)(applicationFrame = (FrameCompose)identifiedObject)).getGwItem()).getID().equals(abstractItem.getID())) continue;
            arrayList.add(applicationFrame);
        }
        return arrayList.toArray(new ApplicationFrame[arrayList.size()]);
    }

    public static void disposeFrame(ApplicationFrame applicationFrame) {
        if (applicationFrame != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                Application.doDisposeForFrame(applicationFrame);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new RunDisposeFrame(applicationFrame));
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    logger.debug((Object)exception, (Throwable)exception);
                }
            }
        }
    }

    private static void doDisposeForFrame(ApplicationFrame applicationFrame) {
        GWToolBarPanel gWToolBarPanel;
        logger.debug((Object)("DO DISPOSE FRAME : [ " + applicationFrame.getClass().getName() + " " + applicationFrame.getName() + " ]"));
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
        GlobalCommand globalCommand = new GlobalCommand(490, applicationFrame);
        applicationFrame.getController().processCommand(globalCommand);
        Application.removeFrame(applicationFrame);
        SelectionManagersFactory.getInstance().releaseManager(applicationFrame.getAppActionList().getLevel());
        FiltersFactory.getInstance().releaseFilter(applicationFrame.getAppActionList().getLevel());
        LevelManager.getInstance().release(applicationFrame.getAppActionList().getLevel());
        logger.debug((Object)("REMOVE CHILD CONTROLLER FOR FRAME : [ " + applicationFrame.getClass().getName() + " " + applicationFrame.getName() + " ]"));
        applicationFrame.getAppActionList().removeAllActions();
        GWMenuBar gWMenuBar = applicationFrame.getGWMenuBar();
        if (gWMenuBar != null) {
            gWMenuBar.disposeMenus();
        }
        if ((gWToolBarPanel = applicationFrame.getToolBarPanel()) != null) {
            gWToolBarPanel.disposeToolBars();
        }
        applicationFrame.beforeDispose();
        applicationFrame.release();
        applicationFrame.dispose();
        applicationFrame = null;
        logger.debug((Object)("APPLICATION FRAMES SIZE : [ " + appFrames.size() + " ]"));
        System.runFinalization();
        System.gc();
    }

    public static ApplicationFrame getLastFrame(Class clazz) {
        int n = 0;
        for (int i = appFrames.size() - 1; i >= 0; --i) {
            if (appFrames.getIDObjectAt(i).getClass().equals(clazz)) {
                ++n;
            }
            if (n != 2) continue;
            return (ApplicationFrame)appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static FrameOpen getLastFrameOpen() {
        for (int i = appFrames.size() - 1; i >= 0; --i) {
            if (!(appFrames.getIDObjectAt(i) instanceof FrameOpen)) continue;
            return (FrameOpen)appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static FrameAddressBook getAddressBookFrame() {
        for (int i = 0; i < appFrames.size(); ++i) {
            if (!(appFrames.getIDObjectAt(i) instanceof FrameAddressBook)) continue;
            return (FrameAddressBook)appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static GWMainAppFrame getGWMainAppFrame() {
        for (int i = 0; i < appFrames.size(); ++i) {
            if (!(appFrames.getIDObjectAt(i) instanceof GWMainAppFrame)) continue;
            return (GWMainAppFrame)appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static FrameCalendar getFrameCalendar() {
        for (int i = 0; i < appFrames.size(); ++i) {
            if (!(appFrames.getIDObjectAt(i) instanceof FrameCalendar)) continue;
            return (FrameCalendar)appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static int getFramesCount() {
        return appFrames.size();
    }

    public static IDObjectsCollection getAllFrames() {
        return appFrames;
    }

    public static boolean closeAllFrames() {
        Serializable serializable;
        Object object;
        int n;
        ArrayList arrayList = appFrames.getKeys();
        ArrayList<ApplicationFrame> arrayList2 = new ArrayList<ApplicationFrame>();
        ArrayList<ApplicationFrame> arrayList3 = new ArrayList<ApplicationFrame>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (String)arrayList.get(n);
            serializable = (ApplicationFrame)appFrames.getIDObject((String)object);
            if (serializable instanceof FrameCompose) {
                arrayList2.add((ApplicationFrame)serializable);
                continue;
            }
            if (serializable instanceof GWMainAppFrame) {
                arrayList3.add((ApplicationFrame)serializable);
                continue;
            }
            ((Window)serializable).hide();
            Application.doDisposeForFrame((ApplicationFrame)serializable);
        }
        if (arrayList2.size() > 0) {
            for (n = 0; n < arrayList2.size(); ++n) {
                object = (FrameCompose)arrayList2.get(n);
                serializable = (ActionCancelFrame)((ApplicationFrame)object).getAppActionList().getAction("Cancel Frame");
                if (((ActionCancelFrame)serializable).doPerformAction()) continue;
                return false;
            }
        }
        if (arrayList3.size() > 0) {
            for (n = 0; n < arrayList3.size(); ++n) {
                object = (GWMainAppFrame)arrayList3.get(n);
                ((Window)object).hide();
                Application.doDisposeForFrame((ApplicationFrame)object);
            }
        }
        return true;
    }

    public static ApplicationFrame getActiveFrame() {
        for (int i = 0; i < appFrames.size(); ++i) {
            ApplicationFrame applicationFrame = (ApplicationFrame)appFrames.getIDObjectAt(i);
            if (!applicationFrame.isActive()) continue;
            return applicationFrame;
        }
        return null;
    }

    public static void disableFrames(IDObjectsCollection iDObjectsCollection) {
        Iterator iterator = iDObjectsCollection.iterator();
        while (iterator.hasNext()) {
            ApplicationFrame[] applicationFrameArray;
            Object e = iterator.next();
            if (!(e instanceof AbstractItem) || (applicationFrameArray = Application.getFramesForItem((AbstractItem)e)) == null) continue;
            for (int i = 0; i < applicationFrameArray.length; ++i) {
                ((ApplicationFrameActionList)applicationFrameArray[i].getController()).closeFrame();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RunDisposeFrame
    implements Runnable {
        private ApplicationFrame applicationFrame;

        public RunDisposeFrame(ApplicationFrame applicationFrame) {
            this.applicationFrame = applicationFrame;
        }

        public void run() {
            Application.doDisposeForFrame(this.applicationFrame);
        }
    }
}

