/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class NavBarButton
extends JToggleButton {
    private static Color DEFAULT_FOREGROUND_COLOR = new Color(0, 40, 98);
    private static Color PRESSED_FOREGROUND_COLOR = Color.WHITE;
    private ImageIcon[] backgroundImages = new ImageIcon[3];
    private ImageIcon[] rolloverBackgroundImages = new ImageIcon[3];
    private ImageIcon[] selectedBackgroundImages = new ImageIcon[3];
    private Color foregrondColor = this.getForeground();
    private Color rolloverForegroundColor = this.getForeground();
    private Color selectedForegroundColor = this.getForeground();

    public NavBarButton(String string) {
        super(string);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setFont(new Font(PLAFChanger.getFontName(), 0, 16));
        this.setForegrondColor(DEFAULT_FOREGROUND_COLOR);
        this.setRollOverBackgroundImages(ImageResources.ICON_NAV_BAR_ROLLOVER_LEFT_BORDER, ImageResources.ICON_NAV_BAR_ROLLOVER_BACKGROUND, ImageResources.ICON_NAV_BAR_ROLLOVER_RIGHT_BORDER);
        this.setRolloverForegroundColor(DEFAULT_FOREGROUND_COLOR);
        this.setSelectedBackgroundImages(ImageResources.ICON_NAV_BAR_SELECTED_LEFT_BORDER, ImageResources.ICON_NAV_BAR_SELECTED_BACKGROUND, ImageResources.ICON_NAV_BAR_SELECTED_RIGHT_BORDER);
        this.setSelectedForegroundColor(PRESSED_FOREGROUND_COLOR);
    }

    private void paintBackground(Graphics graphics, ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        int n;
        int n2 = this.getSize().width;
        int n3 = imageIcon != null ? imageIcon.getIconWidth() : 0;
        int n4 = imageIcon3 != null ? imageIcon3.getIconWidth() : 0;
        NavBarButton.fillWithImage(graphics, imageIcon, 0, n3, 0, this.getSize().height);
        if (n2 > n3 + n4) {
            n = n2 - (n3 + n4);
            NavBarButton.fillWithImage(graphics, imageIcon2, n3, n3 + n, 0, this.getSize().height);
        }
        if (n2 > n3) {
            n = n2 - n3;
            NavBarButton.fillWithImage(graphics, imageIcon3, n, n2, 0, this.getSize().height);
        }
    }

    public static void fillWithImage(Graphics graphics, ImageIcon imageIcon, int n, int n2, int n3, int n4) {
        if (graphics == null || imageIcon == null || imageIcon.getIconHeight() < 1 || imageIcon.getIconWidth() < 1 || n2 - n <= 0 || n4 - n3 <= 0) {
            return;
        }
        for (int i = n3; i < n4; i += imageIcon.getIconHeight()) {
            for (int j = n; j < n2; j += imageIcon.getIconWidth()) {
                graphics.drawImage(imageIcon.getImage(), j, i, null, null);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.getModel().isRollover() && !this.getModel().isSelected()) {
            this.setForeground(this.getRolloverForegroundColor());
            this.paintBackground(graphics, this.getRollOverBorderLeft(), this.getRollOverBackgroundImage(), this.getRollOverBorderRight());
        } else if (this.getModel().isSelected()) {
            this.setForeground(this.getSelectedForegroundColor());
            this.paintBackground(graphics, this.getSelectedBorderLeft(), this.getSelectedBackgroundImage(), this.getSelectedBorderRight());
        } else {
            this.setForeground(this.getForegrondColor());
            this.paintBackground(graphics, this.getBorderLeft(), this.getBackgroundImage(), this.getBorderRight());
        }
        super.paint(graphics);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getRollOverBackgroundImage() != null && this.getRollOverBackgroundImage().getIconHeight() > 0) {
            dimension.height = this.getRollOverBackgroundImage().getIconHeight();
        }
        return dimension;
    }

    public Color getForegrondColor() {
        return this.foregrondColor;
    }

    public void setForegrondColor(Color color) {
        this.foregrondColor = color;
    }

    public Color getRolloverForegroundColor() {
        return this.rolloverForegroundColor;
    }

    public void setRolloverForegroundColor(Color color) {
        this.rolloverForegroundColor = color;
    }

    public Color getSelectedForegroundColor() {
        return this.selectedForegroundColor;
    }

    public void setSelectedForegroundColor(Color color) {
        this.selectedForegroundColor = color;
    }

    public ImageIcon getBorderLeft() {
        return this.backgroundImages[0];
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImages[1];
    }

    public ImageIcon getBorderRight() {
        return this.backgroundImages[2];
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        this.backgroundImages[1] = imageIcon;
    }

    public void setBackgroundImages(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        this.backgroundImages[0] = imageIcon;
        this.backgroundImages[1] = imageIcon2;
        this.backgroundImages[2] = imageIcon3;
    }

    public void setBorders(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.backgroundImages[0] = imageIcon;
        this.backgroundImages[2] = imageIcon2;
    }

    public void setBorderLeft(ImageIcon imageIcon) {
        this.backgroundImages[0] = imageIcon;
    }

    public void setBorderRight(ImageIcon imageIcon) {
        this.backgroundImages[1] = imageIcon;
    }

    public ImageIcon getRollOverBorderLeft() {
        return this.rolloverBackgroundImages[0];
    }

    public ImageIcon getRollOverBackgroundImage() {
        return this.rolloverBackgroundImages[1];
    }

    public ImageIcon getRollOverBorderRight() {
        return this.rolloverBackgroundImages[2];
    }

    public void setRollOverBackgroundImage(ImageIcon imageIcon) {
        this.rolloverBackgroundImages[1] = imageIcon;
    }

    public void setRollOverBackgroundImages(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        this.rolloverBackgroundImages[0] = imageIcon;
        this.rolloverBackgroundImages[1] = imageIcon2;
        this.rolloverBackgroundImages[2] = imageIcon3;
    }

    public void setRollOverBorders(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.rolloverBackgroundImages[0] = imageIcon;
        this.rolloverBackgroundImages[2] = imageIcon2;
    }

    public void setRollOverBorderLeft(ImageIcon imageIcon) {
        this.rolloverBackgroundImages[0] = imageIcon;
    }

    public void setRollOverBorderRight(ImageIcon imageIcon) {
        this.rolloverBackgroundImages[1] = imageIcon;
    }

    public ImageIcon getSelectedBorderLeft() {
        return this.selectedBackgroundImages[0];
    }

    public ImageIcon getSelectedBackgroundImage() {
        return this.selectedBackgroundImages[1];
    }

    public ImageIcon getSelectedBorderRight() {
        return this.selectedBackgroundImages[2];
    }

    public void setSelectedBackgroundImage(ImageIcon imageIcon) {
        this.selectedBackgroundImages[1] = imageIcon;
    }

    public void setSelectedBackgroundImages(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3) {
        this.selectedBackgroundImages[0] = imageIcon;
        this.selectedBackgroundImages[1] = imageIcon2;
        this.selectedBackgroundImages[2] = imageIcon3;
    }

    public void setSelectedBorders(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.selectedBackgroundImages[0] = imageIcon;
        this.selectedBackgroundImages[2] = imageIcon2;
    }

    public void setSelectedBorderLeft(ImageIcon imageIcon) {
        this.selectedBackgroundImages[0] = imageIcon;
    }

    public void setSelectedBorderRight(ImageIcon imageIcon) {
        this.selectedBackgroundImages[1] = imageIcon;
    }
}

