/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.CustomizedButton;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipManager;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ToolBarButton
extends OrientableButton
implements CustomizedButton {
    private String displayText;
    private int iconPosition = 10;
    private boolean isTextVisible = true;
    private Insets insets = new Insets(5, 5, 5, 5);

    public ToolBarButton(AppAction appAction) {
        this.setAction(appAction);
        AppActionModel appActionModel = appAction.getAppActionModel();
        this.displayText = appActionModel.getCaption();
        this.init();
    }

    public ToolBarButton(Action action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.setAction(action);
        this.displayText = (String)action.getValue("Name");
        this.init();
    }

    public ToolBarButton(Action action, String string) {
        this(action);
        this.displayText = string;
        this.setText(this.displayText);
    }

    public ToolBarButton(Icon icon) {
        super(icon);
        this.init();
    }

    public ToolBarButton() {
        this.init();
    }

    protected void init() {
        this.setFocusable(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.addMouseListener(new ButtonMouseAdapter());
        this.getModel().setArmed(true);
        this.setMargin(this.insets);
        this.setOpaque(false);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getModel().setArmed(bl);
        this.setBorderPainted(bl);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMargin(Insets insets) {
        super.setMargin(insets);
        this.insets = insets;
    }

    public void setBorder(Border border) {
        Border border2 = GWBorder.NO_BORDER;
        if (border == GWBorder.LOWERED_BORDER || border == GWBorder.RAISED_BORDER) {
            border2 = border;
        }
        super.setBorder(border2);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public boolean isTextVisible() {
        return this.isTextVisible;
    }

    public void setDisplayText(String string) {
        this.displayText = string;
        this.setText(this.displayText);
    }

    public void setIconPosition(int n) {
        switch (this.iconPosition) {
            case 2: {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(4);
                this.iconPosition = n;
                break;
            }
            case 4: {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(2);
                this.iconPosition = n;
                break;
            }
            case 1: {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.iconPosition = n;
                break;
            }
            case 3: {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
                this.iconPosition = n;
            }
        }
        this.repaint();
    }

    public void setTextVisible(boolean bl) {
        this.isTextVisible = bl;
        this.setText(bl ? this.displayText : "");
    }

    public void setToolTipText(String string) {
        GWToolTipManager.setToolTipText(this, string);
    }

    protected void mouseEnter(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.setBorder(GWBorder.RAISED_BORDER);
        }
    }

    protected void mouseExit(MouseEvent mouseEvent) {
        this.getModel().setArmed(false);
        if (this.isEnabled()) {
            this.setBorder(GWBorder.NO_BORDER);
        }
    }

    protected void mousePress(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.isEnabled()) {
                this.setBorder(GWBorder.LOWERED_BORDER);
            } else {
                this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    protected void mouseRelease(MouseEvent mouseEvent) {
        ToolBarButton toolBarButton = this;
        if (this.isEnabled()) {
            if (0 <= mouseEvent.getX() && mouseEvent.getX() < toolBarButton.getSize().width && 0 <= mouseEvent.getY() && mouseEvent.getY() < toolBarButton.getSize().height) {
                ((JComponent)toolBarButton).setBorder(GWBorder.RAISED_BORDER);
            } else {
                ((JComponent)toolBarButton).setBorder(GWBorder.NO_BORDER);
            }
        } else {
            ((JComponent)toolBarButton).setBorder(GWBorder.NO_BORDER);
        }
    }

    public class ButtonMouseAdapter
    extends MouseAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            ToolBarButton.this.mouseEnter(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolBarButton.this.mouseExit(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolBarButton.this.mousePress(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ToolBarButton.this.mouseRelease(mouseEvent);
        }
    }
}

