/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.components.GWBorder;
import com.appframework.utils.UIUtils;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ToolBarToggleButton
extends JToggleButton {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$customizedbutton$ToolBarToggleButton == null ? (class$com$appframework$components$customizedbutton$ToolBarToggleButton = ToolBarToggleButton.class$("com.appframework.components.customizedbutton.ToolBarToggleButton")) : class$com$appframework$components$customizedbutton$ToolBarToggleButton));
    private Insets insets = new Insets(5, 5, 5, 5);
    static /* synthetic */ Class class$com$appframework$components$customizedbutton$ToolBarToggleButton;

    public ToolBarToggleButton(ImageIcon imageIcon) {
        this.setModel(new ToolBarToggleButtonModel());
        this.setIcon(imageIcon);
        this.init();
    }

    public ToolBarToggleButton(Action action) {
        this.setModel(new ToolBarToggleButtonModel());
        this.setAction(action);
        this.init();
    }

    public ButtonGroup getGroup() {
        return ((ToolBarToggleButtonModel)this.getModel()).getGroup();
    }

    protected void init() {
        this.setOpaque(false);
        this.getModel().setArmed(true);
        this.setFocusable(false);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.addMouseListener(new ButtonMouseAdapter());
        this.addChangeListener(new ButtonChangeListener());
        this.setBorder(GWBorder.NO_BORDER);
        this.setMargin(this.insets);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getModel().setArmed(false);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.setBorderPainted(!GWBorder.NO_BORDER.equals(border));
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMargin(Insets insets) {
        super.setMargin(insets);
        this.insets = insets;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ToolBarToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        ToolBarToggleButtonModel() {
        }

        public boolean isSelected() {
            if (this.getGroup() != null) {
                return this.getGroup().isSelected(this);
            }
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            } else if (this.isSelected() == bl) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }

    class ButtonChangeListener
    implements ChangeListener {
        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (ToolBarToggleButton.this.isSelected()) {
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            } else {
                ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        ButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolBarToggleButton.this.getModel().setArmed(false);
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.RAISED_BORDER);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolBarToggleButton.this.getModel().setArmed(true);
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                    return;
                }
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton toolBarToggleButton = ToolBarToggleButton.this;
            boolean bl = false;
            if (0 <= mouseEvent.getX() && mouseEvent.getX() < toolBarToggleButton.getSize().width && 0 <= mouseEvent.getY() && mouseEvent.getY() < toolBarToggleButton.getSize().height) {
                ((JComponent)toolBarToggleButton).setBorder(GWBorder.RAISED_BORDER);
            } else {
                ((JComponent)toolBarToggleButton).setBorder(GWBorder.NO_BORDER);
            }
        }
    }
}

