/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.ScrolledMozillaBrowser;
import com.appframework.components.htmleditor.ViewSourceFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLExternalViewerHyperlinkListener;
import com.novell.gw.jclient.application.dialogs.AboutWebRendererDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.webrenderer.IMozillaBrowserCanvas;
import com.webrenderer.event.BrowserAdapter;
import com.webrenderer.event.BrowserEvent;
import com.webrenderer.event.BrowserListener;
import com.webrenderer.event.KeyListener;
import com.webrenderer.event.MouseAdapter;
import com.webrenderer.event.MouseListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GWMozillaBrowser
extends ScrolledMozillaBrowser {
    Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$GWMozillaBrowser == null ? (class$com$appframework$components$htmleditor$GWMozillaBrowser = GWMozillaBrowser.class$("com.appframework.components.htmleditor.GWMozillaBrowser")) : class$com$appframework$components$htmleditor$GWMozillaBrowser));
    public static boolean SHOW_WEBRENDERER_ABOUT_DIALOG = false;
    private JPopupMenu browserPopupMenu;
    private MVCController controller;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$GWMozillaBrowser;

    public GWMozillaBrowser(IMozillaBrowserCanvas iMozillaBrowserCanvas, MVCController mVCController) {
        super(iMozillaBrowserCanvas);
        this.controller = mVCController;
        HTMLExternalViewerHyperlinkListener hTMLExternalViewerHyperlinkListener = new HTMLExternalViewerHyperlinkListener(mVCController);
        this.addBrowserListener(hTMLExternalViewerHyperlinkListener);
        this.addWindowListener(hTMLExternalViewerHyperlinkListener);
        this.addBrowserListener((BrowserListener)new HTMLExternalViewerStatusbarHyperlinkListener(mVCController));
        this.browser.addKeyListener((KeyListener)new GWMozillaBrowserKeyListener());
        this.browserPopupMenu = new BrowserPopupMenu();
        this.addMouseListener((MouseListener)new BrowserMouseListener());
        ((Component)this.browser).addFocusListener(new BrowserFocusListener());
    }

    private void processBrowserFocusedCommand(boolean bl) {
        GWMozillaBrowser gWMozillaBrowser = bl ? this : null;
        this.controller.processCommand(new Command(1330, gWMozillaBrowser));
    }

    private void checkWebRendererVerion() {
        if (SHOW_WEBRENDERER_ABOUT_DIALOG) {
            ApplicationFrame applicationFrame = ControlsUtils.getFrameForController(this.controller);
            AboutWebRendererDialog aboutWebRendererDialog = new AboutWebRendererDialog(applicationFrame);
            aboutWebRendererDialog.showMe();
            String string = GWBrowserFactory.getWebrendererVersion();
            OptionManager.getInstance().getGeneralOptions().setWebRendererVersion(string);
            OptionManager.getInstance().setGeneralOptions(OptionManager.getInstance().getGeneralOptions());
            SHOW_WEBRENDERER_ABOUT_DIALOG = false;
        }
    }

    public void loadURL(int n, String string, byte[] byArray, String string2, String string3) {
        super.loadURL(n, string, byArray, string2, string3);
        this.checkWebRendererVerion();
    }

    public void loadURL(String string) {
        super.loadURL(string);
        this.checkWebRendererVerion();
    }

    public void loadURL(URL uRL) {
        super.loadURL(uRL);
        this.checkWebRendererVerion();
    }

    public void loadHTML(String string, String string2) {
        super.loadHTML(string, string2);
        this.checkWebRendererVerion();
    }

    public void loadHTML(byte[] byArray, String string) {
        super.loadHTML(byArray, string);
        this.checkWebRendererVerion();
    }

    public void loadHTML(InputStream inputStream, String string) {
        super.loadHTML(inputStream, string);
        this.checkWebRendererVerion();
    }

    public void setPage(URL uRL) {
        super.setPage(uRL);
        this.checkWebRendererVerion();
    }

    public void setStyledText(String string) {
        super.setStyledText(string);
        this.checkWebRendererVerion();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class GWMozillaBrowserKeyListener
    implements KeyListener {
        private GWMozillaBrowserKeyListener() {
        }

        public void onKeyDown(com.webrenderer.event.KeyEvent keyEvent) {
        }

        public void onKeyUp(com.webrenderer.event.KeyEvent keyEvent) {
        }

        public void onKeyPress(com.webrenderer.event.KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 46 && (keyEvent.getModifiers() & 8) != 0) {
                KeyEvent keyEvent2 = new KeyEvent(GWMozillaBrowser.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), 127, '\u007f');
                SwingUtilities.processKeyBindings(keyEvent2);
            }
        }
    }

    private class ActionViewSource
    extends AbstractAction {
        public ActionViewSource() {
            super(StringResources.VIEW_SOURCE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ViewSourceFrame.display(GWMozillaBrowser.this.browser.getDocument().getDocumentSource());
        }
    }

    private class BrowserFocusListener
    implements FocusListener {
        private BrowserFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            GWMozillaBrowser.this.processBrowserFocusedCommand(true);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (FocusManager.getCurrentManager().getPermanentFocusOwner() == null && !(focusEvent.getOppositeComponent() instanceof JRootPane)) {
                GWMozillaBrowser.this.processBrowserFocusedCommand(false);
            }
        }
    }

    private class ActionBrowserPaste
    extends AbstractAction {
        public ActionBrowserPaste() {
            super(StringResources.PASTE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ActionBrowserCut
    extends AbstractAction {
        public ActionBrowserCut() {
            super(StringResources.CUT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ActionBrowserCopy
    extends AbstractAction {
        public ActionBrowserCopy() {
            super(StringResources.COPY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWMozillaBrowser.this.browser.copy();
        }
    }

    private class BrowserPopupMenu
    extends JPopupMenu {
        public BrowserPopupMenu() {
            if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
                this.setLightWeightPopupEnabled(false);
            }
            this.add(new JMenuItem(new ActionBrowserCut()));
            this.add(new JMenuItem(new ActionBrowserCopy()));
            this.add(new JMenuItem(new ActionBrowserPaste()));
            this.add(new JSeparator());
            this.add(new JMenuItem(new ActionViewSource()));
        }
    }

    private class BrowserMouseListener
    extends MouseAdapter {
        private BrowserMouseListener() {
        }

        public void onMouseDown(com.webrenderer.event.MouseEvent mouseEvent) {
            Component component = (Component)GWMozillaBrowser.this.browser;
            if (FocusManager.getCurrentManager().getPermanentFocusOwner() != GWMozillaBrowser.this.browser.getCanvas()) {
                component.requestFocusInWindow();
            } else {
                GWMozillaBrowser.this.processBrowserFocusedCommand(true);
            }
            if (OS.isRightMouseButton((MouseEvent)mouseEvent)) {
                JPopupMenu jPopupMenu = GWMozillaBrowser.this.browserPopupMenu;
                jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.repaint();
            } else if (GWMozillaBrowser.this.browserPopupMenu.isVisible()) {
                GWMozillaBrowser.this.browserPopupMenu.setVisible(false);
            }
        }
    }

    private class HTMLExternalViewerStatusbarHyperlinkListener
    extends BrowserAdapter {
        private MVCController controller;

        public HTMLExternalViewerStatusbarHyperlinkListener(MVCController mVCController) {
            this.controller = mVCController;
        }

        public void onLinkChange(BrowserEvent browserEvent) {
            Command command = new Command(630, browserEvent.getLink());
            this.controller.processCommand(command);
        }
    }
}

