/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.CustomFont;
import com.appframework.components.htmleditor.RTFDocument;
import com.appframework.utils.OS;
import java.awt.Font;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.rtf.RTFEditorKit;

public class GwRTFEditorKit
extends RTFEditorKit {
    private int mode;
    private static final ViewFactory defaultFactory = new GwViewFactory();

    public GwRTFEditorKit(int n) {
        this.mode = n;
    }

    public Document createDefaultDocument() {
        return new RTFDocument(this.mode);
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    private static class GwViewFactory
    implements ViewFactory {
        private GwViewFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new GwLabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new GwLabelView(element);
        }
    }

    private static class GwLabelView
    extends LabelView {
        public GwLabelView(Element element) {
            super(element);
        }

        public Font getFont() {
            Font font = super.getFont();
            if ((OS.isLinuxOS() || OS.isWinOS()) && font != null && !(font instanceof CustomFont)) {
                font = new CustomFont(font.getFontName(), font.getStyle(), font.getSize());
            }
            return font;
        }
    }
}

