/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.HTMLExternalTextViewerController;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.webrenderer.event.BrowserListener;
import com.webrenderer.event.NetworkAdapter;
import com.webrenderer.event.NetworkEvent;
import com.webrenderer.event.NetworkListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.security.InvalidParameterException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class HTMLExternalTextViewer
extends HTMLViewer
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLExternalTextViewer == null ? (class$com$appframework$components$htmleditor$HTMLExternalTextViewer = HTMLExternalTextViewer.class$("com.appframework.components.htmleditor.HTMLExternalTextViewer")) : class$com$appframework$components$htmleditor$HTMLExternalTextViewer));
    private static final int MIN_ZOOM_STEPS = -5;
    private static final int MAX_ZOOM_STEPS = 5;
    private static final String BROWSER = "Browser";
    private static final String MESSAGE_VIEWER = "Message Viewer";
    private GWMozillaBrowser browser;
    private HTMLTextViewer simpleMessageViewer;
    private int mode = -1;
    private int currentZoom = 0;
    private CardLayout cardLayout;
    private MVCController controller;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLExternalTextViewer;

    public HTMLExternalTextViewer(MVCController mVCController) {
        this.controller = new HTMLExternalTextViewerController(this, mVCController);
        this.setFocusable(false);
        this.buildUI(this.controller);
    }

    private void buildUI(MVCController mVCController) {
        this.browser = GWBrowserFactory.spawnGWMozilla(mVCController);
        this.browser.addNetworkListener((NetworkListener)new MozillaBrowserDocumentLoadListener());
        this.simpleMessageViewer = new HTMLTextViewer();
        this.simpleMessageViewer.setMode(2);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
    }

    public void addBrowserHyperlinkListener(BrowserListener browserListener) {
        this.browser.addBrowserListener(browserListener);
    }

    public void addRTFViewerMouseListeners(MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        this.simpleMessageViewer.getTextComponent().addMouseListener(mouseListener);
        this.simpleMessageViewer.getTextComponent().addMouseMotionListener(mouseMotionListener);
    }

    public void setMode(int n) {
        if (n == 2 && this.mode != 2) {
            logger.debug((Object)"Set RTF view mode");
            this.mode = n;
            if (this.browser.isVisible()) {
                this.browser.setVisible(false);
            }
            if (!this.contains(this.simpleMessageViewer)) {
                this.add((Component)this.simpleMessageViewer, MESSAGE_VIEWER);
            }
            this.cardLayout.show(this, MESSAGE_VIEWER);
        } else if (n == 1 && this.mode != 1) {
            logger.debug((Object)"Set HTML view mode");
            this.mode = n;
            if (!this.contains(this.browser)) {
                this.add((Component)this.browser, BROWSER);
            }
            this.cardLayout.show(this, BROWSER);
        }
    }

    private boolean contains(Component component) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = componentArray[i];
            if (component2 != component) continue;
            return true;
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPage(URL uRL) {
        if (this.mode != 1) {
            throw new InvalidParameterException("Invalid mode: [" + this.mode + "]");
        }
        logger.debug((Object)("Set HTML page: [" + uRL + "]"));
        this.browser.setPage(uRL);
    }

    public void setDragEnabled(boolean bl) {
        if (this.mode == 2) {
            this.simpleMessageViewer.setDragEnabled(bl);
        }
    }

    public void setCaretPosition(int n) {
        if (this.mode == 2) {
            this.simpleMessageViewer.setCaretPosition(n);
        }
    }

    public void setPlainText(String string) {
        if (this.mode == 2) {
            logger.debug((Object)"Set RTF plain test");
            this.simpleMessageViewer.setPlainText(string);
        } else if (this.mode == 1) {
            logger.debug((Object)"Set HTML plain test");
            this.setStyledText(UIUtils.wrapIntoHTML(string));
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + "]");
        }
    }

    public void setStyledText(String string) {
        if (this.mode == 2) {
            logger.debug((Object)"Set RTF text");
            this.simpleMessageViewer.setStyledText(string);
        } else if (this.mode == 1) {
            logger.debug((Object)"Set HTML text");
            this.browser.setStyledText(string);
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + "]");
        }
    }

    public void clear() {
        if (this.mode == 2) {
            this.simpleMessageViewer.clear();
        } else if (this.mode == 1) {
            this.browser.clear();
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + "]");
        }
    }

    public JTextComponent getTextComponent() {
        if (this.mode == 2 || this.mode == 3) {
            return this.simpleMessageViewer.getTextComponent();
        }
        throw new RuntimeException("Invalid component state. Use external brawser: [" + GWClient.USE_EXTERNAL_HTML_VIEWER() + "], " + "mode: [" + this.mode + "]");
    }

    public void zoom(boolean bl) {
        if (this.mode == 2) {
            this.simpleMessageViewer.zoom(bl);
        } else if (this.mode == 1) {
            if (bl && this.currentZoom < 5) {
                this.browser.increaseTextZoom();
                ++this.currentZoom;
            } else if (!bl && this.currentZoom > -5) {
                this.browser.decreaseTextZoom();
                --this.currentZoom;
            }
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + "]");
        }
    }

    public void resetZoom() {
        if (this.mode == 2) {
            this.simpleMessageViewer.resetZoom();
        } else if (this.mode == 1) {
            if (this.currentZoom > 0) {
                while (this.currentZoom > 0) {
                    this.browser.decreaseTextZoom();
                    --this.currentZoom;
                }
            } else if (this.currentZoom < 0) {
                while (this.currentZoom < 0) {
                    this.browser.increaseTextZoom();
                    ++this.currentZoom;
                }
            }
        } else {
            throw new RuntimeException("Invalid mode: [" + this.mode + "]");
        }
    }

    public void refreshTabs() {
        if (this.mode == 2) {
            this.browser.setVisible(true);
            this.browser.setVisible(false);
        }
    }

    public Component getBrowser() {
        return (Component)this.browser.getBrowser();
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return null;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MozillaBrowserDocumentLoadListener
    extends NetworkAdapter {
        private MozillaBrowserDocumentLoadListener() {
        }

        public void onDocumentComplete(NetworkEvent networkEvent) {
            HTMLExternalTextViewer.this.browser.setMargins(5, 5, 5, 5);
        }
    }
}

