/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLStyledDocument;
import com.appframework.components.htmleditor.HTMLStyledWriter;
import com.appframework.components.htmleditor.StyledHTMLFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;

public class HTMLStyledEditorKit
extends HTMLEditorKit {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLStyledEditorKit == null ? (class$com$appframework$components$htmleditor$HTMLStyledEditorKit = HTMLStyledEditorKit.class$("com.appframework.components.htmleditor.HTMLStyledEditorKit")) : class$com$appframework$components$htmleditor$HTMLStyledEditorKit));
    private static final String DEFAULT_CSS = "html_def.css";
    protected StyledHTMLFactory myFactory = new StyledHTMLFactory();
    boolean editMode = false;
    private static final String ATTRIBUTE_TRACKER_CLASS_NAME = "javax.swing.text.StyledEditorKit$AttributeTracker";
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLStyledEditorKit;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLStyledDocument;

    public HTMLStyledEditorKit() {
        this(false);
    }

    public HTMLStyledEditorKit(boolean bl) {
        this.editMode = bl;
    }

    public Document createDefaultDocument() {
        HTMLStyledDocument hTMLStyledDocument = new HTMLStyledDocument(this.getDefaultStyleSheet(), this.editMode);
        hTMLStyledDocument.setParser(this.getParser());
        hTMLStyledDocument.setAsynchronousLoadPriority(4);
        hTMLStyledDocument.setTokenThreshold(100);
        hTMLStyledDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        return hTMLStyledDocument;
    }

    public StyleSheet getDefaultStyleSheet() {
        StyleSheet styleSheet = new StyleSheet();
        try {
            InputStream inputStream = (class$com$appframework$components$htmleditor$HTMLStyledDocument == null ? (class$com$appframework$components$htmleditor$HTMLStyledDocument = HTMLStyledEditorKit.class$("com.appframework.components.htmleditor.HTMLStyledDocument")) : class$com$appframework$components$htmleditor$HTMLStyledDocument).getResourceAsStream(DEFAULT_CSS);
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                styleSheet.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)("Can not load default CSS: " + iOException.getMessage()), (Throwable)iOException);
        }
        return styleSheet;
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        try {
            super.read(reader, document, n);
            document.putProperty("AdditionalComments", null);
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        catch (ChangedCharSetException changedCharSetException) {
            if (changedCharSetException.getCharSetSpec().indexOf("UTF-16") >= 0) {
                ChangedCharSetException changedCharSetException2 = new ChangedCharSetException("UTF-8", true);
                throw changedCharSetException2;
            }
            throw changedCharSetException;
        }
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLStyledDocument) {
            HTMLStyledWriter hTMLStyledWriter = new HTMLStyledWriter(writer, (HTMLDocument)document, n, n2);
            hTMLStyledWriter.write();
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        CaretListener[] caretListenerArray = jEditorPane.getCaretListeners();
        boolean bl = false;
        for (int i = 0; i < caretListenerArray.length; ++i) {
            CaretListener caretListener = caretListenerArray[i];
            if (!ATTRIBUTE_TRACKER_CLASS_NAME.equals(caretListener.getClass().getName())) continue;
            jEditorPane.removeCaretListener(caretListener);
            bl = true;
        }
        if (bl) {
            jEditorPane.addCaretListener(new AttributeTracker());
        } else {
            logger.error((Object)"javax.swing.text.StyledEditorKit$AttributeTracker location(inplementation) changed");
        }
        bl = false;
        PropertyChangeListener[] propertyChangeListenerArray = jEditorPane.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[i];
            if (!ATTRIBUTE_TRACKER_CLASS_NAME.equals(propertyChangeListener.getClass().getName())) continue;
            jEditorPane.removePropertyChangeListener(propertyChangeListener);
            bl = true;
        }
        if (bl) {
            jEditorPane.addPropertyChangeListener(new AttributeTracker());
        } else {
            logger.error((Object)"javax.swing.text.StyledEditorKit$AttributeTracker location(inplementation) changed");
        }
    }

    public void deinstall(JEditorPane jEditorPane) {
        super.deinstall(jEditorPane);
    }

    public ViewFactory getViewFactory() {
        return this.myFactory;
    }

    public Action[] getActions() {
        if (!this.editMode) {
            Action[] actionArray = super.getActions();
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                Object object = action.getValue("Name");
                if ("caret-up".equals(object) || "caret-down".equals(object)) continue;
                arrayList.add(action);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
        return super.getActions();
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        if (element.getDocument().getLength() == 0) {
            String string = StyleConstants.getFontFamily(mutableAttributeSet);
            int n = StyleConstants.getFontSize(mutableAttributeSet);
            boolean bl = StyleConstants.isBold(mutableAttributeSet);
            boolean bl2 = StyleConstants.isItalic(mutableAttributeSet);
            boolean bl3 = StyleConstants.isUnderline(mutableAttributeSet);
            super.createInputAttributes(element, mutableAttributeSet);
            StyleConstants.setFontFamily(mutableAttributeSet, string);
            StyleConstants.setFontSize(mutableAttributeSet, n);
            StyleConstants.setBold(mutableAttributeSet, bl);
            StyleConstants.setItalic(mutableAttributeSet, bl2);
            StyleConstants.setUnderline(mutableAttributeSet, bl3);
        } else {
            super.createInputAttributes(element, mutableAttributeSet);
        }
    }

    public MutableAttributeSet getInputAttributes() {
        MutableAttributeSet mutableAttributeSet = super.getInputAttributes();
        if (mutableAttributeSet.getAttribute(StyleConstants.FontFamily) == null) {
            String string = HTMLConstants.getDefaultFontName(1, this.editMode);
            int n = HTMLConstants.getDefaultFontSize(1, this.editMode);
            StyleConstants.setFontFamily(mutableAttributeSet, string);
            StyleConstants.setFontSize(mutableAttributeSet, n);
        }
        return mutableAttributeSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AttributeTracker
    implements CaretListener,
    PropertyChangeListener,
    Serializable {
        private Element currentParagraph;
        private Element currentRun;

        AttributeTracker() {
        }

        void updateInputAttributes(int n, int n2, JTextComponent jTextComponent, boolean bl) {
            Element element;
            Document document = jTextComponent.getDocument();
            if (!(document instanceof StyledDocument)) {
                return;
            }
            int n3 = Math.min(n, n2);
            StyledDocument styledDocument = (StyledDocument)document;
            this.currentParagraph = styledDocument.getParagraphElement(n3);
            if (this.currentParagraph.getStartOffset() == n3 || n != n2) {
                if (bl && n3 == styledDocument.getLength() && n3 > 0 && (this.currentRun == null || this.currentRun.getStartOffset() != this.currentRun.getEndOffset())) {
                    --n3;
                }
                element = styledDocument.getCharacterElement(n3);
            } else {
                element = styledDocument.getCharacterElement(Math.max(n3 - 1, 0));
            }
            if (element != this.currentRun) {
                this.currentRun = element;
                HTMLStyledEditorKit.this.createInputAttributes(this.currentRun, HTMLStyledEditorKit.this.getInputAttributes());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getSource();
            if (object2 instanceof JTextComponent && object instanceof Document) {
                this.updateInputAttributes(0, 0, (JTextComponent)object2, false);
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.updateInputAttributes(caretEvent.getDot(), caretEvent.getMark(), (JTextComponent)caretEvent.getSource(), true);
        }
    }
}

