/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.novell.gw.jclient.application.actions.edit.text.TextZoomer;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class HTMLTextComponent
extends HTMLViewer {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLTextComponent == null ? (class$com$appframework$components$htmleditor$HTMLTextComponent = HTMLTextComponent.class$("com.appframework.components.htmleditor.HTMLTextComponent")) : class$com$appframework$components$htmleditor$HTMLTextComponent));
    protected HTMLTextPane htmlTextPane;
    protected DirtyStateManager dirtyStateManager;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLTextComponent;

    public HTMLTextComponent(DirtyStateManager dirtyStateManager) {
        this.dirtyStateManager = dirtyStateManager;
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1, 20));
        this.setMinimumSize(new Dimension(1, 20));
        this.htmlTextPane = new ViewHTMLTextPane();
        this.htmlTextPane.setPreferredSize(new Dimension(1, 20));
        this.htmlTextPane.setMinimumSize(new Dimension(1, 20));
        this.add((Component)new EditableTextComponent(this.htmlTextPane, null), "Center");
    }

    public String getStyledText() {
        String string = "";
        try {
            Document document = this.htmlTextPane.getDocument();
            Object object = document.getProperty("title");
            if (object == null) {
                document.putProperty("title", "Default Title");
            }
            string = this.htmlTextPane.getStyledText();
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        return string;
    }

    public void setStyledText(String string) {
        this.htmlTextPane.setStyledText(string);
    }

    public void clear() {
        this.htmlTextPane.setStyledText("");
    }

    public String getPlainText() {
        return this.htmlTextPane.getPlainText();
    }

    public void setPlainText(String string) {
        this.htmlTextPane.setPlainText(string);
        this.htmlTextPane.insertLinks();
    }

    public void setPage(URL uRL) {
        try {
            this.htmlTextPane.setPage(uRL);
            this.htmlTextPane.insertLinks();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    public int getMode() {
        return this.htmlTextPane.getMode();
    }

    public void setMode(int n) {
        this.htmlTextPane.setMode(n);
    }

    public void zoom(boolean bl) {
        TextZoomer.zoom(this.htmlTextPane, bl);
    }

    public void resetZoom() {
    }

    public void setDragEnabled(boolean bl) {
        this.htmlTextPane.setDragEnabled(bl);
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.htmlTextPane.addHyperlinkListener(hyperlinkListener);
    }

    public void setEnabled(boolean bl) {
        this.htmlTextPane.setEnabled(bl);
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.htmlTextPane.addKeyListener(keyListener);
    }

    public boolean isEnabled() {
        return this.htmlTextPane.isEnabled();
    }

    public int getCaretPosition() {
        return this.htmlTextPane.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this.htmlTextPane.setCaretPosition(n);
    }

    public void setEditable(boolean bl) {
        this.htmlTextPane.setEditable(bl);
    }

    public Document getDocument() {
        return this.htmlTextPane.getDocument();
    }

    public JTextComponent getTextComponent() {
        return this.htmlTextPane;
    }

    public void grabFocus() {
        this.htmlTextPane.grabFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

