/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import azcheck.ui.JSpellDialog;
import azcheck.ui.JTextAutoSpellCheck;
import com.appframework.SCMouseListener;
import com.appframework.components.htmleditor.GwRTFEditorKit;
import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLStyledEditorKit;
import com.appframework.components.htmleditor.HTMLTransferHandler;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.components.htmleditor.hyperlink.Link;
import com.appframework.components.htmleditor.hyperlink.LinkFinder;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.FontKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextPane;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDocumentListener;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import org.apache.log4j.Logger;

public abstract class HTMLTextPane
extends OrientableTextPane {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLTextPane == null ? (class$com$appframework$components$htmleditor$HTMLTextPane = HTMLTextPane.class$("com.appframework.components.htmleditor.HTMLTextPane")) : class$com$appframework$components$htmleditor$HTMLTextPane));
    public static final String LINK_ATTR = "hyperlink";
    public static final String DELETE_NEXT_WORD_ACTION = "delete-next-word";
    public static final String DELETE_PREV_WORD_ACTION = "delete-prev-word";
    private static final int TEST_SCREEN_RESOLUTION = -1;
    private static char BROKEN_HYPHEN = (char)8209;
    private static final String PATTERN_HTTP_PROTOCOL = "((([Hh][Tt])|([Ff]))[Tt][Pp]([Ss])?://)";
    private static final String PATTERN_MAILTO_PROTOCOL = "([Mm][Aa][Ii][Ll][Tt][Oo]:)";
    private static final String PATTERN_USER = "([\\$A-Za-z0-9_\\.\\-\u2011~]+)";
    private static final String PATTERN_PASSWORD = "((:\\S*)?)";
    private static final String PATTERN_HOSTNAME = "([A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)";
    private static final String PATTERN_HTTP_HOSTNAME = "(((([Ww][Ww][Ww])|([Ff][Tt][Pp]))\\.)[A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)";
    private static final String PATTERN_PORT = "(:\\d{1,5})";
    private static final String PATTERN_PATH = "(((/|\\\\)[A-Za-z0-9_\\.\\-" + BROKEN_HYPHEN + "\\$\u2011~\\%!]*)*)";
    private static final String PATTERN_NAME = "([A-Za-z0-9_\\.\\-\\$]+)";
    private static final String PATTERN_VALUE = "([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*)";
    private static final String PATTERN_QUERY_WITH_COMMA = "([A-Za-z0-9_,\\.\\-\\$]+)";
    private static final String PATTERN_QUERY_STRING = "((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)|((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)|([A-Za-z0-9_,\\.\\-\\$]+)))";
    private static final String PATTERN_WWW_LINK = "((([\\$A-Za-z0-9_\\.\\-\u2011~]+)((:\\S*)?)@)?(((([Ww][Ww][Ww])|([Ff][Tt][Pp]))\\.)[A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)(:\\d{1,5})?" + PATTERN_PATH + "?(\\#" + "([A-Za-z0-9_\\.\\-\\$]+)" + ")?(\\?" + "((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)|((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)|([A-Za-z0-9_,\\.\\-\\$]+)))" + "?)?)";
    private static final String PATTERN_HTTP_LINK = PATTERN_WWW_LINK + "|(" + "((([Hh][Tt])|([Ff]))[Tt][Pp]([Ss])?://)" + "(" + "([\\$A-Za-z0-9_\\.\\-\u2011~]+)" + "((:\\S*)?)" + "@)?" + "([A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)" + "(:\\d{1,5})" + "?" + PATTERN_PATH + "?(\\#" + "([A-Za-z0-9_\\.\\-\\$]+)" + ")?(\\?" + "((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)|((((([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))*)(\\&([A-Za-z0-9_\\.\\-\\$]+)=([A-Za-z0-9_@\\+\\.\\-\\$\u2011~\\%\\#\\;:/,]*))+)|([A-Za-z0-9_,\\.\\-\\$]+)))" + "?)?)";
    private static final String PATTERN_EMAIL = "((([\\$A-Za-z0-9_\\.\\-\u2011~]+)((:\\S*)?)@)([A-Za-z0-9_\\-\\$\u2011~!]+(\\.[A-Za-z0-9_\\-\\$\u2011~!]+)*)(:\\d{1,5})?" + PATTERN_PATH + "?)";
    private static final String PATTERN_EMAIL_LIST = "(" + PATTERN_EMAIL + "((\\,|\\;)" + PATTERN_EMAIL + ")*)";
    private static final String PATTERN_MAIL_LINK = "(([Mm][Aa][Ii][Ll][Tt][Oo]:)?" + PATTERN_EMAIL_LIST + "([\\S&&[^<>]]*))";
    private static final String PATTERN_LINK = "(" + PATTERN_HTTP_LINK + ")|(" + PATTERN_MAIL_LINK + ")";
    private static Pattern patternHyperlink = Pattern.compile(PATTERN_LINK);
    protected int mode = -1;
    private EditableDocumentListener editableDocumentListener;
    private LinkRecognizerDocumentListener linkRecognizerDocumentListener = new LinkRecognizerDocumentListener();
    private UndoableEditListener undoableEditListener;
    private SCMouseListener spellCheckListener = new SCMouseListener();
    private boolean ignoreDefaultFontAttributes = false;
    private static Hashtable fontTable = new Hashtable();
    private FontKey fontKey = new FontKey(null, 0, 0);
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLTextPane;
    static /* synthetic */ Class class$java$awt$Font;

    public HTMLTextPane() {
        this.setFocusable(true);
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "goToPrevComponent");
        this.getActionMap().put("goToPrevComponent", new AbstractAction("goToPrevComponent"){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = HTMLTextPane.this.getFocusTraversalPolicy().getComponentBefore(ControlsUtils.getWindowForComponent(HTMLTextPane.this), HTMLTextPane.this);
                component.requestFocus();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "goToNextComponent");
        this.getActionMap().put("goToNextComponent", new AbstractAction("goToNextComponent"){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = HTMLTextPane.this.getFocusTraversalPolicy().getComponentAfter(ControlsUtils.getWindowForComponent(HTMLTextPane.this), HTMLTextPane.this);
                component.requestFocus();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.setTransferHandler(new HTMLTransferHandler(this.getTransferHandler()));
        this.setDragEnabled(true);
    }

    public String getSelectedText() {
        String string = super.getSelectedText();
        if (string != null) {
            string = string.replaceAll("\u00a0", " ");
        }
        return string;
    }

    public URL getPage() {
        return null;
    }

    public StyledEditorKit createEditorKit(int n) {
        StyledEditorKit styledEditorKit = null;
        if (n == 1) {
            styledEditorKit = new HTMLStyledEditorKit(this.isEditable());
        } else if (n == 2 || n == 3) {
            styledEditorKit = new GwRTFEditorKit(n);
        }
        if (this.isEditable()) {
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 128), DELETE_PREV_WORD_ACTION);
            this.getActionMap().put(DELETE_PREV_WORD_ACTION, new DeletePrevWordAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 128), DELETE_NEXT_WORD_ACTION);
            this.getActionMap().put(DELETE_NEXT_WORD_ACTION, new DeleteNextWordAction());
            this.getInputMap().put(KeyStroke.getKeyStroke(8, 64), "delete-previous");
        }
        return styledEditorKit;
    }

    public int getMode() {
        return this.mode;
    }

    public String getDefaultFontName() {
        return HTMLConstants.getDefaultFontName(this.getMode(), this.isEditable());
    }

    public int getDefaultFontSize() {
        return HTMLConstants.getDefaultFontSize(this.getMode(), this.isEditable());
    }

    public void setDefaultFont(String string, int n) {
        HTMLUtils.setDefaultFont(this, string, n);
    }

    public void setDefaultFont() {
        this.setDefaultFont(this.getDefaultFontName(), this.getDefaultFontSize());
    }

    public synchronized void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            this.unregisterListeners(this.getDocument());
            this.setEditorKit(this.createEditorKit(n));
            if (this.isEditable()) {
                this.setDefaultFont();
            }
            this.registerListeners(this.getDocument());
        }
    }

    public void applyHTMLParagraphAttributes() {
        StyledDocument styledDocument = (StyledDocument)this.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        styledDocument.setParagraphAttributes(0, this.getDocument().getLength(), simpleAttributeSet, false);
    }

    public void setCaretPosition(int n) {
        int n2 = n;
        if (n > this.getDocument().getLength() || n < 0) {
            n2 = this.getDocument().getLength();
        }
        super.setCaretPosition(n2);
    }

    private int getStartPosition(Element element) {
        HTML.Tag tag = HTMLUtils.getNameAttribute(element);
        if (tag == HTML.Tag.BODY) {
            return element.getStartOffset();
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            int n = this.getStartPosition(element2);
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    public void setEditableDocumentListener(EditableDocumentListener editableDocumentListener) {
        this.editableDocumentListener = editableDocumentListener;
    }

    public void setUndoableListener(UndoableEditListener undoableEditListener) {
        this.undoableEditListener = undoableEditListener;
    }

    public void clear() {
        try {
            this.putClientProperty("charset", "utf-8");
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
        }
    }

    public void setPage(URL uRL) throws IOException {
        HTMLUtils.removeEscapeChars(uRL);
        this.clear();
        super.setPage(uRL);
    }

    public void setDocument(Document document) {
        this.unregisterListeners(this.getDocument());
        super.setDocument(document);
    }

    public String getStyledText() {
        return HTMLUtils.getStyledText(this);
    }

    public String getPlainText() {
        return HTMLUtils.getPlainText(this);
    }

    private String normalizeText(String string) {
        int n = this.getMode();
        if (n == 2 || n == 3) {
            string = string.replaceAll("\\\\line", "\\\\par");
            string = this.recognizeRtfLinks(string);
            string = this.removeBrokenHyphenRTF(string);
            return this.replaceFonts(string);
        }
        if (n == 1) {
            string = HTMLUtils.replaceTags(string, "span", "div");
        }
        return string;
    }

    private String removeBrokenHyphenRTF(String string) {
        Pattern pattern = Pattern.compile("((\\\\)*)\\\\_");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.length() % 4 != 0) continue;
            matcher.appendReplacement(stringBuffer, string2 + "-");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String replaceFonts(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("{\\stylesheet{\\fs");
        int n2 = this.getDefaultFontSize();
        if (n != -1) {
            int n3 = stringBuffer.indexOf("GroupWiseView;}");
            Integer n4 = HTMLTextPane.getInteger(n + "{\\stylesheet{\\fs".length(), stringBuffer.toString());
            if (n4 == null) {
                return stringBuffer.toString();
            }
            int n5 = n4 / 2;
            int n6 = n3;
            while ((n6 = stringBuffer.indexOf("\\fs", n6)) != -1) {
                if (stringBuffer.charAt(n6 - 1) != '\\') {
                    n4 = HTMLTextPane.getInteger(n6 += 3, stringBuffer.toString());
                    if (n4 == null) continue;
                    int n7 = n4 / 2;
                    int n8 = Math.round((float)n2 * ((float)n7 / (float)n5)) * 2;
                    stringBuffer.replace(n6, n6 + n4.toString().length(), Integer.toString(n8));
                    continue;
                }
                n6 += 3;
            }
        }
        return stringBuffer.toString();
    }

    private static Integer getInteger(int n, String string) {
        int n2 = 0;
        while (Character.isDigit(string.charAt(n + n2))) {
            ++n2;
        }
        if (n2 != 0) {
            return Integer.valueOf(string.substring(n, n + n2));
        }
        return null;
    }

    private String recognizeRtfLinks(String string) {
        try {
            int n = -1;
            while ((n = string.indexOf("{\\*\\fldinst", n + 1)) > 0) {
                int n2;
                int n3;
                int n4;
                Matcher matcher;
                int n5 = string.indexOf("HYPERLINK", n);
                int n6 = string.indexOf("}", n);
                if (n5 <= 0 || n5 >= n6 || !(matcher = patternHyperlink.matcher(string.substring(n5))).find()) continue;
                String string2 = matcher.group(0);
                int n7 = string.indexOf("{\\fldrslt", n5);
                if (n7 <= 0 || (n4 = string.indexOf("}", n7)) <= 0 || (n3 = string.indexOf(" ", n2 = string.lastIndexOf("\\", n4))) <= 0 || n3 > n4) continue;
                String string3 = string.substring(n3 + 1, n4);
                if (!string3.equals(string2)) {
                    string3 = string3 + " <" + string2 + ">";
                }
                int n8 = string.lastIndexOf("{\\field", n);
                int n9 = string.indexOf("}", string.indexOf("}", n4 + 1) + 1);
                if (n8 <= 0 || n9 <= n8) continue;
                string = string.substring(0, n8) + " " + string3 + string.substring(n9 + 1);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception, (Throwable)exception);
        }
        return string;
    }

    private void forceDefaultFontAttributes() {
        MachineSettings.TextOption textOption;
        String string;
        if (this.getMode() != 1 && !this.isEditable() && (string = (textOption = OptionManager.getInstance().getTextOption()).getDefaultReadPlainTextFont()) != null && !string.trim().equals("")) {
            Font font = new Font(this.getDefaultFontName(), 0, this.getDefaultFontSize());
            if (this.getMode() == 2 || this.getMode() == 3) {
                StyledDocument styledDocument = this.getStyledDocument();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
                ((StyledEditorKit)this.getEditorKit()).getInputAttributes().addAttributes(simpleAttributeSet);
            }
        }
    }

    public void setRTFTextFont(Font font) {
        if (this.getMode() == 2 || this.getMode() == 3) {
            StyledDocument styledDocument = this.getStyledDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
            StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
            StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
            StyleConstants.setBold(simpleAttributeSet, font.isBold());
            StyleConstants.setUnderline(simpleAttributeSet, font.isTransformed());
            styledDocument.setCharacterAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            ((StyledEditorKit)this.getEditorKit()).getInputAttributes().addAttributes(simpleAttributeSet);
        }
    }

    public void setStyledText(String string) {
        int n;
        if (this.mode != 1 && this.mode != 2 && this.mode != 3) {
            throw new InvalidParameterException("Incorrect mode. Expecting modes: [1, 2] Current mode: [" + this.mode + "]");
        }
        Document document = this.getDocument();
        this.unregisterListeners(document);
        super.setText(this.normalizeText(string));
        if (!this.ignoreDefaultFontAttributes) {
            this.forceDefaultFontAttributes();
        }
        if ((n = this.getStartPosition(this.getDocument().getDefaultRootElement())) > 0) {
            try {
                this.getDocument().remove(0, n);
                n = 0;
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        if (this.isEditable()) {
            this.setDefaultFont();
        }
        if (!this.isEditable() && this.mode == 2) {
            this.insertLinks();
        }
        this.setCaretPosition(n);
        this.registerListeners(this.getDocument());
        if (this.mode == 3) {
            boolean bl = false;
            AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
            AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
            if (plainTextReplyFormat.getReplyType() != 0 && plainTextReplyFormat.isReplyInsertAtBottom()) {
                bl = true;
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.FontSize, new Integer(this.getDefaultFontSize()));
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, this.getDefaultFontName());
            if (!bl) {
                ((StyledDocument)this.getDocument()).setCharacterAttributes(0, 1, simpleAttributeSet, true);
            } else {
                ((StyledDocument)this.getDocument()).setCharacterAttributes(this.getDocument().getLength(), this.getDocument().getLength(), simpleAttributeSet, true);
            }
        }
    }

    public void setPlainText(String string) {
        if (this.mode == 1) {
            this.setStyledText(UIUtils.wrapIntoHTML(string));
        } else if (this.mode == 2 || this.mode == 3) {
            this.setStyledText(UIUtils.wrapIntoRTF(string));
            this.insertLinks();
        } else {
            throw new InvalidParameterException("Incorrect mode. Expecting modes: [1, 2] Current mode: [" + this.mode + "]");
        }
        this.setCaretPosition(0);
    }

    public void insertLinks() {
        String string = this.getPlainText();
        int n = -1;
        string = this.removeBrokenHyphen(string);
        Matcher matcher = patternHyperlink.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            char c = string2.charAt(string2.length() - 1);
            if (c == '.' || c == ',') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            n = string.indexOf(string2, n + 1);
            this.insertLink(string2, n);
        }
    }

    private String removeBrokenHyphen(String string) {
        while (string.indexOf(8209) != -1) {
            string = string.replace('\u2011', '-');
        }
        return string;
    }

    private void insertLink(String string, int n) {
        Document document = this.getDocument();
        Style style = this.addStyle(string, StyleContext.getDefaultStyleContext().getStyle("default"));
        if (document instanceof DefaultStyledDocument) {
            style.addAttributes(((DefaultStyledDocument)document).getCharacterElement(n).getAttributes());
        }
        StyleConstants.setItalic(style, true);
        StyleConstants.setUnderline(style, true);
        if (style.getAttribute("foreground") == null) {
            StyleConstants.setForeground(style, Color.BLUE);
        }
        style.addAttribute(LINK_ATTR, string);
        try {
            document.remove(n, string.length());
            document.insertString(n, string, style);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
        }
    }

    private void registerListeners(Document document) {
        document.addDocumentListener(this.editableDocumentListener);
        ApplicationOptions applicationOptions = ApplicationOptions.getInstance();
        boolean bl = applicationOptions.getBoolean("SPELL_CHECKER_AS_YOU_TYPE", true);
        if (bl && this.isEditable()) {
            try {
                JSpellDialog.enableAutoCheck((JTextComponent)this, (String)OS.getDictLanguage());
            }
            catch (Exception exception) {
                applicationOptions.put("SPELL_CHECKER_AS_YOU_TYPE", Boolean.FALSE);
            }
        }
        this.addMouseListener(this.spellCheckListener);
        document.addDocumentListener(this.linkRecognizerDocumentListener);
        document.addUndoableEditListener(this.undoableEditListener);
    }

    private void unregisterListeners(Document document) {
        if (document == null) {
            return;
        }
        document.removeDocumentListener(this.editableDocumentListener);
        boolean bl = ApplicationOptions.getInstance().getBoolean("SPELL_CHECKER_AS_YOU_TYPE", true);
        if (bl && this.isEditable()) {
            JTextAutoSpellCheck.stopChecking((JTextComponent)this);
            this.removeMouseListener(this.spellCheckListener);
        }
        document.removeDocumentListener(this.linkRecognizerDocumentListener);
        document.removeUndoableEditListener(this.undoableEditListener);
    }

    public boolean isIgnoreDefaultFontAttributes() {
        return this.ignoreDefaultFontAttributes;
    }

    public void setIgnoreDefaultFontAttributes(boolean bl) {
        this.ignoreDefaultFontAttributes = bl;
    }

    protected Font increaseFontSize(Font font) {
        if (font instanceof IncreasedFont) {
            return font;
        }
        float f = HTMLUtils.getFontIncreaseFactor();
        int n = Math.round((float)font.getSize() * ((double)f < 1.0 ? 1.0f : f));
        this.fontKey.setValue(font.getFontName(), font.getStyle(), n);
        Font font2 = (Font)fontTable.get(this.fontKey);
        if (font2 == null) {
            font2 = new IncreasedFont(font.getFontName(), font.getStyle(), n);
            try {
                Class<?> clazz = Class.forName("sun.font.FontManager");
                Boolean bl = (Boolean)clazz.getMethod("fontSupportsDefaultEncoding", class$java$awt$Font == null ? (class$java$awt$Font = HTMLTextPane.class$("java.awt.Font")) : class$java$awt$Font).invoke((Object)this, font2);
                if (!bl.booleanValue()) {
                    font2 = (Font)clazz.getMethod("getCompositeFontUIResource", class$java$awt$Font == null ? (class$java$awt$Font = HTMLTextPane.class$("java.awt.Font")) : class$java$awt$Font).invoke((Object)this, font2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            fontTable.put(new FontKey(font.getFontName(), font.getStyle(), n), font2);
        }
        return font2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IncreasedFont
    extends Font {
        public IncreasedFont(String string, int n, int n2) {
            super(string, n, n2);
        }
    }

    private static class DeletePrevWordAction
    extends TextAction {
        public DeletePrevWordAction() {
            super(HTMLTextPane.DELETE_PREV_WORD_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                try {
                    Element element = Utilities.getParagraphElement(jTextComponent, n);
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    if (n < element.getStartOffset()) {
                        n = Utilities.getParagraphElement(jTextComponent, n).getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (n != 0) {
                        n = 0;
                    }
                    bl = true;
                }
                if (!bl) {
                    try {
                        jTextComponent.getDocument().remove(n, jTextComponent.getCaretPosition() - n);
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error((Object)badLocationException);
                        logger.debug((Object)badLocationException, (Throwable)badLocationException);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private static class DeleteNextWordAction
    extends TextAction {
        public DeleteNextWordAction() {
            super(HTMLTextPane.DELETE_NEXT_WORD_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                int n2 = n;
                Element element = Utilities.getParagraphElement(jTextComponent, n);
                try {
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (n >= element.getEndOffset() && n2 != element.getEndOffset() - 1) {
                        n = element.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    int n3 = jTextComponent.getDocument().getLength();
                    if (n != n3) {
                        n = n2 != element.getEndOffset() - 1 ? element.getEndOffset() - 1 : n3;
                    }
                    bl = true;
                }
                if (!bl) {
                    try {
                        jTextComponent.getDocument().remove(jTextComponent.getCaretPosition(), n - jTextComponent.getCaretPosition());
                    }
                    catch (BadLocationException badLocationException) {
                        logger.error((Object)badLocationException);
                        logger.debug((Object)badLocationException, (Throwable)badLocationException);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private class LinkRecognizerDocumentListener
    implements DocumentListener {
        private LinkRecognizerDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Document document = HTMLTextPane.this.getDocument();
            if (document instanceof DefaultStyledDocument) {
                DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)document;
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                String string = "";
                try {
                    string = defaultStyledDocument.getText(n, n2);
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
                if (string.length() == 1 && this.isDivider(string)) {
                    this.replaceIfLink(defaultStyledDocument, n, false, n);
                    return;
                }
                this.checkContainsLink(defaultStyledDocument, string, n);
                AttributeSet attributeSet = defaultStyledDocument.getCharacterElement(n).getAttributes();
                if (attributeSet.isDefined(HTML.Tag.A)) {
                    int n3 = this.getEndDividerOffset(defaultStyledDocument, n);
                    this.replaceIfLink(defaultStyledDocument, n3, true, n + string.length());
                }
            }
        }

        public void checkContainsLink(DefaultStyledDocument defaultStyledDocument, String string, int n) {
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 < string.length() && !this.isDivider(string.substring(n3, n3 + 1))) {
                    ++n3;
                    continue;
                }
                if (this.isLink(string.substring(n2, n3))) {
                    this.replaceIfLink(defaultStyledDocument, n + n3, true, n + n3);
                }
                n2 = ++n3;
                if (n3 >= string.length()) break;
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Document document = HTMLTextPane.this.getDocument();
            if (document instanceof DefaultStyledDocument) {
                DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)document;
                int n = documentEvent.getOffset();
                AttributeSet attributeSet = defaultStyledDocument.getCharacterElement(n).getAttributes();
                if (attributeSet.isDefined(HTML.Tag.A)) {
                    int n2 = this.getEndDividerOffset(defaultStyledDocument, n);
                    this.replaceIfLink(defaultStyledDocument, n2, true, n);
                    return;
                }
                int n3 = n - 1;
                attributeSet = defaultStyledDocument.getCharacterElement(n3).getAttributes();
                if (attributeSet.isDefined(HTML.Tag.A)) {
                    int n4 = this.getEndDividerOffset(defaultStyledDocument, n);
                    this.replaceIfLink(defaultStyledDocument, n4, true, n);
                }
            }
        }

        private int getBeginDividerOffset(DefaultStyledDocument defaultStyledDocument, int n) {
            String string = "";
            int n2 = n;
            while (!this.isDivider(string)) {
                --n2;
                try {
                    string = defaultStyledDocument.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                    break;
                }
            }
            int n3 = this.getEndDividerOffset(defaultStyledDocument, ++n2);
            do {
                try {
                    string = defaultStyledDocument.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                ++n2;
            } while (!this.isLink(string));
            return --n2;
        }

        private int getEndDividerOffset(DefaultStyledDocument defaultStyledDocument, int n) {
            String string = "";
            int n2 = n - 1;
            do {
                ++n2;
                try {
                    string = defaultStyledDocument.getText(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
            } while (!this.isDivider(string));
            return n2;
        }

        private boolean isDivider(String string) {
            char c;
            BitSet bitSet = ControlsUtils.getNotURLDivider();
            return string.length() == 1 && (c = string.charAt(0)) <= '\u0100' && !bitSet.get(c);
        }

        private void replaceIfLink(DefaultStyledDocument defaultStyledDocument, int n, boolean bl, int n2) {
            int n3 = this.getBeginDividerOffset(defaultStyledDocument, n);
            try {
                String string = defaultStyledDocument.getText(n3, n - n3);
                if (this.isLink(string)) {
                    Link link = LinkFinder.getLinkForString(string);
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute("href", link.getNameWithProtocol());
                    SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
                    simpleAttributeSet2.addAttribute(HTML.Tag.A, simpleAttributeSet);
                    simpleAttributeSet2.addAttribute(StyleConstants.Foreground, Color.BLUE);
                    simpleAttributeSet2.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                    simpleAttributeSet2.addAttribute(StyleConstants.Underline, Boolean.TRUE);
                    SwingUtilities.invokeLater(new InsertLinkThread(simpleAttributeSet2, n3, n, defaultStyledDocument, bl, n2));
                } else {
                    AttributeSet attributeSet = defaultStyledDocument.getCharacterElement(n).getAttributes();
                    if (attributeSet.isDefined(HTML.Tag.A)) {
                        SwingUtilities.invokeLater(new InsertLinkThread(new SimpleAttributeSet(), n3, n, defaultStyledDocument, bl, n2));
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }

        private boolean isLink(String string) {
            return string.indexOf("@") > 0 || string.indexOf("www.") == 0 || string.indexOf("ftp.") == 0 || string.indexOf("mailto:") == 0 || string.indexOf("https://") == 0 || string.indexOf("http://") == 0 || string.indexOf("ftp://") == 0 || string.indexOf("news://") == 0 || string.indexOf("gopher://") == 0 || string.indexOf("wais://") == 0;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private class InsertLinkThread
        implements Runnable {
            private int beginOffset;
            private int endOffset;
            private DefaultStyledDocument styledDocument;
            private SimpleAttributeSet tagAttributes;
            private boolean insert;
            private int caretOffset;

            public InsertLinkThread(SimpleAttributeSet simpleAttributeSet, int n, int n2, DefaultStyledDocument defaultStyledDocument, boolean bl, int n3) {
                this.tagAttributes = simpleAttributeSet;
                this.beginOffset = n;
                this.endOffset = n2;
                this.styledDocument = defaultStyledDocument;
                this.insert = bl;
                this.caretOffset = n3;
            }

            public void run() {
                AttributeSet attributeSet = this.styledDocument.getCharacterElement(this.beginOffset).getAttributes();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
                if (((LinkRecognizerDocumentListener)LinkRecognizerDocumentListener.this).HTMLTextPane.this.mode == 1) {
                    simpleAttributeSet.removeAttribute(CSS.Attribute.FONT_STYLE);
                    simpleAttributeSet.removeAttribute(CSS.Attribute.TEXT_DECORATION);
                    simpleAttributeSet.removeAttribute(CSS.Attribute.COLOR);
                    simpleAttributeSet.removeAttribute(HTML.Tag.A);
                } else {
                    StyleConstants.setItalic(simpleAttributeSet, false);
                    StyleConstants.setUnderline(simpleAttributeSet, false);
                    StyleConstants.setForeground(simpleAttributeSet, Color.BLACK);
                }
                HTMLTextPane.this.setSelectionStart(this.beginOffset);
                HTMLTextPane.this.setSelectionEnd(this.endOffset);
                HTMLTextPane.this.setCharacterAttributes(this.tagAttributes, false);
                if (!this.insert) {
                    HTMLTextPane.this.setSelectionStart(this.endOffset);
                    HTMLTextPane.this.setSelectionEnd(this.endOffset + 1);
                    HTMLTextPane.this.setCharacterAttributes(simpleAttributeSet, true);
                    HTMLTextPane.this.setSelectionStart(this.endOffset + 1);
                    HTMLTextPane.this.setSelectionEnd(this.endOffset + 1);
                    HTMLTextPane.this.setCharacterAttributes(simpleAttributeSet, true);
                } else {
                    HTMLTextPane.this.setSelectionStart(this.caretOffset);
                    HTMLTextPane.this.setSelectionEnd(this.caretOffset);
                }
            }
        }
    }
}

