/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.utils.OS;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class HTMLTransferHandler
extends TransferHandler
implements UIResource {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLTransferHandler == null ? (class$com$appframework$components$htmleditor$HTMLTransferHandler = HTMLTransferHandler.class$("com.appframework.components.htmleditor.HTMLTransferHandler")) : class$com$appframework$components$htmleditor$HTMLTransferHandler));
    private TransferHandler th;
    private Position startPosition;
    private Position endPosition;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLTransferHandler;

    public HTMLTransferHandler(TransferHandler transferHandler) {
        this.th = transferHandler;
    }

    public int getSourceActions(JComponent jComponent) {
        return this.th.getSourceActions(jComponent);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable()) {
            return;
        }
        if (this.startPosition != null && this.endPosition != null && n != 1) {
            try {
                ((JTextComponent)jComponent).getDocument().remove(this.startPosition.getOffset(), this.endPosition.getOffset() - this.startPosition.getOffset());
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException);
            }
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        String string = jTextComponent.getSelectedText();
        if (string != null && string.length() > 0) {
            if ((n & 3) > 0) {
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, null);
                super.exportToClipboard(jComponent, clipboard, n);
            }
            if ((n & 2) > 0) {
                jTextComponent.replaceSelection(null);
            }
        }
    }

    protected Transferable createTransferable(JComponent jComponent) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        this.startPosition = null;
        this.endPosition = null;
        StringSelection stringSelection = new StringSelection(((JTextComponent)jComponent).getSelectedText());
        try {
            this.startPosition = jTextComponent.getDocument().createPosition(jTextComponent.getSelectionStart());
            this.endPosition = jTextComponent.getDocument().createPosition(jTextComponent.getSelectionEnd());
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException);
            logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
        return stringSelection;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return this.th.canImport(jComponent, dataFlavorArray);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        this.th.exportAsDrag(jComponent, inputEvent, n);
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return this.th.getVisualRepresentation(transferable);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable()) {
            return false;
        }
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (OS.isMacOS()) {
                    string = string.replaceAll("\r", "\n");
                }
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.error((Object)unsupportedFlavorException, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

