/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.ActionEnablerTextField;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InsertLinkDialog
extends BasicDialog {
    private JTextField tfLinkText;
    private JTextField tfLinkHref;
    private JButton btnOk = new OrientableButton(new BtnOKAction());
    private JButton btnCancel = new OrientableButton(new BtnCancelAction());
    private boolean isActionCompletedSuccesevely = false;
    public static int MAILTO = 0;
    private boolean isMailto = false;

    public InsertLinkDialog(JFrame jFrame, boolean bl) {
        super(jFrame);
        this.setModal(bl);
        this.buildUI();
    }

    public InsertLinkDialog(JFrame jFrame, boolean bl, int n) {
        super(jFrame);
        this.setModal(bl);
        if (n == MAILTO) {
            this.isMailto = true;
        }
        this.buildUI();
    }

    private void buildUI() {
        if (this.isMailto) {
            this.setTitle(StringResources.MAIL_PROPERTIES);
        } else {
            this.setTitle(StringResources.HYPERLINK_PROPERTIES);
        }
        this.getContentPane().setLayout(new BorderLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 10, 5, 15);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)new JLabel(StringResources.TEXT_FOR_HYPERLINK_C), gridBagConstraints);
        gridBagConstraints.fill = 2;
        this.tfLinkText = new OrientableTextField();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        orientablePanel.add((Component)this.tfLinkText, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 15, 5, 15);
        if (this.isMailto) {
            orientablePanel.add((Component)new JLabel(StringResources.EKMAIL_ADDRESS_C), gridBagConstraints);
        } else {
            orientablePanel.add((Component)new JLabel(StringResources.WEB_PAGE_LOCATION_C), gridBagConstraints);
        }
        gridBagConstraints.fill = 2;
        this.tfLinkHref = new ActionEnablerTextField(this.btnOk.getAction());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        orientablePanel.add((Component)this.tfLinkHref, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets.right = 10;
        orientablePanel.add((Component)this.buildButtonsPanel(), gridBagConstraints);
        this.tfLinkHref.setColumns(30);
        this.getContentPane().add((Component)orientablePanel, "Center");
        this.setSize(400, 200);
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4, 5, 5));
        orientablePanel.add(this.btnOk);
        orientablePanel.add(this.btnCancel);
        this.setDefaultButton(this.btnOk);
        this.setCancelButton(this.btnCancel);
        return orientablePanel;
    }

    public void setLinkText(String string) {
        this.tfLinkText.setText(string);
    }

    public String getLinkText() {
        return this.tfLinkText.getText();
    }

    public String getLink() {
        String string = "";
        if (this.isMailto) {
            string = "mailto:" + this.tfLinkHref.getText();
        } else {
            string = this.tfLinkHref.getText();
            if (string.toLowerCase().startsWith("www")) {
                string = "http://" + string;
            }
        }
        return string;
    }

    public boolean isActionCompleteSuccessfully() {
        return this.isActionCompletedSuccesevely;
    }

    JTextField getTfLinkHref() {
        return this.tfLinkHref;
    }

    class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InsertLinkDialog.this.isActionCompletedSuccesevely = false;
            InsertLinkDialog.this.dispose();
        }
    }

    class BtnOKAction
    extends AbstractAction {
        public BtnOKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (InsertLinkDialog.this.tfLinkHref.getText().length() == 0) {
                JOptionPane.showMessageDialog(InsertLinkDialog.this, StringResources.INSERT_A_WEB_PAGE_LOCATION);
                InsertLinkDialog.this.tfLinkHref.grabFocus();
                return;
            }
            if (InsertLinkDialog.this.tfLinkText.getText().length() == 0) {
                InsertLinkDialog.this.tfLinkText.setText(InsertLinkDialog.this.tfLinkHref.getText());
            }
            InsertLinkDialog.this.isActionCompletedSuccesevely = true;
            InsertLinkDialog.this.dispose();
        }
    }
}

