/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.RTFUtils;

public class RTFFontTableEntry {
    public static final String TAG = "f";
    public static final String PREFIX = "\\f";
    private int num = -1;
    private String fontfamily = null;
    private int charset = -1;
    private int prq = -1;
    private String panose = null;
    private String nontaggedname = null;
    private String fontname = null;
    private String fontaltname = null;
    private String fontemb = null;
    private String fonttype = null;
    private String fontfname = null;
    private String codepage = null;
    private boolean ok = false;
    private String result = "";

    public RTFFontTableEntry(String string) {
        this.parse(string);
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int n) {
        this.num = n;
    }

    public String getFontfamily() {
        return this.fontfamily;
    }

    public void setFontfamily(String string) {
        this.fontfamily = string;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int n) {
        this.charset = n;
    }

    public int getPrq() {
        return this.prq;
    }

    public void setPrq(int n) {
        this.prq = n;
    }

    public String getPanose() {
        return this.panose;
    }

    public void setPanose(String string) {
        this.panose = string;
    }

    public String getNontaggedname() {
        return this.nontaggedname;
    }

    public void setNontaggedname(String string) {
        this.nontaggedname = string;
    }

    public String getFontname() {
        return this.fontname;
    }

    public void setFontname(String string) {
        this.fontname = string;
    }

    public String getFontaltname() {
        return this.fontaltname;
    }

    public void setFontaltname(String string) {
        this.fontaltname = string;
    }

    public String getFontemb() {
        return this.fontemb;
    }

    public void setFontemb(String string) {
        this.fontemb = string;
    }

    public String getFonttype() {
        return this.fonttype;
    }

    public void setFonttype(String string) {
        this.fonttype = string;
    }

    public String getFontfname() {
        return this.fontfname;
    }

    public void setFontfname(String string) {
        this.fontfname = string;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String string) {
        this.codepage = string;
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getResult() {
        return this.result;
    }

    private void parse(String string) {
        if (string == null || string.length() < 1) {
            this.result = "Null or empty input string [" + string + "]";
            return;
        }
        if (!string.startsWith("{\\f")) {
            this.result = "Missing START bracket [" + string + "]";
            return;
        }
        if (!string.endsWith(";}")) {
            this.result = "Missing closing bracket [" + string + "]";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(1, string.length() - ";}".length()));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (stringBuffer.length() > 0 && n < stringBuffer.length()) {
            String string2;
            int n2;
            char c = stringBuffer.charAt(n);
            if (c == '\\') {
                bl = true;
            } else if (c == 'f') {
                if (bl) {
                    bl2 = true;
                }
            } else if (c == '*') {
                if (bl) {
                    bl3 = true;
                    bl = false;
                }
            } else if (c == '{') {
                n2 = n;
                while (n < stringBuffer.length() && stringBuffer.charAt(n++) != '}') {
                }
                string2 = stringBuffer.substring(n2, n);
                this.parseSubgroup(string2);
                stringBuffer.delete(n2, n);
                n = n2;
            } else if (bl3 && c == 'p') {
                if (stringBuffer.substring(n).startsWith("panose")) {
                    this.setPanose("");
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                }
            } else {
                if (bl2) {
                    String string3;
                    char c2;
                    n2 = n;
                    while (++n < stringBuffer.length() && (c2 = stringBuffer.charAt(n)) != '\\' && c2 != ' ') {
                    }
                    string2 = stringBuffer.substring(n2, n);
                    if (RTFUtils.isNumber(string2)) {
                        if (this.getNum() == -1) {
                            this.setNum(Integer.parseInt(string2));
                        }
                    } else if ("nil".equals(string2) || "roman".equals(string2) || "swiss".equals(string2) || "tech".equals(string2) || "modern".equals(string2) || "script".equals(string2) || "decor".equals(string2) || "bidi".equals(string2)) {
                        if (this.getFontfamily() == null) {
                            this.setFontfamily(string2);
                        }
                    } else if (string2.startsWith("charset")) {
                        string3 = string2.substring("charset".length());
                        if (RTFUtils.isNumber(string3) && this.getCharset() == -1) {
                            this.setCharset(Integer.parseInt(string3));
                        }
                    } else if (string2.startsWith("prq")) {
                        string3 = string2.substring("prq".length());
                        if (RTFUtils.isNumber(string3) && this.getPrq() == -1) {
                            this.setPrq(Integer.parseInt(string3));
                        }
                    } else if ("tnil".equals(string2) || "ttruetype".equals(string2)) {
                        if (this.getFonttype() == null) {
                            this.setFonttype(string2);
                        }
                    } else if (bl3 && "name".equals(string2)) {
                        if (this.getNontaggedname() == null) {
                            this.setNontaggedname(string2.substring("name".length() + 1));
                        }
                        bl3 = false;
                    }
                    bl = false;
                    bl2 = false;
                    continue;
                }
                n2 = n + 1;
                while (n < stringBuffer.length() && stringBuffer.charAt(n++) != '\\') {
                }
                string2 = stringBuffer.substring(n2, n);
                if (this.getFontname() != null) continue;
                this.setFontname(string2);
                continue;
            }
            ++n;
        }
        this.ok = true;
    }

    private void parseSubgroup(String string) {
        System.out.println(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Font #").append(this.getNum()).append(":\n");
        stringBuffer.append("\tcharset: ").append(this.getCharset()).append("\n");
        stringBuffer.append("\tfamily: ").append(this.getFontfamily()).append("\n");
        stringBuffer.append("\tprq: ").append(this.getPrq()).append("\n");
        stringBuffer.append("\tname: ").append(this.getFontname()).append("\n");
        return stringBuffer.toString();
    }
}

