/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.RTFFontTable;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class RTFUtils {
    private static RTFUtils instance = new RTFUtils();
    public static final String RTF_STYLESHEET_GROUP = "stylesheet";
    public static final String RTF_COLORTBL_GROUP = "colortbl";
    public static final String RTF_FILETBL_GROUP = "filetbl";
    public static final String RTF_FONTTBL_GROUP = "fonttbl";
    public static final String RTF_DEFF_KEYWORD = "deff";

    public static int indexOfKeyword(String string, String string2) {
        int n = -1;
        int n2 = string.indexOf("\\" + string2);
        if (n2 > 0 && string.charAt(n2 - 1) != '\\') {
            n = n2;
        }
        return n;
    }

    public static int indexOfGroupBegin(String string, String string2) {
        return string.indexOf("{\\" + string2);
    }

    public static int indexOfGroupEnd(String string, String string2) {
        int n;
        int n2 = RTFUtils.indexOfGroupBegin(string, string2);
        if (n2 == -1) {
            return n2;
        }
        int n3 = n2 + string2.length() + 2;
        StringReader stringReader = new StringReader(string.substring(n3));
        int n4 = 1;
        do {
            try {
                n = stringReader.read();
                ++n3;
                switch (n) {
                    case 123: {
                        ++n4;
                        break;
                    }
                    case 125: {
                        if (--n4 != 0) break;
                        return n3 - 1;
                    }
                }
            }
            catch (IOException iOException) {
                break;
            }
        } while (n != -1);
        return -1;
    }

    public static String getGroupWiseRTFStyleDefinition(int n) {
        return "{\\fs" + n * 2 + " GroupWiseView;}";
    }

    public static String getGroupWiseRTFStyleInStylesheet(int n) {
        return "{\\stylesheet" + RTFUtils.getGroupWiseRTFStyleDefinition(n) + "}";
    }

    public static String insertGWStyleDefinition(String string, int n) {
        String string2 = string;
        int n2 = RTFUtils.indexOfGroupBegin(string, RTF_STYLESHEET_GROUP);
        if (n2 > 0) {
            n2 = n2 + RTF_STYLESHEET_GROUP.length() + 2;
            string2 = RTFUtils.insertString(string, n2, RTFUtils.getGroupWiseRTFStyleDefinition(n));
        } else {
            n2 = RTFUtils.indexOfGroupEnd(string, RTF_COLORTBL_GROUP);
            if (n2 > 0) {
                string2 = RTFUtils.insertString(string, n2 + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(n));
            } else {
                n2 = RTFUtils.indexOfGroupEnd(string, RTF_FILETBL_GROUP);
                if (n2 > 0) {
                    string2 = RTFUtils.insertString(string, n2 + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(n));
                } else {
                    n2 = RTFUtils.indexOfGroupEnd(string, RTF_FONTTBL_GROUP);
                    if (n2 > 0) {
                        string2 = RTFUtils.insertString(string, n2 + 1, RTFUtils.getGroupWiseRTFStyleInStylesheet(n));
                    }
                }
            }
        }
        if (RTFUtils.indexOfKeyword(string2, RTF_DEFF_KEYWORD) < 0 && (n2 = RTFUtils.indexOfGroupBegin(string, RTF_FONTTBL_GROUP)) > 0) {
            String string3;
            List list;
            int n3 = 0;
            RTFFontTable rTFFontTable = RTFUtils.parseFontTable(string2);
            if (rTFFontTable != null && (list = rTFFontTable.getFontIDsByFontName(string3 = HTMLConstants.getDefaultFontName(3))).size() > 0) {
                n3 = (Integer)list.get(0);
            }
            string2 = RTFUtils.insertString(string2, n2, "\\deff" + n3);
        }
        return string2;
    }

    public static String insertString(String string, int n, String string2) {
        if (n < 0 || n > string.length()) {
            throw new IllegalArgumentException("Incorrect index: [" + n + "]");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static RTFFontTable parseFontTable(String string) {
        RTFFontTable rTFFontTable = null;
        int n = RTFUtils.indexOfGroupBegin(string, RTF_FONTTBL_GROUP);
        int n2 = RTFUtils.indexOfGroupEnd(string, RTF_FONTTBL_GROUP);
        if (n > 0 && n2 > n) {
            rTFFontTable = new RTFFontTable(string.substring(n, n2 + 1));
        }
        return rTFFontTable;
    }
}

